/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jvxl.simplewriter;

import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.V3;
import org.jmol.jvxl.calc.MarchingCubes;
import org.jmol.jvxl.data.JvxlData;
import org.jmol.jvxl.data.VolumeData;
import org.jmol.jvxl.readers.Parameters;
import org.openscience.jvxl.simplewriter.VoxelDataCreator;

public class SimpleMarchingCubes
extends MarchingCubes {
    private boolean doCalcArea;
    private boolean doSaveSurfacePoints;
    private float calculatedArea = Float.NaN;
    private float calculatedVolume = Float.NaN;
    private Lst<P3> surfacePoints;
    private VoxelDataCreator vdc;
    private V3 vTemp = new V3();
    private V3 vAC = new V3();
    private V3 vAB = new V3();

    public SimpleMarchingCubes(VoxelDataCreator voxelDataCreator, VolumeData volumeData, Parameters parameters, JvxlData jvxlData, Lst<P3> lst, float[] fArray) {
        this.vdc = voxelDataCreator;
        this.mode = voxelDataCreator == null ? 1 : 3;
        this.setParameters(volumeData, parameters);
        this.doCalcArea = fArray != null;
        this.surfacePoints = lst;
        if (this.surfacePoints == null && this.doCalcArea) {
            this.surfacePoints = new Lst();
        }
        this.doSaveSurfacePoints = this.surfacePoints != null;
        jvxlData.jvxlEdgeData = this.getEdgeData();
        jvxlData.nPointsX = volumeData.voxelCounts[0];
        jvxlData.nPointsY = volumeData.voxelCounts[1];
        jvxlData.nPointsZ = volumeData.voxelCounts[2];
        jvxlData.setSurfaceInfoFromBitSet(this.bsVoxels, null);
        if (this.doCalcArea) {
            fArray[0] = this.calculatedArea;
            fArray[1] = this.calculatedVolume;
        }
    }

    protected float getValue(int n, int n2, int n3, int n4, int n5, float[] fArray) {
        float f;
        if (this.bsValues.get(n5)) {
            return fArray[n5 % this.yzCount];
        }
        this.bsValues.set(n5);
        fArray[n5 % this.yzCount] = f = this.vdc.getValue(n2, n3, n4);
        if (SimpleMarchingCubes.isInside(f, this.cutoff, this.isCutoffAbsolute)) {
            this.bsVoxels.set(n5);
        }
        return f;
    }

    protected int newVertex(P3 p3, V3 v3, float f) {
        if (this.doSaveSurfacePoints) {
            P3 p32 = new P3();
            p32.scaleAdd2(f, v3, p3);
            this.surfacePoints.addLast(p32);
        }
        return this.edgeCount++;
    }

    @Override
    protected void processTriangles(int n) {
        if (this.doCalcArea) {
            super.processTriangles(n);
        }
    }

    @Override
    protected void addTriangle(int n, int n2, int n3, int n4) {
        P3 p3 = (P3)this.surfacePoints.get(this.edgePointIndexes[n]);
        P3 p32 = (P3)this.surfacePoints.get(this.edgePointIndexes[n2]);
        P3 p33 = (P3)this.surfacePoints.get(this.edgePointIndexes[n3]);
        this.vAB.sub2(p32, p3);
        this.vAC.sub2(p33, p3);
        this.vTemp.cross(this.vAB, this.vAC);
        float f = this.vTemp.length() / 2.0f;
        this.calculatedArea += f;
        this.vAB.setT(p32);
        this.vAC.setT(p33);
        this.vTemp.cross(this.vAB, this.vAC);
        this.vAC.setT(p3);
        this.calculatedVolume += this.vAC.dot(this.vTemp) / 6.0f;
    }
}

