/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jvxl.simplewriter;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import javajs.util.Lst;
import javajs.util.P3;
import org.jmol.jvxl.data.JvxlCoder;
import org.jmol.jvxl.data.JvxlData;
import org.jmol.jvxl.data.VolumeData;
import org.jmol.jvxl.readers.Parameters;
import org.openscience.jvxl.simplewriter.SimpleMarchingCubes;
import org.openscience.jvxl.simplewriter.VoxelDataCreator;

public class ASimpleJvxlWriter {
    public static void main(String[] stringArray) {
        Parameters parameters = new Parameters();
        String string = "c:/temp/simple.jvxl";
        parameters.cutoff = 0.01f;
        parameters.isCutoffAbsolute = false;
        int n = 31;
        int n2 = 31;
        int n3 = 31;
        String[] stringArray2 = new String[]{"created by SimpleJvxlWriter " + new SimpleDateFormat("yyyy-MM-dd', 'HH:mm").format(new Date())};
        VolumeData volumeData = new VolumeData();
        volumeData.setVolumetricOrigin(0.0f, 0.0f, 0.0f);
        volumeData.setVolumetricVector(0, 1.0f, 0.0f, 0.0f);
        volumeData.setVolumetricVector(1, 0.0f, 1.0f, 0.0f);
        volumeData.setVolumetricVector(2, 0.0f, 0.0f, 1.0f);
        volumeData.setVoxelCounts(n, n2, n3);
        VoxelDataCreator voxelDataCreator = new VoxelDataCreator(volumeData);
        voxelDataCreator.createVoxelData();
        float[] fArray = new float[2];
        Lst<P3> lst = new Lst<P3>();
        parameters.isXLowToHigh = false;
        ASimpleJvxlWriter.writeFile(String.valueOf(string) + "A", ASimpleJvxlWriter.jvxlGetData(null, parameters, volumeData, stringArray2, lst, fArray));
        System.out.println("calculated area = " + fArray[0] + " volume = " + fArray[1] + " for " + lst.size() + " surface points");
        volumeData.setVoxelDataAsArray(null);
        parameters.isXLowToHigh = true;
        ASimpleJvxlWriter.writeFile(String.valueOf(string) + "B", ASimpleJvxlWriter.jvxlGetData(voxelDataCreator, parameters, volumeData, stringArray2, lst, fArray));
        System.out.flush();
        System.exit(0);
    }

    public static String jvxlGetData(VoxelDataCreator voxelDataCreator, Parameters parameters, VolumeData volumeData, String[] stringArray, Lst<P3> lst, float[] fArray) {
        JvxlData jvxlData = new JvxlData();
        new SimpleMarchingCubes(voxelDataCreator, volumeData, parameters, jvxlData, lst, fArray);
        jvxlData.isXLowToHigh = parameters.isXLowToHigh;
        jvxlData.cutoff = parameters.cutoff;
        jvxlData.isCutoffAbsolute = parameters.isCutoffAbsolute;
        jvxlData.version = "ASimpleJvxlWriter -- version 2.2";
        return JvxlCoder.jvxlGetFile(volumeData, jvxlData, stringArray);
    }

    static void writeFile(String string, String string2) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(fileOutputStream), 8192);
            bufferedWriter.write(string2);
            bufferedWriter.close();
            fileOutputStream = null;
        }
        catch (IOException iOException) {
            System.out.println("IO Exception: " + iOException.toString());
        }
    }
}

