#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: QuickCheck
version: 2.12.6.1
id: QuickCheck-2.12.6.1-FurF8Z9cNC7LPdADW0NOg6
key: QuickCheck-2.12.6.1-FurF8Z9cNC7LPdADW0NOg6
license: BSD-3-Clause
copyright: 2000-2018 Koen Claessen, 2006-2008 Björn Bringert, 2009-2018 Nick Smallbone
maintainer: Nick Smallbone <nick@smallbone.se>
author: Koen Claessen <koen@chalmers.se>
homepage: https://github.com/nick8325/quickcheck
synopsis: Automatic testing of Haskell programs
description:
    QuickCheck is a library for random testing of program properties.
    The programmer provides a specification of the program, in the form of
    properties which functions should satisfy, and QuickCheck then tests that the
    properties hold in a large number of randomly generated cases.
    Specifications are expressed in Haskell, using combinators provided by
    QuickCheck. QuickCheck provides combinators to define properties, observe the
    distribution of test data, and define test data generators.
    .
    Most of QuickCheck'\''s functionality is exported by the main "Test.QuickCheck"
    module. The main exception is the monadic property testing library in
    "Test.QuickCheck.Monadic".
    .
    If you are new to QuickCheck, you can try looking at the following resources:
    .
    * The <http://www.cse.chalmers.se/~rjmh/QuickCheck/manual.html official QuickCheck manual>.
    It'\''s a bit out-of-date in some details and doesn'\''t cover newer QuickCheck features,
    but is still full of good advice.
    * <https://begriffs.com/posts/2017-01-14-design-use-quickcheck.html>,
    a detailed tutorial written by a user of QuickCheck.
    .
    The <http://hackage.haskell.org/package/quickcheck-instances quickcheck-instances>
    companion package provides instances for types in Haskell Platform packages
    at the cost of additional dependencies.
category: Testing
abi: 952d5772f7c2e2587dade87ea49dc0b5
exposed: True
exposed-modules:
    Test.QuickCheck Test.QuickCheck.All Test.QuickCheck.Arbitrary
    Test.QuickCheck.Exception Test.QuickCheck.Features
    Test.QuickCheck.Function Test.QuickCheck.Gen
    Test.QuickCheck.Gen.Unsafe Test.QuickCheck.Modifiers
    Test.QuickCheck.Monadic Test.QuickCheck.Poly
    Test.QuickCheck.Property Test.QuickCheck.Random
    Test.QuickCheck.State Test.QuickCheck.Test Test.QuickCheck.Text
import-dirs: /usr/lib/ghc-8.6.4/site-local/QuickCheck-2.12.6.1
library-dirs: /usr/lib/ghc-8.6.4/site-local/QuickCheck-2.12.6.1
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/x86_64-linux-ghc-8.6.4/QuickCheck-2.12.6.1
hs-libraries: HSQuickCheck-2.12.6.1-FurF8Z9cNC7LPdADW0NOg6
depends:
    base-4.12.0.0 containers-0.6.0.1 deepseq-1.4.4.0
    erf-2.0.0.0-ExhHoenPosmHlOroBQQced
    random-1.1-3ypV4EIycgb35PKjTYYr5q template-haskell-2.14.0.0
    tf-random-0.5-IjFVdJXpGgq3hBuRJiaT27 transformers-0.5.6.2
haddock-interfaces: /usr/share/doc/haskell-quickcheck/html/QuickCheck.haddock
haddock-html: /usr/share/doc/haskell-quickcheck/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

