/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.history.changes;

import org.gradle.api.Describable;
import org.gradle.internal.change.CachingChangeContainer;
import org.gradle.internal.change.Change;
import org.gradle.internal.change.ChangeContainer;
import org.gradle.internal.change.ChangeDetectorVisitor;
import org.gradle.internal.change.ChangeVisitor;
import org.gradle.internal.change.CollectingChangeVisitor;
import org.gradle.internal.change.ErrorHandlingChangeContainer;
import org.gradle.internal.change.SummarizingChangeContainer;
import org.gradle.internal.execution.history.AfterPreviousExecutionState;
import org.gradle.internal.execution.history.BeforeExecutionState;
import org.gradle.internal.execution.history.changes.ExecutionStateChanges;
import org.gradle.internal.execution.history.changes.ImplementationChanges;
import org.gradle.internal.execution.history.changes.InputFileChanges;
import org.gradle.internal.execution.history.changes.InputValueChanges;
import org.gradle.internal.execution.history.changes.OutputFileChanges;
import org.gradle.internal.execution.history.changes.PreviousSuccessChanges;
import org.gradle.internal.execution.history.changes.PropertyChanges;

public class DefaultExecutionStateChanges
implements ExecutionStateChanges {
    private final AfterPreviousExecutionState previousExecution;
    private final ChangeContainer inputFileChanges;
    private final ChangeContainer allChanges;
    private final ChangeContainer rebuildTriggeringChanges;

    public DefaultExecutionStateChanges(AfterPreviousExecutionState lastExecution, BeforeExecutionState thisExecution, Describable executable) {
        this.previousExecution = lastExecution;
        PreviousSuccessChanges previousSuccessState = new PreviousSuccessChanges(lastExecution.isSuccessful());
        ImplementationChanges implementationChanges = new ImplementationChanges(lastExecution.getImplementation(), lastExecution.getAdditionalImplementations(), thisExecution.getImplementation(), thisExecution.getAdditionalImplementations(), executable);
        PropertyChanges inputPropertyChanges = new PropertyChanges(lastExecution.getInputProperties(), thisExecution.getInputProperties(), "Input", executable);
        InputValueChanges inputPropertyValueChanges = new InputValueChanges(lastExecution.getInputProperties(), thisExecution.getInputProperties(), executable);
        PropertyChanges inputFilePropertyChanges = new PropertyChanges(lastExecution.getInputFileProperties(), thisExecution.getInputFileProperties(), "Input file", executable);
        InputFileChanges directInputFileChanges = new InputFileChanges(lastExecution.getInputFileProperties(), thisExecution.getInputFileProperties());
        ChangeContainer inputFileChanges = DefaultExecutionStateChanges.caching(directInputFileChanges);
        this.inputFileChanges = DefaultExecutionStateChanges.errorHandling(executable, inputFileChanges);
        PropertyChanges outputFilePropertyChanges = new PropertyChanges(lastExecution.getOutputFileProperties(), thisExecution.getOutputFileProperties(), "Output", executable);
        OutputFileChanges uncachedOutputChanges = new OutputFileChanges(lastExecution.getOutputFileProperties(), thisExecution.getOutputFileProperties());
        ChangeContainer outputFileChanges = DefaultExecutionStateChanges.caching(uncachedOutputChanges);
        this.allChanges = DefaultExecutionStateChanges.errorHandling(executable, (ChangeContainer)new SummarizingChangeContainer(new ChangeContainer[]{previousSuccessState, implementationChanges, inputPropertyChanges, inputPropertyValueChanges, outputFilePropertyChanges, outputFileChanges, inputFilePropertyChanges, inputFileChanges}));
        this.rebuildTriggeringChanges = DefaultExecutionStateChanges.errorHandling(executable, (ChangeContainer)new SummarizingChangeContainer(new ChangeContainer[]{previousSuccessState, implementationChanges, inputPropertyChanges, inputPropertyValueChanges, inputFilePropertyChanges, outputFilePropertyChanges, outputFileChanges}));
    }

    private static ChangeContainer caching(ChangeContainer wrapped) {
        return new CachingChangeContainer(3, wrapped);
    }

    private static ChangeContainer errorHandling(Describable executable, ChangeContainer wrapped) {
        return new ErrorHandlingChangeContainer(executable, wrapped);
    }

    @Override
    public Iterable<Change> getInputFilesChanges() {
        CollectingChangeVisitor visitor = new CollectingChangeVisitor();
        this.inputFileChanges.accept((ChangeVisitor)visitor);
        return visitor.getChanges();
    }

    @Override
    public void visitAllChanges(ChangeVisitor visitor) {
        this.allChanges.accept(visitor);
    }

    @Override
    public boolean isRebuildRequired() {
        ChangeDetectorVisitor changeDetectorVisitor = new ChangeDetectorVisitor();
        this.rebuildTriggeringChanges.accept((ChangeVisitor)changeDetectorVisitor);
        return changeDetectorVisitor.hasAnyChanges();
    }

    @Override
    public AfterPreviousExecutionState getPreviousExecution() {
        return this.previousExecution;
    }
}

