# How we manage the TLS protocol CRIME vulnerability

> CRIME ("Compression Ratio Info-leak Made Easy") is a security exploit against
secret web cookies over connections using the HTTPS and SPDY protocols that also
use data compression. When used to recover the content of secret
authentication cookies, it allows an attacker to perform session hijacking on an
authenticated web session, allowing the launching of further attacks.
([CRIME](https://en.wikipedia.org/w/index.php?title=CRIME&oldid=692423806))

### Description

The TLS Protocol CRIME Vulnerability affects compression over HTTPS, therefore
it warns against using SSL Compression (for example gzip) or SPDY which
optionally uses compression as well.

GitLab supports both gzip and [SPDY][ngx-spdy] and mitigates the CRIME
vulnerability by deactivating gzip when HTTPS is enabled. You can see the
sources of the files in question:

- [Source installation NGINX file][source-nginx]
- [Omnibus installation NGINX file][omnibus-nginx]

Although SPDY is enabled in Omnibus installations, CRIME relies on compression
(the 'C') and the default compression level in NGINX's SPDY module is 0
(no compression).

### Nessus

The Nessus scanner, [reports a possible CRIME vulnerability][nessus] in GitLab
similar to the following format:

```
Description

This remote service has one of two configurations that are known to be required for the CRIME attack:
SSL/TLS compression is enabled.
TLS advertises the SPDY protocol earlier than version 4.

...

Output

The following configuration indicates that the remote service may be vulnerable to the CRIME attack:
SPDY support earlier than version 4 is advertised.
```

From the report above it is important to note that Nessus is only checking if
TLS advertises the SPDY protocol earlier than version 4, it does not perform an
attack nor does it check if compression is enabled. With just this approach, it
cannot tell that SPDY's compression is disabled and not subject to the CRIME
vulnerability.

### References

- Nginx ["Module ngx_http_spdy_module"][ngx-spdy]
- Tenable Network Security, Inc. ["Transport Layer Security (TLS) Protocol CRIME Vulnerability"][nessus]
- Wikipedia contributors, ["CRIME"][wiki-crime] Wikipedia, The Free Encyclopedia

[source-nginx]: https://gitlab.com/gitlab-org/gitlab-ce/blob/master/lib/support/nginx/gitlab-ssl
[omnibus-nginx]: https://gitlab.com/gitlab-org/omnibus-gitlab/blob/master/files/gitlab-cookbooks/gitlab/templates/default/nginx-gitlab-http.conf.erb
[ngx-spdy]: http://nginx.org/en/docs/http/ngx_http_spdy_module.html
[nessus]: https://www.tenable.com/plugins/index.php?view=single&id=62565
[wiki-crime]: https://en.wikipedia.org/wiki/CRIME
