define(["filerepository","transfermanager","localdatabase"],function(filerepository,transfermanager,localdatabase){"use strict";function removeLocalItem(localItem){return localdatabase.getLibraryItem(localItem.ServerId,localItem.Id).then(function(item){var onFileDeletedSuccessOrFail=function(){return localdatabase.deleteLibraryItem(localItem.ServerId,localItem.Id)},p=Promise.resolve();return item.LocalPath&&(p=p.then(function(){return filerepository.deleteFile(item.LocalPath)})),item&&item.Item&&item.Item.MediaSources&&item.Item.MediaSources.forEach(function(mediaSource){mediaSource.MediaStreams&&mediaSource.MediaStreams.length>0&&mediaSource.MediaStreams.forEach(function(mediaStream){mediaStream.Path&&(p=p.then(function(){return filerepository.deleteFile(mediaStream.Path)}))})}),p.then(onFileDeletedSuccessOrFail,onFileDeletedSuccessOrFail)},function(){return Promise.resolve()})}function getSubtitleSaveFileName(localItem,mediaPath,language,isForced,format){var name=getNameWithoutExtension(mediaPath);name=filerepository.getValidFileName(name),language&&(name+="."+language.toLowerCase()),isForced&&(name+=".foreign"),name=name+"."+format.toLowerCase();var mediaFolder=filerepository.getParentPath(localItem.LocalPath);return filerepository.combinePath(mediaFolder,name)}function getItemFileSize(path){return filerepository.getItemFileSize(path)}function getNameWithoutExtension(path){var fileName=path,pos=fileName.lastIndexOf(".");return pos>0&&(fileName=fileName.substring(0,pos)),fileName}function downloadFile(url,localItem){var imageUrl=getImageUrl(localItem.Item.ServerId,localItem.Item.Id,{type:"Primary",index:0});return transfermanager.downloadFile(url,localItem,imageUrl)}function downloadSubtitles(url,fileName){return transfermanager.downloadSubtitles(url,fileName)}function getImageUrl(serverId,itemId,imageOptions){var imageType=imageOptions.type,index=imageOptions.index,pathArray=getImagePath(serverId,itemId,imageType,index);return filerepository.getImageUrl(pathArray)}function hasImage(serverId,itemId,imageType,index){var pathArray=getImagePath(serverId,itemId,imageType,index),localFilePath=filerepository.getFullMetadataPath(pathArray);return filerepository.fileExists(localFilePath).then(function(exists){return Promise.resolve(exists)},function(){return Promise.resolve(!1)})}function fileExists(localFilePath){return filerepository.fileExists(localFilePath)}function downloadImage(localItem,url,serverId,itemId,imageType,index){var localPathParts=getImagePath(serverId,itemId,imageType,index);return transfermanager.downloadImage(url,localPathParts)}function isDownloadFileInQueue(path){return transfermanager.isDownloadFileInQueue(path)}function getDownloadItemCount(){return transfermanager.getDownloadItemCount()}function getDirectoryPath(item){var parts=[],itemtype=item.Type.toLowerCase(),mediaType=(item.MediaType||"").toLowerCase();"episode"===itemtype||"series"===itemtype||"season"===itemtype?parts.push("TV"):"video"===mediaType?parts.push("Videos"):"audio"===itemtype||"musicalbum"===itemtype||"musicartist"===itemtype?parts.push("Music"):"photo"===itemtype||"photoalbum"===itemtype?parts.push("Photos"):"game"!==itemtype&&"gamesystem"!==itemtype||parts.push("Games");var albumArtist=item.AlbumArtist;albumArtist&&parts.push(albumArtist);var seriesName=item.SeriesName;seriesName&&parts.push(seriesName);var seasonName=item.SeasonName;seasonName&&parts.push(seasonName),item.Album&&parts.push(item.Album),("video"===mediaType&&"episode"!==itemtype||"game"===itemtype||item.IsFolder)&&parts.push(item.Name);for(var finalParts=[],i=0;i<parts.length;i++)finalParts.push(filerepository.getValidFileName(parts[i]));return finalParts}function getImagePath(serverId,itemId,imageType,index){var parts=[];parts.push("images"),index=index||0,parts.push(itemId+"_"+imageType+"_"+index.toString());for(var finalParts=[],i=0;i<parts.length;i++)finalParts.push(parts[i]);return finalParts}function getLocalFileName(item,originalFileName){var filename=originalFileName||item.Name;return filerepository.getValidFileName(filename)}function resyncTransfers(){return transfermanager.resyncTransfers()}function enableBackgroundCompletion(){return transfermanager.enableBackgroundCompletion}return{getDirectoryPath:getDirectoryPath,getLocalFileName:getLocalFileName,removeLocalItem:removeLocalItem,downloadFile:downloadFile,downloadSubtitles:downloadSubtitles,hasImage:hasImage,downloadImage:downloadImage,getImageUrl:getImageUrl,getSubtitleSaveFileName:getSubtitleSaveFileName,getItemFileSize:getItemFileSize,isDownloadFileInQueue:isDownloadFileInQueue,getDownloadItemCount:getDownloadItemCount,resyncTransfers:resyncTransfers,fileExists:fileExists,enableBackgroundCompletion:enableBackgroundCompletion}});