/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.PolymerBehaviorExtractor;
import com.google.javascript.jscomp.PolymerClassDefinition;
import com.google.javascript.jscomp.PolymerPass;
import com.google.javascript.jscomp.PolymerPassErrors;
import com.google.javascript.jscomp.PolymerPassStaticUtils;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import java.util.HashMap;
import java.util.List;

final class PolymerClassRewriter {
    private final AbstractCompiler compiler;
    private Node polymerElementExterns;

    PolymerClassRewriter(AbstractCompiler compiler, Node polymerElementExterns) {
        this.compiler = compiler;
        this.polymerElementExterns = polymerElementExterns;
    }

    void rewritePolymerClass(Node exprRoot, PolymerClassDefinition cls, boolean isInGlobalScope) {
        Node call = exprRoot.getFirstChild();
        if (call.isAssign()) {
            call = call.getSecondChild();
        } else if (call.isName()) {
            call = call.getFirstChild();
        }
        Node objLit = cls.descriptor;
        if (PolymerClassRewriter.hasShorthandAssignment(objLit)) {
            this.compiler.report(JSError.make(objLit, PolymerPassErrors.POLYMER_SHORTHAND_NOT_SUPPORTED, new String[0]));
            return;
        }
        JSDocInfoBuilder objLitDoc = new JSDocInfoBuilder(true);
        objLitDoc.recordLends(cls.target.getQualifiedName() + ".prototype");
        objLit.setJSDocInfo(objLitDoc.build());
        this.addTypesToFunctions(objLit, cls.target.getQualifiedName());
        PolymerPassStaticUtils.switchDollarSignPropsToBrackets(objLit, this.compiler);
        PolymerPassStaticUtils.quoteListenerAndHostAttributeKeys(objLit);
        Node block = IR.block();
        JSDocInfoBuilder constructorDoc = this.getConstructorDoc(cls);
        Node ctorKey = cls.constructor.value.getParent();
        if (ctorKey != null) {
            ctorKey.removeProp(29);
        }
        if (cls.target.isGetProp()) {
            Node assign = IR.assign(cls.target.cloneTree(), cls.constructor.value.cloneTree());
            assign.setJSDocInfo(constructorDoc.build());
            Node exprResult = IR.exprResult(assign);
            block.addChildToBack(exprResult);
        } else {
            Node var = IR.var(cls.target.cloneTree(), cls.constructor.value.cloneTree());
            var.setJSDocInfo(constructorDoc.build());
            block.addChildToBack(var);
        }
        this.appendPropertiesToBlock(cls, block, cls.target.getQualifiedName() + ".prototype.");
        this.appendBehaviorMembersToBlock(cls, block);
        ImmutableList<PolymerPass.MemberDefinition> readOnlyProps = this.parseReadOnlyProperties(cls, block);
        this.addInterfaceExterns(cls, (List<PolymerPass.MemberDefinition>)readOnlyProps);
        this.removePropertyDocs(objLit);
        block.useSourceInfoIfMissingFromForTree(exprRoot);
        Node statements = block.removeChildren();
        Node parent = exprRoot.getParent();
        if (!isInGlobalScope && !cls.target.isGetProp()) {
            Node scriptNode = NodeUtil.getEnclosingScript(exprRoot);
            scriptNode.addChildrenToFront(statements);
        } else {
            Node beforeRoot = parent.getChildBefore(exprRoot);
            if (beforeRoot == null) {
                parent.addChildrenToFront(statements);
            } else {
                parent.addChildrenAfter(statements, beforeRoot);
            }
        }
        if (NodeUtil.isNameDeclaration(exprRoot)) {
            Node assignExpr = PolymerClassRewriter.varToAssign(exprRoot);
            parent.replaceChild(exprRoot, assignExpr);
        }
        this.compiler.reportCodeChange();
    }

    private void addTypesToFunctions(Node objLit, String thisType) {
        Preconditions.checkState((boolean)objLit.isObjectLit());
        for (Node keyNode : objLit.children()) {
            Node value = keyNode.getLastChild();
            if (value == null || !value.isFunction()) continue;
            JSDocInfoBuilder fnDoc = JSDocInfoBuilder.maybeCopyFrom(keyNode.getJSDocInfo());
            fnDoc.recordThisType(new JSTypeExpression(new Node(306, IR.string(thisType)), "<PolymerPass.java>"));
            keyNode.setJSDocInfo(fnDoc.build());
        }
        for (PolymerPass.MemberDefinition property : PolymerPassStaticUtils.extractProperties(objLit)) {
            if (!property.value.isObjectLit()) continue;
            if (PolymerClassRewriter.hasShorthandAssignment(property.value)) {
                this.compiler.report(JSError.make(property.value, PolymerPassErrors.POLYMER_SHORTHAND_NOT_SUPPORTED, new String[0]));
                return;
            }
            Node defaultValue = NodeUtil.getFirstPropMatchingKey(property.value, "value");
            if (defaultValue == null || !defaultValue.isFunction()) continue;
            Node defaultValueKey = defaultValue.getParent();
            JSDocInfoBuilder fnDoc = JSDocInfoBuilder.maybeCopyFrom(defaultValueKey.getJSDocInfo());
            fnDoc.recordThisType(new JSTypeExpression(new Node(306, IR.string(thisType)), "<PolymerPass.java>"));
            fnDoc.recordReturnType(PolymerPassStaticUtils.getTypeFromProperty(property, this.compiler));
            defaultValueKey.setJSDocInfo(fnDoc.build());
        }
    }

    private ImmutableList<PolymerPass.MemberDefinition> parseReadOnlyProperties(PolymerClassDefinition cls, Node block) {
        String qualifiedPath = cls.target.getQualifiedName() + ".prototype.";
        ImmutableList.Builder readOnlyProps = ImmutableList.builder();
        for (PolymerPass.MemberDefinition prop : cls.props) {
            Node readOnlyValue;
            if (!prop.value.isObjectLit() || (readOnlyValue = NodeUtil.getFirstPropMatchingKey(prop.value, "readOnly")) == null || !readOnlyValue.isTrue()) continue;
            block.addChildToBack(this.makeReadOnlySetter(prop.name.getString(), qualifiedPath));
            readOnlyProps.add((Object)prop);
        }
        return readOnlyProps.build();
    }

    private JSDocInfoBuilder getConstructorDoc(PolymerClassDefinition cls) {
        JSDocInfoBuilder constructorDoc = JSDocInfoBuilder.maybeCopyFrom(cls.constructor.info);
        constructorDoc.recordConstructor();
        JSTypeExpression baseType = new JSTypeExpression(new Node(306, IR.string(PolymerPassStaticUtils.getPolymerElementType(cls))), "<PolymerPass.java>");
        constructorDoc.recordBaseType(baseType);
        String interfaceName = PolymerClassRewriter.getInterfaceName(cls);
        JSTypeExpression interfaceType = new JSTypeExpression(new Node(306, IR.string(interfaceName)), "<PolymerPass.java>");
        constructorDoc.recordImplementedInterface(interfaceType);
        return constructorDoc;
    }

    private void appendPropertiesToBlock(PolymerClassDefinition cls, Node block, String basePath) {
        for (PolymerPass.MemberDefinition prop : cls.props) {
            Node propertyNode = IR.exprResult(NodeUtil.newQName(this.compiler, basePath + prop.name.getString()));
            JSDocInfoBuilder info = JSDocInfoBuilder.maybeCopyFrom(prop.info);
            JSTypeExpression propType = PolymerPassStaticUtils.getTypeFromProperty(prop, this.compiler);
            if (propType == null) {
                return;
            }
            info.recordType(propType);
            propertyNode.getFirstChild().setJSDocInfo(info.build());
            block.addChildToBack(propertyNode);
        }
    }

    private void removePropertyDocs(Node objLit) {
        for (PolymerPass.MemberDefinition prop : PolymerPassStaticUtils.extractProperties(objLit)) {
            prop.name.removeProp(29);
        }
    }

    private void appendBehaviorMembersToBlock(PolymerClassDefinition cls, Node block) {
        String qualifiedPath = cls.target.getQualifiedName() + ".prototype.";
        HashMap<String, Node> nameToExprResult = new HashMap<String, Node>();
        for (PolymerBehaviorExtractor.BehaviorDefinition behavior : cls.behaviors) {
            for (PolymerPass.MemberDefinition behaviorFunction : behavior.functionsToCopy) {
                String fnName = behaviorFunction.name.getString();
                if (NodeUtil.getFirstPropMatchingKey(cls.descriptor, fnName) != null) continue;
                if (nameToExprResult.containsKey(fnName)) {
                    block.removeChild((Node)nameToExprResult.get(fnName));
                }
                Node fnValue = behaviorFunction.value.cloneTree();
                Node exprResult = IR.exprResult(IR.assign(NodeUtil.newQName(this.compiler, qualifiedPath + fnName), fnValue));
                JSDocInfoBuilder info = JSDocInfoBuilder.maybeCopyFrom(behaviorFunction.info);
                if (!behavior.isGlobalDeclaration) {
                    NodeUtil.getFunctionBody(fnValue).removeChildren();
                }
                exprResult.getFirstChild().setJSDocInfo(info.build());
                block.addChildToBack(exprResult);
                nameToExprResult.put(fnName, exprResult);
            }
            for (PolymerPass.MemberDefinition behaviorProp : behavior.nonPropertyMembersToCopy) {
                String propName = behaviorProp.name.getString();
                if (nameToExprResult.containsKey(propName)) {
                    block.removeChild((Node)nameToExprResult.get(propName));
                }
                Node exprResult = IR.exprResult(NodeUtil.newQName(this.compiler, qualifiedPath + propName));
                JSDocInfoBuilder info = JSDocInfoBuilder.maybeCopyFrom(behaviorProp.info);
                if (behaviorProp.name.isGetterDef()) {
                    info = new JSDocInfoBuilder(true);
                    if (behaviorProp.info != null && behaviorProp.info.getReturnType() != null) {
                        info.recordType(behaviorProp.info.getReturnType());
                    }
                }
                exprResult.getFirstChild().setJSDocInfo(info.build());
                block.addChildToBack(exprResult);
                nameToExprResult.put(propName, exprResult);
            }
        }
    }

    private Node makeReadOnlySetter(String propName, String qualifiedPath) {
        String setterName = "_set" + propName.substring(0, 1).toUpperCase() + propName.substring(1);
        Node fnNode = IR.function(IR.name(""), IR.paramList(IR.name(propName)), IR.block());
        Node exprResNode = IR.exprResult(IR.assign(NodeUtil.newQName(this.compiler, qualifiedPath + setterName), fnNode));
        JSDocInfoBuilder info = new JSDocInfoBuilder(true);
        info.recordOverride();
        exprResNode.getFirstChild().setJSDocInfo(info.build());
        return exprResNode;
    }

    private void addInterfaceExterns(PolymerClassDefinition cls, List<PolymerPass.MemberDefinition> readOnlyProps) {
        Node block = IR.block();
        String interfaceName = PolymerClassRewriter.getInterfaceName(cls);
        Node fnNode = IR.function(IR.name(""), IR.paramList(), IR.block());
        Node varNode = IR.var(NodeUtil.newQName(this.compiler, interfaceName), fnNode);
        JSDocInfoBuilder info = new JSDocInfoBuilder(true);
        info.recordInterface();
        varNode.setJSDocInfo(info.build());
        block.addChildToBack(varNode);
        this.appendPropertiesToBlock(cls, block, interfaceName + ".prototype.");
        for (PolymerPass.MemberDefinition prop : readOnlyProps) {
            String propName = prop.name.getString();
            String setterName = "_set" + propName.substring(0, 1).toUpperCase() + propName.substring(1);
            Node setterExprNode = IR.exprResult(NodeUtil.newQName(this.compiler, interfaceName + ".prototype." + setterName));
            JSDocInfoBuilder setterInfo = new JSDocInfoBuilder(true);
            JSTypeExpression propType = PolymerPassStaticUtils.getTypeFromProperty(prop, this.compiler);
            setterInfo.recordParameter(propName, propType);
            setterExprNode.getFirstChild().setJSDocInfo(setterInfo.build());
            block.addChildToBack(setterExprNode);
        }
        block.useSourceInfoIfMissingFromForTree(this.polymerElementExterns);
        Node parent = this.polymerElementExterns.getParent();
        Node stmts = block.removeChildren();
        parent.addChildrenToBack(stmts);
        this.compiler.reportCodeChange();
    }

    private static boolean hasShorthandAssignment(Node objLit) {
        Preconditions.checkState((boolean)objLit.isObjectLit());
        for (Node property : objLit.children()) {
            if (!property.isStringKey() || property.hasChildren()) continue;
            return true;
        }
        return false;
    }

    private static String getInterfaceName(PolymerClassDefinition cls) {
        return "Polymer" + cls.target.getQualifiedName().replaceAll("\\.", "_") + "Interface";
    }

    private static Node varToAssign(Node var) {
        Node assign = IR.assign(var.getFirstChild().cloneNode(), var.getFirstChild().removeFirstChild());
        return IR.exprResult(assign).useSourceInfoFromForTree(var);
    }
}

