/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IProjectCreationListener;
import org.eclipse.m2e.core.project.MavenProjectInfo;
import org.eclipse.m2e.core.project.ProjectImportConfiguration;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.m2e.core.ui.internal.wizards.AbstractCreateMavenProjectsOperation;
import org.eclipse.m2e.core.ui.internal.wizards.MappingDiscoveryJob;
import org.eclipse.m2e.core.ui.internal.wizards.MavenProjectWorkspaceAssigner;
import org.eclipse.ui.IWorkingSet;

public class ImportMavenProjectsJob
extends WorkspaceJob {
    private List<IWorkingSet> workingSets;
    private Collection<MavenProjectInfo> projects;
    private ProjectImportConfiguration importConfiguration;

    public ImportMavenProjectsJob(Collection<MavenProjectInfo> projects, List<IWorkingSet> workingSets, ProjectImportConfiguration importConfiguration) {
        super(Messages.MavenImportWizard_job);
        this.projects = projects;
        this.workingSets = workingSets;
        this.importConfiguration = importConfiguration;
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        AbstractCreateMavenProjectsOperation importOperation = new AbstractCreateMavenProjectsOperation(){

            @Override
            protected List<IProject> doCreateMavenProjects(IProgressMonitor progressMonitor) throws CoreException {
                SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)101);
                try {
                    List results = MavenPlugin.getProjectConfigurationManager().importProjects(ImportMavenProjectsJob.this.projects, ImportMavenProjectsJob.this.importConfiguration, (IProjectCreationListener)new MavenProjectWorkspaceAssigner(ImportMavenProjectsJob.this.workingSets), (IProgressMonitor)monitor.newChild(100));
                    ArrayList<IProject> arrayList = 1.toProjects(results);
                    return arrayList;
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            importOperation.run(monitor);
            List<IProject> createdProjects = importOperation.getCreatedProjects();
            MappingDiscoveryJob discoveryJob = new MappingDiscoveryJob(createdProjects);
            discoveryJob.schedule();
        }
        catch (InvocationTargetException e) {
            return AbstractCreateMavenProjectsOperation.toStatus(e);
        }
        catch (InterruptedException e) {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }
}

