/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionInfo;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.internal.expressions.ReferenceExpression;
import org.eclipse.e4.core.commands.ExpressionContext;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.IInjector;
import org.eclipse.e4.core.di.InjectionException;
import org.eclipse.e4.core.di.InjectorFactory;
import org.eclipse.e4.core.di.annotations.Evaluate;
import org.eclipse.e4.core.di.suppliers.PrimaryObjectSupplier;
import org.eclipse.e4.core.internal.contexts.ContextObjectSupplier;
import org.eclipse.e4.core.internal.di.InjectorImpl;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.e4.ui.internal.workbench.Activator;
import org.eclipse.e4.ui.internal.workbench.Policy;
import org.eclipse.e4.ui.internal.workbench.Util;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.ui.MCoreExpression;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MExpression;
import org.eclipse.e4.ui.model.application.ui.MImperativeExpression;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimElement;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuSeparator;
import org.eclipse.e4.ui.model.application.ui.menu.MPopupMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarElement;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarSeparator;
import org.eclipse.e4.ui.model.application.ui.menu.MTrimContribution;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public final class ContributionsAnalyzer {
    private static final Object missingEvaluate = new Object();
    private static boolean DEBUG = Policy.DEBUG_MENUS;
    private static final InjectorImpl injector = (InjectorImpl)InjectorFactory.getDefault();
    public static final String MC_POPUP = "menuContribution:popup";
    public static final String MC_MENU = "menuContribution:menu";
    public static final String MC_TOOLBAR = "menuContribution:toolbar";
    public static final String POPUP_PARENT_ID = "popup";

    public static void trace(String msg, Throwable error) {
        if (DEBUG) {
            Activator.trace("/trace/menus", msg, error);
        }
    }

    private static void trace(String msg, Object menu, Object menuModel) {
        ContributionsAnalyzer.trace(String.valueOf(msg) + ": " + menu + ": " + menuModel, null);
    }

    public static void gatherTrimContributions(MTrimBar trimModel, List<MTrimContribution> trimContributions, String elementId, ArrayList<MTrimContribution> toContribute, ExpressionContext eContext) {
        if (elementId == null || elementId.length() == 0) {
            return;
        }
        for (MTrimContribution contribution : trimContributions) {
            String parentId = contribution.getParentId();
            boolean filtered = ContributionsAnalyzer.isFiltered(trimModel, contribution);
            if (filtered || !elementId.equals(parentId) || !contribution.isToBeRendered()) continue;
            toContribute.add(contribution);
        }
    }

    static boolean isFiltered(MTrimBar trimModel, MTrimContribution contribution) {
        return false;
    }

    public static void XXXgatherToolBarContributions(MToolBar toolbarModel, List<MToolBarContribution> toolbarContributionList, String id, ArrayList<MToolBarContribution> toContribute) {
        if (id == null || id.length() == 0) {
            return;
        }
        for (MToolBarContribution toolBarContribution : toolbarContributionList) {
            String parentID = toolBarContribution.getParentId();
            boolean filtered = ContributionsAnalyzer.isFiltered(toolbarModel, toolBarContribution);
            if (filtered || !id.equals(parentID) || !toolBarContribution.isToBeRendered()) continue;
            toContribute.add(toolBarContribution);
        }
    }

    public static void gatherToolBarContributions(MToolBar toolbarModel, List<MToolBarContribution> toolbarContributionList, String id, ArrayList<MToolBarContribution> toContribute, ExpressionContext eContext) {
        if (id == null || id.length() == 0) {
            return;
        }
        for (MToolBarContribution toolBarContribution : toolbarContributionList) {
            String parentID = toolBarContribution.getParentId();
            boolean filtered = ContributionsAnalyzer.isFiltered(toolbarModel, toolBarContribution);
            if (filtered || !id.equals(parentID) || !toolBarContribution.isToBeRendered()) continue;
            toContribute.add(toolBarContribution);
        }
    }

    static boolean isFiltered(MToolBar toolbarModel, MToolBarContribution toolBarContribution) {
        return false;
    }

    public static void XXXgatherMenuContributions(MMenu menuModel, List<MMenuContribution> menuContributionList, String id, ArrayList<MMenuContribution> toContribute, ExpressionContext eContext, boolean includePopups) {
        if (id == null || id.length() == 0) {
            return;
        }
        ArrayList<String> popupIds = new ArrayList<String>();
        if (includePopups) {
            popupIds.add(id);
            for (String tag : menuModel.getTags()) {
                String tmp;
                if (!tag.startsWith("popup:") || popupIds.contains(tmp = tag.substring("popup:".length()))) continue;
                popupIds.add(tmp);
            }
        }
        ArrayList<MMenuContribution> includedPopups = new ArrayList<MMenuContribution>();
        for (MMenuContribution menuContribution : menuContributionList) {
            String parentID = menuContribution.getParentId();
            if (parentID == null) continue;
            boolean popupTarget = includePopups && popupIds.contains(parentID);
            boolean popupAny = includePopups && menuModel instanceof MPopupMenu && POPUP_PARENT_ID.equals(parentID);
            boolean filtered = ContributionsAnalyzer.isFiltered(menuModel, menuContribution, includePopups);
            if (!filtered && menuContribution.isToBeRendered() && popupAny) {
                toContribute.add(menuContribution);
                continue;
            }
            if (filtered || !popupTarget && !parentID.equals(id) || !menuContribution.isToBeRendered()) continue;
            includedPopups.add(menuContribution);
        }
        toContribute.addAll(includedPopups);
    }

    public static void gatherMenuContributions(MMenu menuModel, List<MMenuContribution> menuContributionList, String id, ArrayList<MMenuContribution> toContribute, ExpressionContext eContext, boolean includePopups) {
        if (id == null || id.length() == 0) {
            return;
        }
        boolean menuBar = (MUIElement)((EObject)menuModel).eContainer() instanceof MWindow;
        for (MMenuContribution menuContribution : menuContributionList) {
            String parentID = menuContribution.getParentId();
            if (parentID == null) continue;
            boolean popup = parentID.equals(POPUP_PARENT_ID) && menuModel instanceof MPopupMenu && includePopups;
            boolean filtered = ContributionsAnalyzer.isFiltered(menuModel, menuContribution, includePopups);
            if (filtered || !popup && !parentID.equals(id) || !menuContribution.isToBeRendered() || !menuBar && !ContributionsAnalyzer.isVisible(menuContribution, eContext)) continue;
            toContribute.add(menuContribution);
        }
    }

    static boolean isFiltered(MMenu menuModel, MMenuContribution menuContribution, boolean includePopups) {
        if (includePopups || menuModel.getTags().contains(MC_POPUP)) {
            return !menuContribution.getTags().contains(MC_POPUP) && menuContribution.getTags().contains(MC_MENU);
        }
        if (menuModel.getTags().contains(MC_MENU)) {
            return !menuContribution.getTags().contains(MC_MENU) && menuContribution.getTags().contains(MC_POPUP);
        }
        if (!includePopups) {
            return menuContribution.getTags().contains(MC_POPUP);
        }
        return false;
    }

    public static void collectInfo(ExpressionInfo info, MExpression exp) {
        if (!(exp instanceof MCoreExpression)) {
            return;
        }
        MCoreExpression expr = (MCoreExpression)exp;
        Expression ref = null;
        if (expr.getCoreExpression() instanceof Expression) {
            ref = (Expression)expr.getCoreExpression();
        } else {
            ref = new ReferenceExpression(expr.getCoreExpressionId());
            expr.setCoreExpression((Object)ref);
        }
        ref.collectExpressionInfo(info);
    }

    public static boolean isVisible(MMenuContribution menuContribution, ExpressionContext eContext) {
        if (menuContribution.getVisibleWhen() == null) {
            return true;
        }
        return ContributionsAnalyzer.isVisible(menuContribution.getVisibleWhen(), eContext);
    }

    public static boolean isVisible(MToolBarContribution contribution, ExpressionContext eContext) {
        if (contribution.getVisibleWhen() == null) {
            return true;
        }
        return ContributionsAnalyzer.isVisible(contribution.getVisibleWhen(), eContext);
    }

    public static boolean isVisible(MTrimContribution contribution, ExpressionContext eContext) {
        if (contribution.getVisibleWhen() == null) {
            return true;
        }
        return ContributionsAnalyzer.isVisible(contribution.getVisibleWhen(), eContext);
    }

    public static boolean isVisible(MExpression exp, ExpressionContext eContext) {
        if (exp instanceof MCoreExpression) {
            MCoreExpression coreExpression = (MCoreExpression)exp;
            return ContributionsAnalyzer.isCoreExpressionVisible(coreExpression, eContext);
        }
        if (exp instanceof MImperativeExpression) {
            return ContributionsAnalyzer.isImperativeExpressionVisible((MImperativeExpression)exp, eContext);
        }
        return true;
    }

    private static boolean isCoreExpressionVisible(MCoreExpression coreExpression, ExpressionContext eContext) {
        boolean ret;
        block5: {
            String[] names;
            Expression ref;
            if (coreExpression.getCoreExpression() instanceof Expression) {
                ref = (Expression)coreExpression.getCoreExpression();
            } else {
                ref = new ReferenceExpression(coreExpression.getCoreExpressionId());
                coreExpression.setCoreExpression((Object)ref);
            }
            ExpressionInfo info = ref.computeExpressionInfo();
            String[] stringArray = names = info.getAccessedPropertyNames();
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                eContext.getVariable(String.valueOf(name) + ".evaluationServiceLink");
                ++n2;
            }
            ret = false;
            try {
                ret = ref.evaluate((IEvaluationContext)eContext) != EvaluationResult.FALSE;
            }
            catch (Exception e) {
                if (!DEBUG) break block5;
                ContributionsAnalyzer.trace("isVisible exception", e);
            }
        }
        return ret;
    }

    private static boolean isImperativeExpressionVisible(MImperativeExpression exp, ExpressionContext eContext) {
        Object imperativeExpressionObject = exp.getObject();
        if (imperativeExpressionObject == null) {
            IContributionFactory contributionFactory = (IContributionFactory)eContext.eclipseContext.get(IContributionFactory.class);
            Object newImperativeExpression = contributionFactory.create(exp.getContributionURI(), eContext.eclipseContext);
            exp.setObject(newImperativeExpression);
            imperativeExpressionObject = newImperativeExpression;
        }
        if (imperativeExpressionObject == null) {
            return false;
        }
        Object result = null;
        result = exp.isTracking() ? ContributionsAnalyzer.invoke(imperativeExpressionObject, Evaluate.class, eContext.eclipseContext, null, missingEvaluate) : ContextInjectionFactory.invoke((Object)imperativeExpressionObject, Evaluate.class, (IEclipseContext)eContext.eclipseContext, null, (Object)missingEvaluate);
        if (result == missingEvaluate) {
            String className = "null";
            if (imperativeExpressionObject != null) {
                className = imperativeExpressionObject.getClass().getName();
            }
            throw new IllegalStateException("There is no method annotated with @Evaluate in the " + className + " imperative expression class ");
        }
        return (Boolean)result;
    }

    private static Object invoke(Object object, Class<? extends Annotation> qualifier, IEclipseContext context, IEclipseContext localContext, Object defaultValue) throws InjectionException {
        ContextObjectSupplier supplier = ContextObjectSupplier.getObjectSupplier((IEclipseContext)context, (IInjector)injector);
        ContextObjectSupplier tempSupplier = ContextObjectSupplier.getObjectSupplier((IEclipseContext)localContext, (IInjector)injector);
        return injector.invoke(object, qualifier, defaultValue, (PrimaryObjectSupplier)supplier, (PrimaryObjectSupplier)tempSupplier, false, true);
    }

    public static void addMenuContributions(MMenu menuModel, ArrayList<MMenuContribution> toContribute, ArrayList<MMenuElement> menuContributionsToRemove) {
        HashSet<String> existingMenuIds = new HashSet<String>();
        HashSet<String> existingSeparatorNames = new HashSet<String>();
        for (MMenuElement child : menuModel.getChildren()) {
            String elementId = child.getElementId();
            if (child instanceof MMenu && elementId != null) {
                existingMenuIds.add(elementId);
                continue;
            }
            if (!(child instanceof MMenuSeparator) || elementId == null) continue;
            existingSeparatorNames.add(elementId);
        }
        boolean done = toContribute.isEmpty();
        while (!done) {
            ArrayList<MMenuContribution> curList = new ArrayList<MMenuContribution>(toContribute);
            int retryCount = toContribute.size();
            toContribute.clear();
            for (MMenuContribution menuContribution : curList) {
                if (ContributionsAnalyzer.processAddition(menuModel, menuContributionsToRemove, menuContribution, existingMenuIds, existingSeparatorNames)) continue;
                toContribute.add(menuContribution);
            }
            boolean bl = done = toContribute.isEmpty() || toContribute.size() == retryCount;
        }
    }

    public static boolean processAddition(MMenu menuModel, ArrayList<MMenuElement> menuContributionsToRemove, MMenuContribution menuContribution, HashSet<String> existingMenuIds, HashSet<String> existingSeparatorNames) {
        int idx = ContributionsAnalyzer.getIndex(menuModel, menuContribution.getPositionInParent());
        if (idx == -1) {
            return false;
        }
        for (MMenuElement item : menuContribution.getChildren()) {
            if (item instanceof MMenu && existingMenuIds.contains(item.getElementId()) || item instanceof MMenuSeparator && existingSeparatorNames.contains(item.getElementId())) continue;
            MMenuElement copy = (MMenuElement)EcoreUtil.copy((EObject)((EObject)item));
            if (DEBUG) {
                ContributionsAnalyzer.trace("addMenuContribution " + copy, menuModel.getWidget(), menuModel);
            }
            menuContributionsToRemove.add(copy);
            menuModel.getChildren().add(idx++, copy);
            if (copy instanceof MMenu && copy.getElementId() != null) {
                existingMenuIds.add(copy.getElementId());
                continue;
            }
            if (!(copy instanceof MMenuSeparator) || copy.getElementId() == null) continue;
            existingSeparatorNames.add(copy.getElementId());
        }
        return true;
    }

    public static boolean processAddition(MToolBar toolBarModel, MToolBarContribution toolBarContribution, List<MToolBarElement> contributions, HashSet<String> existingSeparatorNames) {
        int idx = ContributionsAnalyzer.getIndex(toolBarModel, toolBarContribution.getPositionInParent());
        if (idx == -1) {
            return false;
        }
        for (MToolBarElement item : toolBarContribution.getChildren()) {
            if (item instanceof MToolBarSeparator && existingSeparatorNames.contains(item.getElementId())) continue;
            MToolBarElement copy = (MToolBarElement)EcoreUtil.copy((EObject)((EObject)item));
            if (DEBUG) {
                ContributionsAnalyzer.trace("addToolBarContribution " + copy, toolBarModel.getWidget(), toolBarModel);
            }
            toolBarModel.getChildren().add(idx++, copy);
            contributions.add(copy);
            if (!(copy instanceof MToolBarSeparator) || copy.getElementId() == null) continue;
            existingSeparatorNames.add(copy.getElementId());
        }
        return true;
    }

    public static boolean processAddition(MTrimBar trimBar, MTrimContribution contribution, List<MTrimElement> contributions, HashSet<String> existingToolbarIds) {
        int idx = ContributionsAnalyzer.getIndex(trimBar, contribution.getPositionInParent());
        if (idx == -1) {
            return false;
        }
        for (MTrimElement item : contribution.getChildren()) {
            if (item instanceof MToolBar && existingToolbarIds.contains(item.getElementId())) continue;
            MTrimElement copy = (MTrimElement)EcoreUtil.copy((EObject)((EObject)item));
            if (DEBUG) {
                ContributionsAnalyzer.trace("addTrimContribution " + copy, trimBar.getWidget(), trimBar);
            }
            trimBar.getChildren().add(idx++, copy);
            contributions.add(copy);
            if (!(copy instanceof MToolBar) || copy.getElementId() == null) continue;
            existingToolbarIds.add(copy.getElementId());
        }
        return true;
    }

    private static int getIndex(MElementContainer<?> menuModel, String positionInParent) {
        String id = null;
        String modifier = null;
        if (positionInParent != null && positionInParent.length() > 0) {
            String[] array = positionInParent.split("=");
            modifier = array[0];
            if (array.length > 1) {
                id = array[1];
            }
        }
        if (id == null) {
            return menuModel.getChildren().size();
        }
        int idx = 0;
        int size = menuModel.getChildren().size();
        while (idx < size) {
            if (id.equals(((MUIElement)menuModel.getChildren().get(idx)).getElementId())) {
                if ("after".equals(modifier)) {
                    ++idx;
                }
                return idx;
            }
            ++idx;
        }
        return id.equals("additions") ? menuModel.getChildren().size() : -1;
    }

    public static MCommand getCommandById(MApplication app, String cmdId) {
        return app.getCommand(cmdId);
    }

    private static MenuKey getKey(MMenuContribution contribution) {
        if (contribution.getWidget() instanceof MenuKey) {
            return (MenuKey)contribution.getWidget();
        }
        return new MenuKey(contribution);
    }

    private static ToolBarKey getKey(MToolBarContribution contribution) {
        if (contribution.getWidget() instanceof ToolBarKey) {
            return (ToolBarKey)contribution.getWidget();
        }
        return new ToolBarKey(contribution);
    }

    private static TrimKey getKey(MTrimContribution contribution) {
        if (contribution.getWidget() instanceof TrimKey) {
            return (TrimKey)contribution.getWidget();
        }
        return new TrimKey(contribution);
    }

    public static void printContributions(ArrayList<MMenuContribution> contributions) {
        if (!DEBUG) {
            return;
        }
        for (MMenuContribution c : contributions) {
            ContributionsAnalyzer.trace("\n" + c, null);
            for (MMenuElement element : c.getChildren()) {
                ContributionsAnalyzer.printElement(1, element);
            }
        }
    }

    private static void printElement(int level, MMenuElement element) {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < level) {
            buf.append('\t');
            ++i;
        }
        buf.append(element.toString());
        ContributionsAnalyzer.trace(buf.toString(), null);
        if (element instanceof MMenu) {
            for (MMenuElement item : ((MMenu)element).getChildren()) {
                ContributionsAnalyzer.printElement(level + 1, item);
            }
        }
    }

    public static void mergeToolBarContributions(ArrayList<MToolBarContribution> contributions, ArrayList<MToolBarContribution> result) {
        ArrayList slot;
        ToolBarKey key;
        HashMap<ToolBarKey, ArrayList> buckets = new HashMap<ToolBarKey, ArrayList>();
        if (DEBUG) {
            ContributionsAnalyzer.trace("mergeContributions size: " + contributions.size(), null);
        }
        for (MToolBarContribution contribution : contributions) {
            key = ContributionsAnalyzer.getKey(contribution);
            slot = (ArrayList)buckets.get(key);
            if (slot == null) {
                slot = new ArrayList();
                buckets.put(key, slot);
            }
            slot.add(contribution);
        }
        Iterator<MToolBarContribution> i = contributions.iterator();
        while (i.hasNext() && !buckets.isEmpty()) {
            MToolBarContribution contribution = i.next();
            key = ContributionsAnalyzer.getKey(contribution);
            slot = (ArrayList)buckets.remove(key);
            if (slot == null) continue;
            MToolBarContribution toContribute = null;
            for (MToolBarContribution item : slot) {
                Object[] array;
                if (toContribute == null) {
                    toContribute = item;
                    continue;
                }
                Object[] objectArray = array = item.getChildren().toArray();
                int n = array.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    MToolBarElement me = (MToolBarElement)element;
                    if (!ContributionsAnalyzer.containsMatching(toContribute.getChildren(), me)) {
                        toContribute.getChildren().add(me);
                    }
                    ++n2;
                }
            }
            if (toContribute == null) continue;
            toContribute.setWidget(null);
            result.add(toContribute);
        }
        if (DEBUG) {
            ContributionsAnalyzer.trace("mergeContributions: final size: " + result.size(), null);
        }
    }

    public static void mergeContributions(ArrayList<MMenuContribution> contributions, ArrayList<MMenuContribution> result) {
        ArrayList slot;
        MenuKey key;
        HashMap<MenuKey, ArrayList> buckets = new HashMap<MenuKey, ArrayList>();
        if (DEBUG) {
            ContributionsAnalyzer.trace("mergeContributions size: " + contributions.size(), null);
            ContributionsAnalyzer.printContributions(contributions);
        }
        for (MMenuContribution contribution : contributions) {
            key = ContributionsAnalyzer.getKey(contribution);
            slot = (ArrayList)buckets.get(key);
            if (slot == null) {
                slot = new ArrayList();
                buckets.put(key, slot);
            }
            slot.add(contribution);
        }
        Iterator<MMenuContribution> i = contributions.iterator();
        while (i.hasNext() && !buckets.isEmpty()) {
            MMenuContribution contribution = i.next();
            key = ContributionsAnalyzer.getKey(contribution);
            slot = (ArrayList)buckets.remove(key);
            if (slot == null) continue;
            MMenuContribution toContribute = null;
            for (MMenuContribution item : slot) {
                if (toContribute == null) {
                    toContribute = item;
                    continue;
                }
                Object[] array = item.getChildren().toArray();
                int idx = ContributionsAnalyzer.getIndex(toContribute, item.getPositionInParent());
                if (idx == -1) {
                    idx = 0;
                }
                Object[] objectArray = array;
                int n = array.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    MMenuElement me = (MMenuElement)element;
                    if (!ContributionsAnalyzer.containsMatching(toContribute.getChildren(), me)) {
                        toContribute.getChildren().add(idx, me);
                        ++idx;
                    }
                    ++n2;
                }
            }
            if (toContribute == null) continue;
            toContribute.setWidget(null);
            result.add(toContribute);
        }
        ContributionsAnalyzer.trace("mergeContributions: final size: " + result.size(), null);
    }

    private static boolean containsMatching(List<MMenuElement> children, MMenuElement me) {
        for (MMenuElement element : children) {
            if (!Objects.equals(me.getElementId(), element.getElementId()) || !element.getClass().isInstance(me) || !(element instanceof MMenuSeparator) && !(element instanceof MMenu)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsMatching(List<MToolBarElement> children, MToolBarElement me) {
        for (MToolBarElement element : children) {
            if (!Objects.equals(me.getElementId(), element.getElementId()) || !element.getClass().isInstance(me) || !(element instanceof MToolBarSeparator) && !(element instanceof MToolBar)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsMatching(List<MTrimElement> children, MTrimElement me) {
        for (MTrimElement element : children) {
            if (!Objects.equals(me.getElementId(), element.getElementId()) || !element.getClass().isInstance(me) || !(element instanceof MToolBarSeparator) && !(element instanceof MToolBar)) continue;
            return true;
        }
        return false;
    }

    public static int indexForId(MElementContainer<MMenuElement> parentMenu, String id) {
        if (id == null || id.length() == 0) {
            return -1;
        }
        int i = 0;
        for (MMenuElement item : parentMenu.getChildren()) {
            if (id.equals(item.getElementId())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static void mergeTrimContributions(ArrayList<MTrimContribution> contributions, ArrayList<MTrimContribution> result) {
        ArrayList slot;
        TrimKey key;
        HashMap<TrimKey, ArrayList> buckets = new HashMap<TrimKey, ArrayList>();
        if (DEBUG) {
            ContributionsAnalyzer.trace("mergeContributions size: " + contributions.size(), null);
        }
        for (MTrimContribution contribution : contributions) {
            key = ContributionsAnalyzer.getKey(contribution);
            slot = (ArrayList)buckets.get(key);
            if (slot == null) {
                slot = new ArrayList();
                buckets.put(key, slot);
            }
            slot.add(contribution);
        }
        Iterator<MTrimContribution> i = contributions.iterator();
        while (i.hasNext() && !buckets.isEmpty()) {
            MTrimContribution contribution = i.next();
            key = ContributionsAnalyzer.getKey(contribution);
            slot = (ArrayList)buckets.remove(key);
            if (slot == null) continue;
            MTrimContribution toContribute = null;
            for (MTrimContribution item : slot) {
                Object[] array;
                if (toContribute == null) {
                    toContribute = item;
                    continue;
                }
                Object[] objectArray = array = item.getChildren().toArray();
                int n = array.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    MTrimElement me = (MTrimElement)element;
                    if (!ContributionsAnalyzer.containsMatching(toContribute.getChildren(), me)) {
                        toContribute.getChildren().add(me);
                    }
                    ++n2;
                }
            }
            if (toContribute == null) continue;
            toContribute.setWidget(null);
            result.add(toContribute);
        }
        if (DEBUG) {
            ContributionsAnalyzer.trace("mergeContributions: final size: " + result.size(), null);
        }
    }

    public static void populateModelInterfaces(Object modelObject, IEclipseContext context, Class<?>[] interfaces) {
        Class<?>[] classArray = interfaces;
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> intf = classArray[n2];
            if (Policy.DEBUG_CONTEXTS) {
                Activator.trace("/trace/eclipse.context", "Adding " + intf.getName() + " for " + modelObject.getClass().getName(), null);
            }
            context.set(intf.getName(), modelObject);
            ContributionsAnalyzer.populateModelInterfaces(modelObject, context, intf.getInterfaces());
            ++n2;
        }
    }

    static class Key {
        private int tag = -1;
        private int hc = -1;
        private String parentId;
        private String position;
        private MCoreExpression vexp;
        private Object factory;

        public Key(String parentId, String position, List<String> tags, MCoreExpression vexp, Object factory) {
            this.parentId = parentId;
            this.position = position;
            this.vexp = vexp;
            this.factory = factory;
            this.tag = tags.contains("scheme:menu") ? 1 : (tags.contains("scheme:popup") ? 2 : (tags.contains("scheme:toolbar") ? 3 : 0));
        }

        int getSchemeTag() {
            return this.tag;
        }

        public boolean equals(Object obj) {
            Object exp2;
            if (!(obj instanceof Key)) {
                return false;
            }
            Key other = (Key)obj;
            Object exp1 = this.vexp == null ? null : this.vexp.getCoreExpression();
            Object object = exp2 = other.vexp == null ? null : other.vexp.getCoreExpression();
            return Objects.equals(this.parentId, other.parentId) && Objects.equals(this.position, other.position) && this.getSchemeTag() == other.getSchemeTag() && Objects.equals(exp1, exp2) && Objects.equals(this.factory, other.factory);
        }

        public int hashCode() {
            if (this.hc == -1) {
                Object exp1 = this.vexp == null ? null : this.vexp.getCoreExpression();
                this.hc = Util.hashCode(this.parentId);
                this.hc = this.hc * 87 + Util.hashCode(this.position);
                this.hc = this.hc * 87 + this.getSchemeTag();
                this.hc = this.hc * 87 + Util.hashCode(exp1);
                this.hc = this.hc * 87 + Util.hashCode(this.factory);
            }
            return this.hc;
        }

        public String toString() {
            return String.valueOf(this.getClass().getName()) + " " + this.parentId + "--" + this.position + "--" + this.getSchemeTag() + "--" + this.vexp;
        }
    }

    static class MenuKey
    extends Key {
        static final String FACTORY = "ContributionFactory";
        private MMenuContribution contribution;

        public MenuKey(MMenuContribution mc) {
            super(mc.getParentId(), mc.getPositionInParent(), mc.getTags(), (MCoreExpression)mc.getVisibleWhen(), mc.getTransientData().get(FACTORY));
            this.contribution = mc;
            mc.setWidget((Object)this);
        }

        public MMenuContribution getContribution() {
            return this.contribution;
        }
    }

    static class ToolBarKey
    extends Key {
        static final String FACTORY = "ToolBarContributionFactory";
        private MToolBarContribution contribution;

        public ToolBarKey(MToolBarContribution mc) {
            super(mc.getParentId(), mc.getPositionInParent(), mc.getTags(), (MCoreExpression)mc.getVisibleWhen(), mc.getTransientData().get(FACTORY));
            this.contribution = mc;
            mc.setWidget((Object)this);
        }

        public MToolBarContribution getContribution() {
            return this.contribution;
        }
    }

    static class TrimKey
    extends Key {
        private MTrimContribution contribution;

        public TrimKey(MTrimContribution mc) {
            super(mc.getParentId(), mc.getPositionInParent(), mc.getTags(), (MCoreExpression)mc.getVisibleWhen(), null);
            this.contribution = mc;
            mc.setWidget((Object)this);
        }

        public MTrimContribution getContribution() {
            return this.contribution;
        }
    }
}

