/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.build;

import com.android.sdklib.build.DependencyFile;
import com.android.sdklib.build.RenderScriptChecker;
import com.android.sdklib.build.SourceSearcher;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;

public class ManualRenderScriptChecker
extends RenderScriptChecker {
    private final List<File> mInputFiles = Lists.newArrayList();

    public ManualRenderScriptChecker(List<File> sourceFolders, File binFolder) {
        super(sourceFolders, binFolder);
    }

    public boolean mustCompile() throws IOException {
        this.mInputFiles.clear();
        this.loadDependencies();
        if (this.mDependencyFiles.isEmpty()) {
            this.mInputFiles.addAll(this.findInputFiles());
            return !this.mInputFiles.isEmpty();
        }
        SourceSearcher searcher = new SourceSearcher(this.mSourceFolders, "rs", "fs", "rsh");
        InputProcessor inputProcessor = new InputProcessor(this.mOldInputs);
        searcher.search(inputProcessor);
        this.mInputFiles.addAll(inputProcessor.sourceFiles);
        if (inputProcessor.mustCompile) {
            return true;
        }
        if (this.mOldInputs.size() != inputProcessor.sourceFiles.size() + inputProcessor.headerFiles.size()) {
            return true;
        }
        for (File file : this.mOldOutputs) {
            if (file.isFile()) continue;
            return true;
        }
        for (DependencyFile depFile : this.mDependencyFiles) {
            if (!depFile.needCompilation()) continue;
            return true;
        }
        return false;
    }

    public List<File> getInputFiles() {
        return this.mInputFiles;
    }

    private static class InputProcessor
    implements SourceSearcher.SourceFileProcessor {
        private final Set<File> mOldInputs;
        List<File> sourceFiles = Lists.newArrayList();
        List<File> headerFiles = Lists.newArrayList();
        boolean mustCompile = false;

        InputProcessor(Set<File> oldInputs) {
            this.mOldInputs = oldInputs;
        }

        @Override
        public void processFile(File sourceFile, String extension) throws IOException {
            if ("rsh".equals(extension)) {
                this.headerFiles.add(sourceFile);
            } else {
                this.sourceFiles.add(sourceFile);
            }
            if (!this.mOldInputs.contains(sourceFile)) {
                this.mustCompile = true;
            }
        }
    }
}

