/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.collect.Range;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.Subject;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public abstract class ComparableSubject<S extends ComparableSubject<S, T>, T extends Comparable>
extends Subject<S, T> {
    protected ComparableSubject(FailureMetadata metadata, @NullableDecl T actual) {
        super(metadata, actual);
    }

    @Override
    public final void isIn(Range<T> range) {
        if (!range.contains((Comparable)this.actual())) {
            this.failWithActual("expected to be in range", range);
        }
    }

    @Override
    public final void isNotIn(Range<T> range) {
        if (range.contains((Comparable)this.actual())) {
            this.failWithActual("expected not to be in range", range);
        }
    }

    public void isEquivalentAccordingToCompareTo(T expected) {
        if (((Comparable)this.actual()).compareTo(expected) != 0) {
            this.failWithActual("expected value that sorts equal to", expected);
        }
    }

    @Deprecated
    public void comparesEqualTo(T other) {
        this.isEquivalentAccordingToCompareTo(other);
    }

    public final void isGreaterThan(T other) {
        if (((Comparable)this.actual()).compareTo(other) <= 0) {
            this.failWithActual("expected to be greater than", other);
        }
    }

    public final void isLessThan(T other) {
        if (((Comparable)this.actual()).compareTo(other) >= 0) {
            this.failWithActual("expected to be less than", other);
        }
    }

    public final void isAtMost(T other) {
        if (((Comparable)this.actual()).compareTo(other) > 0) {
            this.failWithActual("expected to be at most", other);
        }
    }

    public final void isAtLeast(T other) {
        if (((Comparable)this.actual()).compareTo(other) < 0) {
            this.failWithActual("expected to be at least", other);
        }
    }
}

