Object.defineProperty(exports, '__esModule', {
  value: true
});
exports.activate = activate;
exports.deactivate = deactivate;
exports.consumeStatusBar = consumeStatusBar;
exports.deserializeIncompatiblePackagesComponent = deserializeIncompatiblePackagesComponent;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

/** @babel */

var _atom = require('atom');

var _viewUri = require('./view-uri');

var _viewUri2 = _interopRequireDefault(_viewUri);

var disposables = null;

function activate() {
  disposables = new _atom.CompositeDisposable();

  disposables.add(atom.workspace.addOpener(function (uri) {
    if (uri === _viewUri2['default']) {
      return deserializeIncompatiblePackagesComponent();
    }
  }));

  disposables.add(atom.commands.add('atom-workspace', {
    'incompatible-packages:view': function incompatiblePackagesView() {
      atom.workspace.open(_viewUri2['default']);
    }
  }));
}

function deactivate() {
  disposables.dispose();
}

function consumeStatusBar(statusBar) {
  var incompatibleCount = 0;
  for (var pack of atom.packages.getLoadedPackages()) {
    if (!pack.isCompatible()) incompatibleCount++;
  }

  if (incompatibleCount > 0) {
    (function () {
      var icon = createIcon(incompatibleCount);
      var tile = statusBar.addRightTile({ item: icon, priority: 200 });
      icon.element.addEventListener('click', function () {
        atom.commands.dispatch(icon.element, 'incompatible-packages:view');
      });
      disposables.add(new _atom.Disposable(function () {
        return tile.destroy();
      }));
    })();
  }
}

function deserializeIncompatiblePackagesComponent() {
  var IncompatiblePackagesComponent = require('./incompatible-packages-component');
  return new IncompatiblePackagesComponent(atom.packages);
}

function createIcon(count) {
  var StatusIconComponent = require('./status-icon-component');
  return new StatusIconComponent({ count: count });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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