"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.BarePrStatusContextView = void 0;

var _react = _interopRequireDefault(require("react"));

var _reactRelay = require("react-relay");

var _propTypes = _interopRequireDefault(require("prop-types"));

var _octicon = _interopRequireDefault(require("../atom/octicon"));

var _prStatusesView = require("../views/pr-statuses-view");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class BarePrStatusContextView extends _react.default.Component {
  render() {
    const {
      context,
      description,
      state,
      targetUrl
    } = this.props.context;
    const {
      icon,
      style
    } = _prStatusesView.stateToIconAndStyle[state];
    return _react.default.createElement("li", {
      className: "github-PrStatuses-list-item"
    }, _react.default.createElement("span", {
      className: "github-PrStatuses-list-item-icon"
    }, _react.default.createElement(_octicon.default, {
      icon: icon,
      className: style
    })), _react.default.createElement("span", {
      className: "github-PrStatuses-list-item-context"
    }, _react.default.createElement("strong", null, context), " ", description), _react.default.createElement("span", {
      className: "github-PrStatuses-list-item-details-link"
    }, _react.default.createElement("a", {
      href: targetUrl
    }, "Details")));
  }

}

exports.BarePrStatusContextView = BarePrStatusContextView;

_defineProperty(BarePrStatusContextView, "propTypes", {
  context: _propTypes.default.shape({
    context: _propTypes.default.string.isRequired,
    description: _propTypes.default.string,
    state: _propTypes.default.string.isRequired,
    targetUrl: _propTypes.default.string,
    creator: _propTypes.default.shape({
      avatarUrl: _propTypes.default.string.isRequired,
      login: _propTypes.default.string.isRequired
    })
  }).isRequired
});

var _default = (0, _reactRelay.createFragmentContainer)(BarePrStatusContextView, {
  context: function () {
    const node = require("./__generated__/prStatusContextView_context.graphql");

    if (node.hash && node.hash !== "e729074e494e07b59b4a177416eb7a3c") {
      console.error("The definition of 'prStatusContextView_context' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/prStatusContextView_context.graphql");
  }
});

exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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