"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _eventKit = require("event-kit");

var _commands = _interopRequireWildcard(require("../atom/commands"));

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class OpenCommitDialog extends _react.default.Component {
  constructor(props, context) {
    super(props, context);

    _defineProperty(this, "accept", async () => {
      const ref = this.getCommitRef();
      const valid = await this.props.isValidEntry(ref);

      if (valid === true) {
        this.props.didAccept({
          ref
        });
      } else {
        this.setState({
          error: `There is no commit associated with "${ref}" in this repository`
        });
      }
    });

    _defineProperty(this, "cancel", () => this.props.didCancel());

    _defineProperty(this, "editorRefs", baseName => {
      const elementName = `${baseName}Element`;
      const modelName = `${baseName}Editor`;
      const subName = `${baseName}Subs`;
      const changeMethodName = `didChange${baseName[0].toUpperCase()}${baseName.substring(1)}`;
      return element => {
        if (!element) {
          return;
        }

        this[elementName] = element;
        const editor = element.getModel();

        if (this[modelName] !== editor) {
          this[modelName] = editor;
          /* istanbul ignore if */

          if (this[subName]) {
            this[subName].dispose();
            this.subs.remove(this[subName]);
          }

          this[subName] = editor.onDidChange(this[changeMethodName]);
          this.subs.add(this[subName]);
        }
      };
    });

    _defineProperty(this, "didChangeCommitRef", () => new Promise(resolve => {
      this.setState({
        error: null
      }, resolve);
    }));

    this.state = {
      error: null
    };
    this.subs = new _eventKit.CompositeDisposable();
  }

  componentDidMount() {
    setTimeout(() => this.commitRefElement.focus());
  }

  componentWillUnmount() {
    this.subs.dispose();
  }

  render() {
    return this.renderDialog();
  }

  renderDialog() {
    return _react.default.createElement("div", {
      className: "github-Dialog github-OpenCommit modal"
    }, _react.default.createElement(_commands.default, {
      registry: this.props.commandRegistry,
      target: ".github-OpenCommit"
    }, _react.default.createElement(_commands.Command, {
      command: "core:cancel",
      callback: this.cancel
    }), _react.default.createElement(_commands.Command, {
      command: "core:confirm",
      callback: this.accept
    })), _react.default.createElement("main", {
      className: "github-DialogInputs"
    }, _react.default.createElement("label", {
      className: "github-DialogLabel github-CommitRef"
    }, "Commit sha or Git ref:", _react.default.createElement("atom-text-editor", {
      mini: true,
      ref: this.editorRefs('commitRef'),
      tabIndex: "1"
    })), this.state.error && _react.default.createElement("span", {
      className: "error"
    }, this.state.error)), _react.default.createElement("div", {
      className: "github-DialogButtons"
    }, _react.default.createElement("button", {
      className: "btn github-CancelButton",
      onClick: this.cancel,
      tabIndex: "3"
    }, "Cancel"), _react.default.createElement("button", {
      className: "btn btn-primary icon icon-commit",
      onClick: this.accept,
      disabled: !!this.state.error || this.getCommitRef().length === 0,
      tabIndex: "2"
    }, "Open Commit")));
  }

  getCommitRef() {
    return this.commitRefEditor ? this.commitRefEditor.getText() : '';
  }

}

exports.default = OpenCommitDialog;

_defineProperty(OpenCommitDialog, "propTypes", {
  commandRegistry: _propTypes.default.object.isRequired,
  didAccept: _propTypes.default.func.isRequired,
  didCancel: _propTypes.default.func.isRequired,
  isValidEntry: _propTypes.default.func.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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