"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _propTypes2 = require("../prop-types");

var _refHolder = _interopRequireDefault(require("../models/ref-holder"));

var _githubTabContainer = _interopRequireDefault(require("../containers/github-tab-container"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class GitHubTabItem extends _react.default.Component {
  static buildURI() {
    return this.uriPattern;
  }

  constructor(props) {
    super(props);
    this.rootHolder = new _refHolder.default();
  }

  getTitle() {
    return 'GitHub';
  }

  getIconName() {
    return 'octoface';
  }

  getDefaultLocation() {
    return 'right';
  }

  getPreferredWidth() {
    return 400;
  }

  getWorkingDirectory() {
    return this.props.repository.getWorkingDirectoryPath();
  }

  serialize() {
    return {
      deserializer: 'GithubDockItem',
      uri: this.getURI()
    };
  }

  render() {
    return _react.default.createElement(_githubTabContainer.default, _extends({}, this.props, {
      rootHolder: this.rootHolder
    }));
  }

  hasFocus() {
    return this.rootHolder.map(root => root.contains(this.props.documentActiveElement())).getOr(false);
  }

  restoreFocus() {// No-op
  }

}

exports.default = GitHubTabItem;

_defineProperty(GitHubTabItem, "propTypes", {
  workspace: _propTypes.default.object.isRequired,
  repository: _propTypes.default.object,
  loginModel: _propTypes2.GithubLoginModelPropType.isRequired,
  documentActiveElement: _propTypes.default.func
});

_defineProperty(GitHubTabItem, "defaultProps", {
  documentActiveElement:
  /* istanbul ignore next */
  () => document.activeElement
});

_defineProperty(GitHubTabItem, "uriPattern", 'atom-github://dock-item/github');
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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