"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _net = _interopRequireDefault(require("net"));

var _eventKit = require("event-kit");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class GitPromptServer {
  constructor(gitTempDir) {
    this.emitter = new _eventKit.Emitter();
    this.gitTempDir = gitTempDir;
  }

  async start(promptForInput) {
    this.promptForInput = promptForInput;
    await this.gitTempDir.ensure();
    this.server = await this.startListening(this.gitTempDir.getSocketPath());
  }

  startListening(socketPath) {
    return new Promise(resolve => {
      const server = _net.default.createServer(connection => {
        connection.setEncoding('utf8');
        const parts = [];
        connection.on('data', data => {
          const nullIndex = data.indexOf('\u0000');

          if (nullIndex === -1) {
            parts.push(data);
          } else {
            parts.push(data.substring(0, nullIndex));
            this.handleData(connection, parts.join(''));
          }
        });
      });

      server.listen(socketPath, () => resolve(server));
    });
  }

  handleData(connection, data) {
    let query;

    try {
      query = JSON.parse(data);
    } catch (e) {
      this.emitter.emit('did-cancel');
    }

    Promise.resolve(this.promptForInput(query)).then(answer => connection.end(JSON.stringify(answer), 'utf-8')).catch(() => this.emitter.emit('did-cancel', {
      handlerPid: query.pid
    }));
  }

  onDidCancel(cb) {
    return this.emitter.on('did-cancel', cb);
  }

  async terminate() {
    await new Promise(resolve => this.server.close(resolve));
    this.emitter.dispose();
  }

}

exports.default = GitPromptServer;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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