# Contribution Guidelines

## Hello...

Thank you for taking an interest in contributing to `remap-istanbul`.

## How to Get Help

The issues tracker on GitHub is for issues, things that should work but appear to not be working, or suggestions and enhancements.  [StackOverflow](https://stackoverflow.com/questions/ask/advice?tags=remap-istanbul) is the best place to get a question answered (and probably far better than the few of us who monitor the issues!).

(What is even more annoying is asking a question on StackOverflow and posting an issue on GitHub... You naughty naughty child, shame on you!)

If you are in a hurry, or just like clicking on links, try this link: [StackOverflow](https://stackoverflow.com/questions/ask/advice?tags=remap-istanbul)

If we punt you and your question out of GitHub issues, it isn't because we don't like you, it is nothing personal, we just like to try to get people the right help.

We are also experimenting with answering questions on [Gitter](https://gitter.im/SitePen/remap-istanbul).  So feel free to checkout out there as well.

Of course [SitePen](https://www.sitepen.com/) is a commercial organization as well... We will gladly take your money to [support you](https://www.sitepen.com/support/index.html).  Even then, we will give you a better system for asking your questions than GitHub issues.

## Reporting Bugs and Feature Requests

For things that you think might be bugs, please open a [GitHub issue](https://github.com/SitePen/remap-istanbul/issues/new?body=Description:%0A%0ASteps+to+reproduce:%0A%0A1.%20%E2%80%A6%0A2.%20%E2%80%A6%0A3.%20%E2%80%A6%0A%0AExpected%20result:%0AActual%20result:%0A%0AVersion:%0A%0AAny%20additional%20information:).

For feature requests, just open an issue in GitHub.  We promise not to laugh (at least not publically) at your suggestion and evaluate if we think it is feasible, reasonable.  It is even better if you feel like you can try to contribute by adding the feature. WOO HOO! :smile:

## Submitting Pull Requests

We care a lot about Open Source.  One of the most important things is to make sure every contribution is given freely by its owner.  Therefore we require every contribution to have a [CLA](http://dojofoundation.org/about/claForm) on file.  This CLA covers contributions to many open source projects, so it won't be a wasted 30 seconds of your life and there is no blood samples taken!!!

"Drive By" Pull Requests are challenging... We love that you want to improve things, but if we merged everything, without explanation or context, well we might not have such good quality software.  If you could make sure you explain your contribution (hopefully by referencing the feature request ticket you opened! :wink:)

Your code should conform to our [style guidelines](https://github.com/sitepen/.jshintrc).  Otherwise we will get grumpy :angry:, and you won't like us when we are grumpy. :sob:

## Again, Thank You!

Not only do you want to contribute, you read the guidelines! We :heart: you!
