/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.logging.Level;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.PrintCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.DataObjectPool;
import org.openide.loaders.DefaultES;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

final class DefaultDataObject
extends MultiDataObject
implements OpenCookie {
    static final long serialVersionUID = -4936309935667095746L;
    private DefaultES support;
    private boolean cookieSetFixed = false;

    DefaultDataObject(FileObject fileObject, MultiFileLoader multiFileLoader) throws DataObjectExistsException {
        super(fileObject, multiFileLoader);
    }

    @Override
    protected int associateLookup() {
        return 1;
    }

    @Override
    protected Node createNodeDelegate() {
        DataNode dataNode = new DataNode(this, Children.LEAF);
        dataNode.setShortDescription(NbBundle.getMessage(DefaultDataObject.class, (String)"HINT_DefaultDataObject"));
        return dataNode;
    }

    @Override
    public String getName() {
        return this.getPrimaryFile().getNameExt();
    }

    @Override
    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected FileObject handleRename(String string) throws IOException {
        FileLock fileLock = this.getPrimaryEntry().takeLock();
        int n = string.lastIndexOf(46);
        try {
            if (n < 0) {
                this.getPrimaryFile().rename(fileLock, string, null);
            } else if (n == 0) {
                this.getPrimaryFile().rename(fileLock, string, null);
            } else if (!string.equals(this.getPrimaryFile().getNameExt())) {
                this.getPrimaryFile().rename(fileLock, string.substring(0, n), string.substring(n + 1, string.length()));
                DataObjectPool.getPOOL().revalidate(new HashSet<FileObject>(Collections.singleton(this.getPrimaryFile())));
            }
        }
        finally {
            fileLock.releaseLock();
        }
        return this.getPrimaryFile();
    }

    @Override
    protected DataObject handleCreateFromTemplate(DataFolder dataFolder, String string) throws IOException {
        if (string != null && string.endsWith("." + this.getPrimaryFile().getExt())) {
            string = string.substring(0, string.lastIndexOf("." + this.getPrimaryFile().getExt()));
        }
        return super.handleCreateFromTemplate(dataFolder, string);
    }

    @Override
    protected DataObject handleCopyRename(DataFolder dataFolder, String string, String string2) throws IOException {
        FileObject fileObject = this.getPrimaryEntry().copyRename(dataFolder.getPrimaryFile(), string, string2);
        return DataObject.find(fileObject);
    }

    public void open() {
        EditorCookie editorCookie = this.getCookie(EditorCookie.class);
        if (editorCookie != null) {
            editorCookie.open();
        } else {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(NotifyDescriptor.OK_OPTION);
            arrayList.add(NotifyDescriptor.CANCEL_OPTION);
            NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)NbBundle.getMessage(DefaultDataObject.class, (String)"MSG_BinaryFileQuestion"), NbBundle.getMessage(DefaultDataObject.class, (String)"MSG_BinaryFileWarning"), -1, 3, arrayList.toArray(), null);
            Object object = DialogDisplayer.getDefault().notify(notifyDescriptor);
            if (object != NotifyDescriptor.OK_OPTION) {
                return;
            }
            EditorCookie editorCookie2 = this.getCookie(EditorCookie.class, true);
            editorCookie2.open();
        }
    }

    @Override
    public Lookup getLookup() {
        return this.getCookieSet().getLookup();
    }

    @Override
    public <T extends Node.Cookie> T getCookie(Class<T> clazz) {
        return this.getCookie(clazz, false);
    }

    @Override
    final void checkCookieSet(Class<?> clazz) {
        if (Node.Cookie.class.isAssignableFrom(clazz) && !this.cookieSetFixed) {
            Class<Node.Cookie> clazz2 = clazz.asSubclass(Node.Cookie.class);
            this.fixCookieSet(clazz2, false);
        }
    }

    final <T extends Node.Cookie> T getCookie(Class<T> clazz, boolean bl) {
        if (clazz == OpenCookie.class) {
            return (T)((Node.Cookie)clazz.cast(this));
        }
        T t = super.getCookie(clazz);
        if (t != null) {
            return t;
        }
        this.fixCookieSet(clazz, bl);
        return (T)this.getCookieSet().getCookie(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fixCookieSet(Class<?> clazz, boolean bl) {
        if (this.cookieSetFixed && !bl || this.support != null) {
            return;
        }
        if (clazz.isAssignableFrom(EditCookie.class) || clazz.isAssignableFrom(EditorCookie.Observable.class) || clazz.isAssignableFrom(PrintCookie.class) || clazz.isAssignableFrom(CloseCookie.class) || clazz == DefaultES.class) {
            try {
                if (!bl) {
                    byte[] byArray = new byte[2048];
                    InputStream inputStream = this.getPrimaryFile().getInputStream();
                    try {
                        int n = inputStream.read(byArray);
                        for (int i = 0; i < n; ++i) {
                            if (byArray[i] < 0 || byArray[i] > 31 || byArray[i] == 10 || byArray[i] == 13 || byArray[i] == 9 || byArray[i] == 12) continue;
                            this.cookieSetFixed = true;
                            return;
                        }
                    }
                    finally {
                        inputStream.close();
                    }
                }
                this.support = new DefaultES(this, this.getPrimaryEntry(), this.getCookieSet());
                this.getCookieSet().assign(DefaultES.class, (Object[])new DefaultES[]{this.support});
                this.cookieSetFixed = true;
            }
            catch (IOException iOException) {
                LOG.log(Level.INFO, "Cannot read " + this.getPrimaryEntry(), iOException);
            }
        }
    }
}

