/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bib2gls;

import com.dickimawbooks.bib2gls.Bib2Gls;
import com.dickimawbooks.bib2gls.GlsRecord;

public class GlsRecordNameRef
extends GlsRecord {
    private String title;
    private String href;
    private String hcounter;

    public GlsRecordNameRef(Bib2Gls bib2Gls, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        super(bib2Gls, string, string2, string3, string4, string5);
        this.title = string6;
        this.href = string7;
        this.hcounter = string8;
    }

    protected GlsRecordNameRef(Bib2Gls bib2Gls, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, long l) {
        super(bib2Gls, string, string2, string3, string4, string5, l);
        this.title = string6;
        this.href = string7;
        this.hcounter = string8;
    }

    @Override
    public GlsRecord copy(String string) {
        return new GlsRecordNameRef(this.bib2gls, string, this.getPrefix(), this.getCounter(), this.getFormat(), this.getLocation(), this.title, this.href, this.hcounter, this.getIndex());
    }

    @Override
    public Object clone() {
        return new GlsRecordNameRef(this.bib2gls, this.getLabel(), this.getPrefix(), this.getCounter(), this.getFormat(), this.getLocation(), this.title, this.href, this.hcounter, this.getIndex());
    }

    public String getTitle() {
        return this.title;
    }

    public String getHref() {
        return this.href;
    }

    public String getHcounter() {
        return this.hcounter;
    }

    @Override
    public String getFmtTeXCode() {
        String string = this.getFormat();
        if (string.isEmpty()) {
            string = "glsnumberformat";
        } else if (string.startsWith("(") || string.startsWith(")")) {
            string = string.length() == 1 ? "glsnumberformat" : string.substring(1);
        }
        return String.format("\\glsxtrdisplaylocnameref{%s}{%s}{%s}{%s}{%s}{%s}{%s}{}", this.getPrefix(), this.getCounter(), string, this.getLocation(), this.getTitle(), this.getHref(), this.getHcounter());
    }

    @Override
    public boolean locationMatch(GlsRecord glsRecord) {
        if (this.bib2gls.mergeNameRefOnLocation()) {
            return super.locationMatch(glsRecord);
        }
        if (!(glsRecord instanceof GlsRecordNameRef)) {
            return false;
        }
        if (!this.getCounter().equals(glsRecord.getCounter())) {
            return false;
        }
        GlsRecordNameRef glsRecordNameRef = (GlsRecordNameRef)glsRecord;
        if (this.bib2gls.mergeNameRefOnTitle()) {
            return this.title.equals(glsRecordNameRef.title);
        }
        return this.href.equals(glsRecordNameRef.href);
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof GlsRecordNameRef)) {
            return false;
        }
        GlsRecordNameRef glsRecordNameRef = (GlsRecordNameRef)object;
        return this.href.equals(glsRecordNameRef.href) && this.title.equals(glsRecordNameRef.title) && this.hcounter.equals(glsRecordNameRef.hcounter);
    }

    @Override
    public boolean partialMatch(GlsRecord glsRecord) {
        if (this.bib2gls.mergeNameRefOnLocation() || !(glsRecord instanceof GlsRecordNameRef)) {
            return super.partialMatch(glsRecord);
        }
        if (!this.getLabel().equals(glsRecord.getLabel())) {
            return false;
        }
        if (!this.getCounter().equals(glsRecord.getCounter())) {
            return false;
        }
        if (this.bib2gls.mergeNameRefOnHcounter()) {
            return this.hcounter.equals(((GlsRecordNameRef)glsRecord).hcounter);
        }
        if (this.bib2gls.mergeNameRefOnTitle()) {
            return this.title.equals(((GlsRecordNameRef)glsRecord).title);
        }
        return this.href.equals(((GlsRecordNameRef)glsRecord).href);
    }

    @Override
    public String toString() {
        return String.format("{%s}{%s}{%s}{%s}{%s}{%s}{%s}{%s}{}", this.getLabel(), this.getPrefix(), this.getCounter(), this.getFormat(), this.getLocation(), this.getTitle(), this.getHref(), this.getHcounter());
    }
}

