/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webkit.network;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.IDN;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

final class PublicSuffixes {
    private static final Logger logger = Logger.getLogger(PublicSuffixes.class.getName());
    private static final Map<String, Rule> RULES = PublicSuffixes.loadRules("effective_tld_names.dat");

    private PublicSuffixes() {
        throw new AssertionError();
    }

    static boolean isPublicSuffix(String domain) {
        String parent;
        if (domain.length() == 0) {
            return false;
        }
        Rule rule = RULES.get(domain);
        if (rule == Rule.EXCEPTION_RULE) {
            return false;
        }
        if (rule == Rule.SIMPLE_RULE || rule == Rule.WILDCARD_RULE) {
            return true;
        }
        int pos = domain.indexOf(46) + 1;
        if (pos == 0) {
            pos = domain.length();
        }
        return RULES.get(parent = domain.substring(pos)) == Rule.WILDCARD_RULE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Rule> loadRules(String resourceName) {
        logger.log(Level.FINEST, "resourceName: [{0}]", resourceName);
        Map<String, Rule> result = null;
        InputStream is = PublicSuffixes.class.getResourceAsStream(resourceName);
        if (is != null) {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                result = PublicSuffixes.loadRules(reader);
            }
            catch (IOException ex) {
                logger.log(Level.WARNING, "Unexpected error", ex);
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException ex) {
                    logger.log(Level.WARNING, "Unexpected error", ex);
                }
            }
        } else {
            logger.log(Level.WARNING, "Resource not found: [{0}]", resourceName);
        }
        Map<String, Rule> map = result = result != null ? Collections.unmodifiableMap(result) : Collections.emptyMap();
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "result: {0}", PublicSuffixes.toLogString(result));
        }
        return result;
    }

    private static Map<String, Rule> loadRules(BufferedReader reader) throws IOException {
        String line;
        LinkedHashMap<String, Rule> result = new LinkedHashMap<String, Rule>();
        while ((line = reader.readLine()) != null) {
            Rule rule;
            if ((line = line.split("\\s+", 2)[0]).length() == 0 || line.startsWith("//")) continue;
            if (line.startsWith("!")) {
                line = line.substring(1);
                rule = Rule.EXCEPTION_RULE;
            } else if (line.startsWith("*.")) {
                line = line.substring(2);
                rule = Rule.WILDCARD_RULE;
            } else {
                rule = Rule.SIMPLE_RULE;
            }
            try {
                line = IDN.toASCII(line, 1);
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, String.format("Error parsing rule: [%s]", line), ex);
                continue;
            }
            result.put(line, rule);
        }
        return result;
    }

    private static String toLogString(Map<String, Rule> rules) {
        if (rules.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Rule> entry : rules.entrySet()) {
            sb.append(String.format("%n    ", new Object[0]));
            sb.append(entry.getKey());
            sb.append(": ");
            sb.append((Object)entry.getValue());
        }
        return sb.toString();
    }

    private static enum Rule {
        SIMPLE_RULE,
        WILDCARD_RULE,
        EXCEPTION_RULE;

    }
}

