/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl.sw.java;

import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.impl.EffectPeer;
import com.sun.scenario.effect.impl.Renderer;
import com.sun.scenario.effect.impl.state.RenderState;

public abstract class JSWEffectPeer<T extends RenderState>
extends EffectPeer<T> {
    protected static final int FVALS_A = 3;
    protected static final int FVALS_R = 0;
    protected static final int FVALS_G = 1;
    protected static final int FVALS_B = 2;

    protected JSWEffectPeer(FilterContext fctx, Renderer r, String uniqueName) {
        super(fctx, r, uniqueName);
    }

    protected final void laccum(int pixel, float mul, float[] fvals) {
        fvals[0] = fvals[0] + (float)(pixel >> 16 & 0xFF) * (mul /= 255.0f);
        fvals[1] = fvals[1] + (float)(pixel >> 8 & 0xFF) * mul;
        fvals[2] = fvals[2] + (float)(pixel & 0xFF) * mul;
        fvals[3] = fvals[3] + (float)(pixel >>> 24) * mul;
    }

    protected final void lsample(int[] img, float floc_x, float floc_y, int w, int h, int scan, float[] fvals) {
        fvals[0] = 0.0f;
        fvals[1] = 0.0f;
        fvals[2] = 0.0f;
        fvals[3] = 0.0f;
        floc_x = floc_x * (float)w + 0.5f;
        floc_y = floc_y * (float)h + 0.5f;
        int iloc_x = (int)floc_x;
        int iloc_y = (int)floc_y;
        if (floc_x > 0.0f && floc_y > 0.0f && iloc_x <= w && iloc_y <= h) {
            int offset = iloc_y * scan + iloc_x;
            float fract = (floc_x -= (float)iloc_x) * (floc_y -= (float)iloc_y);
            if (iloc_y < h) {
                if (iloc_x < w) {
                    this.laccum(img[offset], fract, fvals);
                }
                if (iloc_x > 0) {
                    this.laccum(img[offset - 1], floc_y - fract, fvals);
                }
            }
            if (iloc_y > 0) {
                if (iloc_x < w) {
                    this.laccum(img[offset - scan], floc_x - fract, fvals);
                }
                if (iloc_x > 0) {
                    this.laccum(img[offset - scan - 1], 1.0f - floc_x - floc_y + fract, fvals);
                }
            }
        }
    }

    protected final void laccumsample(int[] img, float fpix_x, float fpix_y, int w, int h, int scan, float factor, float[] fvals) {
        factor *= 255.0f;
        int ipix_x = (int)(fpix_x += 0.5f);
        int ipix_y = (int)(fpix_y += 0.5f);
        if (fpix_x > 0.0f && fpix_y > 0.0f && ipix_x <= w && ipix_y <= h) {
            int offset = ipix_y * scan + ipix_x;
            float fract = (fpix_x -= (float)ipix_x) * (fpix_y -= (float)ipix_y);
            if (ipix_y < h) {
                if (ipix_x < w) {
                    this.laccum(img[offset], fract * factor, fvals);
                }
                if (ipix_x > 0) {
                    this.laccum(img[offset - 1], (fpix_y - fract) * factor, fvals);
                }
            }
            if (ipix_y > 0) {
                if (ipix_x < w) {
                    this.laccum(img[offset - scan], (fpix_x - fract) * factor, fvals);
                }
                if (ipix_x > 0) {
                    this.laccum(img[offset - scan - 1], (1.0f - fpix_x - fpix_y + fract) * factor, fvals);
                }
            }
        }
    }

    protected final void faccum(float[] map, int offset, float mul, float[] fvals) {
        fvals[0] = fvals[0] + map[offset] * mul;
        fvals[1] = fvals[1] + map[offset + 1] * mul;
        fvals[2] = fvals[2] + map[offset + 2] * mul;
        fvals[3] = fvals[3] + map[offset + 3] * mul;
    }

    protected final void fsample(float[] map, float floc_x, float floc_y, int w, int h, int scan, float[] fvals) {
        fvals[0] = 0.0f;
        fvals[1] = 0.0f;
        fvals[2] = 0.0f;
        fvals[3] = 0.0f;
        floc_x = floc_x * (float)w + 0.5f;
        floc_y = floc_y * (float)h + 0.5f;
        int iloc_x = (int)floc_x;
        int iloc_y = (int)floc_y;
        if (floc_x > 0.0f && floc_y > 0.0f && iloc_x <= w && iloc_y <= h) {
            int offset = 4 * (iloc_y * scan + iloc_x);
            float fract = (floc_x -= (float)iloc_x) * (floc_y -= (float)iloc_y);
            if (iloc_y < h) {
                if (iloc_x < w) {
                    this.faccum(map, offset, fract, fvals);
                }
                if (iloc_x > 0) {
                    this.faccum(map, offset - 4, floc_y - fract, fvals);
                }
            }
            if (iloc_y > 0) {
                if (iloc_x < w) {
                    this.faccum(map, offset - scan * 4, floc_x - fract, fvals);
                }
                if (iloc_x > 0) {
                    this.faccum(map, offset - scan * 4 - 4, 1.0f - floc_x - floc_y + fract, fvals);
                }
            }
        }
    }
}

