/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.es2;

import com.sun.prism.es2.ES2Context;
import com.sun.prism.es2.ES2TextureData;
import com.sun.prism.impl.PrismTrace;

class ES2RTTextureData
extends ES2TextureData {
    private int fboID;
    private int dbID;
    private int rbID;

    ES2RTTextureData(ES2Context context, int texID, int fboID, int w, int h, long size) {
        super(context, texID, size);
        this.fboID = fboID;
        PrismTrace.rttCreated((long)fboID, w, h, size);
    }

    public int getFboID() {
        return this.fboID;
    }

    public int getMSAARenderBufferID() {
        return this.rbID;
    }

    void setMSAARenderBufferID(int rbID) {
        assert (this.getTexID() == 0);
        this.rbID = rbID;
    }

    public int getDepthBufferID() {
        return this.dbID;
    }

    void setDepthBufferID(int dbID) {
        this.dbID = dbID;
    }

    @Override
    void traceDispose() {
        PrismTrace.rttDisposed(this.fboID);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.fboID != 0) {
            this.context.getGLContext().deleteFBO(this.fboID);
            if (this.dbID != 0) {
                this.context.getGLContext().deleteRenderBuffer(this.dbID);
                this.dbID = 0;
            }
            if (this.rbID != 0) {
                this.context.getGLContext().deleteRenderBuffer(this.rbID);
                this.rbID = 0;
            }
            this.fboID = 0;
        }
    }
}

