/*
 * Decompiled with CFR 0.152.
 */
package com.sun.openpisces;

import com.sun.javafx.geom.PathConsumer2D;
import com.sun.openpisces.AlphaConsumer;
import com.sun.openpisces.Curve;
import com.sun.openpisces.Helpers;
import java.util.Arrays;

public final class Renderer
implements PathConsumer2D {
    private static final int YMAX = 0;
    private static final int CURX = 1;
    private static final int OR = 2;
    private static final int SLOPE = 3;
    private static final int NEXT = 4;
    private static final int SIZEOF_EDGE = 5;
    private int sampleRowMin;
    private int sampleRowMax;
    private float edgeMinX;
    private float edgeMaxX;
    private float[] edges;
    private int[] edgeBuckets;
    private int numEdges;
    private static final float DEC_BND = 1.0f;
    private static final float INC_BND = 0.4f;
    public static final int WIND_EVEN_ODD = 0;
    public static final int WIND_NON_ZERO = 1;
    private final int SUBPIXEL_LG_POSITIONS_X;
    private final int SUBPIXEL_LG_POSITIONS_Y;
    private final int SUBPIXEL_POSITIONS_X;
    private final int SUBPIXEL_POSITIONS_Y;
    private final int SUBPIXEL_MASK_X;
    private final int SUBPIXEL_MASK_Y;
    final int MAX_AA_ALPHA;
    private int boundsMinX;
    private int boundsMinY;
    private int boundsMaxX;
    private int boundsMaxY;
    private int windingRule;
    private float x0;
    private float y0;
    private float pix_sx0;
    private float pix_sy0;
    private Curve c = new Curve();
    private int[] savedAlpha;
    private ScanlineIterator savedIterator;

    private void addEdgeToBucket(int eptr, int bucket) {
        this.edges[eptr + 4] = this.edgeBuckets[bucket * 2];
        this.edgeBuckets[bucket * 2] = eptr + 1;
        int n = bucket * 2 + 1;
        this.edgeBuckets[n] = this.edgeBuckets[n] + 2;
    }

    private void quadBreakIntoLinesAndAdd(float x0, float y0, Curve c, float x2, float y2) {
        float QUAD_DEC_BND = 32.0f;
        int countlg = 4;
        int count = 16;
        int countsq = count * count;
        float maxDD = Math.max(c.dbx / (float)countsq, c.dby / (float)countsq);
        while (maxDD > 32.0f) {
            maxDD /= 4.0f;
            count <<= 1;
        }
        countsq = count * count;
        float ddx = c.dbx / (float)countsq;
        float ddy = c.dby / (float)countsq;
        float dx = c.bx / (float)countsq + c.cx / (float)count;
        float dy = c.by / (float)countsq + c.cy / (float)count;
        while (count-- > 1) {
            float x1 = x0 + dx;
            dx += ddx;
            float y1 = y0 + dy;
            dy += ddy;
            this.addLine(x0, y0, x1, y1);
            x0 = x1;
            y0 = y1;
        }
        this.addLine(x0, y0, x2, y2);
    }

    private void curveBreakIntoLinesAndAdd(float x0, float y0, Curve c, float x3, float y3) {
        int countlg = 3;
        int count = 8;
        float dddx = 2.0f * c.dax / 512.0f;
        float dddy = 2.0f * c.day / 512.0f;
        float ddx = dddx + c.dbx / 64.0f;
        float ddy = dddy + c.dby / 64.0f;
        float dx = c.ax / 512.0f + c.bx / 64.0f + c.cx / 8.0f;
        float dy = c.ay / 512.0f + c.by / 64.0f + c.cy / 8.0f;
        float x1 = x0;
        float y1 = y0;
        while (count > 0) {
            while (Math.abs(ddx) > 1.0f || Math.abs(ddy) > 1.0f) {
                ddx = ddx / 4.0f - (dddx /= 8.0f);
                ddy = ddy / 4.0f - (dddy /= 8.0f);
                dx = (dx - ddx) / 2.0f;
                dy = (dy - ddy) / 2.0f;
                count <<= 1;
            }
            while (count % 2 == 0 && Math.abs(dx) <= 0.4f && Math.abs(dy) <= 0.4f) {
                dx = 2.0f * dx + ddx;
                dy = 2.0f * dy + ddy;
                ddx = 4.0f * (ddx + dddx);
                ddy = 4.0f * (ddy + dddy);
                dddx = 8.0f * dddx;
                dddy = 8.0f * dddy;
                count >>= 1;
            }
            if (--count > 0) {
                x1 += dx;
                dx += ddx;
                ddx += dddx;
                y1 += dy;
                dy += ddy;
                ddy += dddy;
            } else {
                x1 = x3;
                y1 = y3;
            }
            this.addLine(x0, y0, x1, y1);
            x0 = x1;
            y0 = y1;
        }
    }

    private void addLine(float x1, float y1, float x2, float y2) {
        float slope;
        int lastCrossing;
        int firstCrossing;
        float or = 1.0f;
        if (y2 < y1) {
            or = y2;
            y2 = y1;
            y1 = or;
            or = x2;
            x2 = x1;
            x1 = or;
            or = 0.0f;
        }
        if ((firstCrossing = Math.max((int)Math.ceil(y1 - 0.5f), this.boundsMinY)) >= (lastCrossing = Math.min((int)Math.ceil(y2 - 0.5f), this.boundsMaxY))) {
            return;
        }
        if (firstCrossing < this.sampleRowMin) {
            this.sampleRowMin = firstCrossing;
        }
        if (lastCrossing > this.sampleRowMax) {
            this.sampleRowMax = lastCrossing;
        }
        if ((slope = (x2 - x1) / (y2 - y1)) > 0.0f) {
            if (x1 < this.edgeMinX) {
                this.edgeMinX = x1;
            }
            if (x2 > this.edgeMaxX) {
                this.edgeMaxX = x2;
            }
        } else {
            if (x2 < this.edgeMinX) {
                this.edgeMinX = x2;
            }
            if (x1 > this.edgeMaxX) {
                this.edgeMaxX = x1;
            }
        }
        int ptr = this.numEdges * 5;
        this.edges = Helpers.widenArray(this.edges, ptr, 5);
        ++this.numEdges;
        this.edges[ptr + 2] = or;
        this.edges[ptr + 1] = x1 + ((float)firstCrossing + 0.5f - y1) * slope;
        this.edges[ptr + 3] = slope;
        this.edges[ptr + 0] = lastCrossing;
        int bucketIdx = firstCrossing - this.boundsMinY;
        this.addEdgeToBucket(ptr, bucketIdx);
        int n = (lastCrossing - this.boundsMinY) * 2 + 1;
        this.edgeBuckets[n] = this.edgeBuckets[n] | 1;
    }

    public Renderer(int subpixelLgPositionsX, int subpixelLgPositionsY) {
        this.SUBPIXEL_LG_POSITIONS_X = subpixelLgPositionsX;
        this.SUBPIXEL_LG_POSITIONS_Y = subpixelLgPositionsY;
        this.SUBPIXEL_POSITIONS_X = 1 << this.SUBPIXEL_LG_POSITIONS_X;
        this.SUBPIXEL_POSITIONS_Y = 1 << this.SUBPIXEL_LG_POSITIONS_Y;
        this.SUBPIXEL_MASK_X = this.SUBPIXEL_POSITIONS_X - 1;
        this.SUBPIXEL_MASK_Y = this.SUBPIXEL_POSITIONS_Y - 1;
        this.MAX_AA_ALPHA = this.SUBPIXEL_POSITIONS_X * this.SUBPIXEL_POSITIONS_Y;
    }

    public Renderer(int subpixelLgPositionsX, int subpixelLgPositionsY, int pix_boundsX, int pix_boundsY, int pix_boundsWidth, int pix_boundsHeight, int windingRule) {
        this(subpixelLgPositionsX, subpixelLgPositionsY);
        this.reset(pix_boundsX, pix_boundsY, pix_boundsWidth, pix_boundsHeight, windingRule);
    }

    public void reset(int pix_boundsX, int pix_boundsY, int pix_boundsWidth, int pix_boundsHeight, int windingRule) {
        this.windingRule = windingRule;
        this.boundsMinX = pix_boundsX * this.SUBPIXEL_POSITIONS_X;
        this.boundsMinY = pix_boundsY * this.SUBPIXEL_POSITIONS_Y;
        this.boundsMaxX = (pix_boundsX + pix_boundsWidth) * this.SUBPIXEL_POSITIONS_X;
        this.boundsMaxY = (pix_boundsY + pix_boundsHeight) * this.SUBPIXEL_POSITIONS_Y;
        this.edgeMinX = Float.POSITIVE_INFINITY;
        this.edgeMaxX = Float.NEGATIVE_INFINITY;
        this.sampleRowMax = this.boundsMinY;
        this.sampleRowMin = this.boundsMaxY;
        int numBuckets = this.boundsMaxY - this.boundsMinY;
        if (this.edgeBuckets == null || this.edgeBuckets.length < numBuckets * 2 + 2) {
            this.edgeBuckets = new int[numBuckets * 2 + 2];
        } else {
            Arrays.fill(this.edgeBuckets, 0, numBuckets * 2, 0);
        }
        if (this.edges == null) {
            this.edges = new float[160];
        }
        this.numEdges = 0;
        this.y0 = 0.0f;
        this.x0 = 0.0f;
        this.pix_sy0 = 0.0f;
        this.pix_sx0 = 0.0f;
    }

    private float tosubpixx(float pix_x) {
        return pix_x * (float)this.SUBPIXEL_POSITIONS_X;
    }

    private float tosubpixy(float pix_y) {
        return pix_y * (float)this.SUBPIXEL_POSITIONS_Y;
    }

    @Override
    public void moveTo(float pix_x0, float pix_y0) {
        this.closePath();
        this.pix_sx0 = pix_x0;
        this.pix_sy0 = pix_y0;
        this.y0 = this.tosubpixy(pix_y0);
        this.x0 = this.tosubpixx(pix_x0);
    }

    @Override
    public void lineTo(float pix_x1, float pix_y1) {
        float x1 = this.tosubpixx(pix_x1);
        float y1 = this.tosubpixy(pix_y1);
        this.addLine(this.x0, this.y0, x1, y1);
        this.x0 = x1;
        this.y0 = y1;
    }

    @Override
    public void curveTo(float x1, float y1, float x2, float y2, float x3, float y3) {
        float xe = this.tosubpixx(x3);
        float ye = this.tosubpixy(y3);
        this.c.set(this.x0, this.y0, this.tosubpixx(x1), this.tosubpixy(y1), this.tosubpixx(x2), this.tosubpixy(y2), xe, ye);
        this.curveBreakIntoLinesAndAdd(this.x0, this.y0, this.c, xe, ye);
        this.x0 = xe;
        this.y0 = ye;
    }

    @Override
    public void quadTo(float x1, float y1, float x2, float y2) {
        float xe = this.tosubpixx(x2);
        float ye = this.tosubpixy(y2);
        this.c.set(this.x0, this.y0, this.tosubpixx(x1), this.tosubpixy(y1), xe, ye);
        this.quadBreakIntoLinesAndAdd(this.x0, this.y0, this.c, xe, ye);
        this.x0 = xe;
        this.y0 = ye;
    }

    @Override
    public void closePath() {
        this.lineTo(this.pix_sx0, this.pix_sy0);
    }

    @Override
    public void pathDone() {
        this.closePath();
    }

    public void produceAlphas(AlphaConsumer ac) {
        ac.setMaxAlpha(this.MAX_AA_ALPHA);
        int mask = this.windingRule == 0 ? 1 : -1;
        int width = ac.getWidth();
        int[] alpha = this.savedAlpha;
        if (alpha == null || alpha.length < width + 2) {
            this.savedAlpha = alpha = new int[width + 2];
        } else {
            Arrays.fill(alpha, 0, width + 2, 0);
        }
        int bboxx0 = ac.getOriginX() << this.SUBPIXEL_LG_POSITIONS_X;
        int bboxx1 = bboxx0 + (width << this.SUBPIXEL_LG_POSITIONS_X);
        int pix_maxX = bboxx1 >> this.SUBPIXEL_LG_POSITIONS_X;
        int pix_minX = bboxx0 >> this.SUBPIXEL_LG_POSITIONS_Y;
        int y = this.boundsMinY;
        ScanlineIterator it = this.savedIterator;
        if (it == null) {
            this.savedIterator = it = new ScanlineIterator();
        } else {
            it.reset();
        }
        while (it.hasNext()) {
            int numCrossings = it.next();
            int[] crossings = it.crossings;
            y = it.curY();
            if (numCrossings > 0) {
                int lowx = crossings[0] >> 1;
                int highx = crossings[numCrossings - 1] >> 1;
                int x0 = Math.max(lowx, bboxx0);
                int x1 = Math.min(highx, bboxx1);
                pix_minX = Math.min(pix_minX, x0 >> this.SUBPIXEL_LG_POSITIONS_X);
                pix_maxX = Math.max(pix_maxX, x1 >> this.SUBPIXEL_LG_POSITIONS_X);
            }
            int sum = 0;
            int prev = bboxx0;
            for (int i = 0; i < numCrossings; ++i) {
                int x1;
                int x0;
                int curxo = crossings[i];
                int curx = curxo >> 1;
                int crorientation = ((curxo & 1) << 1) - 1;
                if ((sum & mask) != 0 && (x0 = Math.max(prev, bboxx0)) < (x1 = Math.min(curx, bboxx1))) {
                    int pix_x = (x0 -= bboxx0) >> this.SUBPIXEL_LG_POSITIONS_X;
                    int pix_xmaxm1 = (x1 -= bboxx0) - 1 >> this.SUBPIXEL_LG_POSITIONS_X;
                    if (pix_x == pix_xmaxm1) {
                        int n = pix_x;
                        alpha[n] = alpha[n] + (x1 - x0);
                        int n2 = pix_x + 1;
                        alpha[n2] = alpha[n2] - (x1 - x0);
                    } else {
                        int pix_xmax = x1 >> this.SUBPIXEL_LG_POSITIONS_X;
                        int n = pix_x;
                        alpha[n] = alpha[n] + (this.SUBPIXEL_POSITIONS_X - (x0 & this.SUBPIXEL_MASK_X));
                        int n3 = pix_x + 1;
                        alpha[n3] = alpha[n3] + (x0 & this.SUBPIXEL_MASK_X);
                        int n4 = pix_xmax;
                        alpha[n4] = alpha[n4] - (this.SUBPIXEL_POSITIONS_X - (x1 & this.SUBPIXEL_MASK_X));
                        int n5 = pix_xmax + 1;
                        alpha[n5] = alpha[n5] - (x1 & this.SUBPIXEL_MASK_X);
                    }
                }
                sum += crorientation;
                prev = curx;
            }
            if ((y & this.SUBPIXEL_MASK_Y) != this.SUBPIXEL_MASK_Y) continue;
            ac.setAndClearRelativeAlphas(alpha, y >> this.SUBPIXEL_LG_POSITIONS_Y, pix_minX, pix_maxX);
            pix_maxX = bboxx1 >> this.SUBPIXEL_LG_POSITIONS_X;
            pix_minX = bboxx0 >> this.SUBPIXEL_LG_POSITIONS_Y;
        }
        if ((y & this.SUBPIXEL_MASK_Y) < this.SUBPIXEL_MASK_Y) {
            ac.setAndClearRelativeAlphas(alpha, y >> this.SUBPIXEL_LG_POSITIONS_Y, pix_minX, pix_maxX);
        }
    }

    public int getSubpixMinX() {
        int sampleColMin = (int)Math.ceil(this.edgeMinX - 0.5f);
        if (sampleColMin < this.boundsMinX) {
            sampleColMin = this.boundsMinX;
        }
        return sampleColMin;
    }

    public int getSubpixMaxX() {
        int sampleColMax = (int)Math.ceil(this.edgeMaxX - 0.5f);
        if (sampleColMax > this.boundsMaxX) {
            sampleColMax = this.boundsMaxX;
        }
        return sampleColMax;
    }

    public int getSubpixMinY() {
        return this.sampleRowMin;
    }

    public int getSubpixMaxY() {
        return this.sampleRowMax;
    }

    public int getOutpixMinX() {
        return this.getSubpixMinX() >> this.SUBPIXEL_LG_POSITIONS_X;
    }

    public int getOutpixMaxX() {
        return this.getSubpixMaxX() + this.SUBPIXEL_MASK_X >> this.SUBPIXEL_LG_POSITIONS_X;
    }

    public int getOutpixMinY() {
        return this.sampleRowMin >> this.SUBPIXEL_LG_POSITIONS_Y;
    }

    public int getOutpixMaxY() {
        return this.sampleRowMax + this.SUBPIXEL_MASK_Y >> this.SUBPIXEL_LG_POSITIONS_Y;
    }

    private final class ScanlineIterator {
        private int[] crossings = new int[10];
        private int[] edgePtrs = new int[10];
        private int edgeCount;
        private int nextY;
        private static final int INIT_CROSSINGS_SIZE = 10;

        private ScanlineIterator() {
            this.reset();
        }

        public void reset() {
            this.nextY = Renderer.this.sampleRowMin;
            this.edgeCount = 0;
        }

        private int next() {
            int ecur;
            int i;
            int cury = this.nextY++;
            int bucket = cury - Renderer.this.boundsMinY;
            int count = this.edgeCount;
            int[] ptrs = this.edgePtrs;
            float[] edges = Renderer.this.edges;
            int bucketcount = Renderer.this.edgeBuckets[bucket * 2 + 1];
            if ((bucketcount & 1) != 0) {
                int newCount = 0;
                for (i = 0; i < count; ++i) {
                    ecur = ptrs[i];
                    if (!(edges[ecur + 0] > (float)cury)) continue;
                    ptrs[newCount++] = ecur;
                }
                count = newCount;
            }
            ptrs = Helpers.widenArray(ptrs, count, bucketcount >> 1);
            int ecur2 = Renderer.this.edgeBuckets[bucket * 2];
            while (ecur2 != 0) {
                ptrs[count++] = --ecur2;
                ecur2 = (int)edges[ecur2 + 4];
            }
            this.edgePtrs = ptrs;
            this.edgeCount = count;
            int[] xings = this.crossings;
            if (xings.length < count) {
                this.crossings = xings = new int[ptrs.length];
            }
            for (i = 0; i < count; ++i) {
                int jcross;
                ecur = ptrs[i];
                float curx = edges[ecur + 1];
                int cross = (int)Math.ceil(curx - 0.5f) << 1;
                edges[ecur + 1] = curx + edges[ecur + 3];
                if (edges[ecur + 2] > 0.0f) {
                    cross |= 1;
                }
                int j = i;
                while (--j >= 0 && (jcross = xings[j]) > cross) {
                    xings[j + 1] = jcross;
                    ptrs[j + 1] = ptrs[j];
                }
                xings[j + 1] = cross;
                ptrs[j + 1] = ecur;
            }
            return count;
        }

        private boolean hasNext() {
            return this.nextY < Renderer.this.sampleRowMax;
        }

        private int curY() {
            return this.nextY - 1;
        }
    }
}

