/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.swt;

import com.sun.glass.ui.Cursor;
import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.Screen;
import com.sun.glass.ui.View;
import com.sun.glass.ui.Window;
import com.sun.glass.ui.swt.SWTApplication;
import com.sun.glass.ui.swt.SWTCursor;
import com.sun.glass.ui.swt.SWTView;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

final class SWTWindow
extends Window {
    Shell shell;
    static SWTWindow focusWindow;

    protected SWTWindow(Window owner, Screen screen, int styleMask) {
        super(owner, screen, styleMask);
    }

    protected SWTWindow(long parent) {
        super(parent);
    }

    @Override
    protected long _createWindow(long ownerPtr, long screenPtr, int mask) {
        Shell parent;
        int bits = 0x140000;
        if ((mask & 1) != 0) {
            if ((mask & 0x10) != 0) {
                bits |= 0x40;
            }
            if ((mask & 0x20) != 0) {
                bits |= 0x80;
            }
            if ((mask & 0x40) != 0) {
                bits |= 0x400;
            }
            bits |= 0x10;
        } else {
            bits |= 0x80008;
        }
        if ((mask & 4) != 0) {
            bits |= 4;
        }
        if ((mask & 8) != 0) {
            bits |= 4;
        }
        if ((mask & 0x80) != 0) {
            bits |= 0x4000000;
        }
        this.shell = (parent = (Shell)SWTApplication.findWidget(ownerPtr)) != null ? new Shell(parent, bits) : new Shell(Display.getDefault(), bits);
        if ((mask & 2) != 0) {
            this.shell.setData("transparent", (Object)true);
        }
        int[] shellEvents = new int[]{26, 21, 27, 19, 20, 10, 11, 12};
        Listener shellListener = event -> this.handleShellEvent(event);
        for (int i = 0; i < shellEvents.length; ++i) {
            this.shell.addListener(shellEvents[i], shellListener);
        }
        this.shell.setData((Object)this);
        return SWTApplication.getHandle(this.shell);
    }

    void handleShellEvent(Event event) {
        switch (event.type) {
            case 26: {
                this.notifyFocus(542);
                break;
            }
            case 27: {
                if (focusWindow != null) break;
                this.notifyFocus(541);
                break;
            }
            case 19: {
                Rectangle rect = this.shell.getBounds();
                this.notifyResize(531, rect.width, rect.height);
                break;
            }
            case 20: {
                Rectangle rect = this.shell.getBounds();
                this.notifyResize(533, rect.width, rect.height);
                break;
            }
            case 10: {
                Rectangle rect = this.shell.getBounds();
                Rectangle trim = this.shell.computeTrim(0, 0, rect.width, rect.height);
                this.notifyMove(rect.x - trim.x, rect.y - trim.y);
                break;
            }
            case 11: {
                Rectangle bounds = this.shell.getBounds();
                this.notifyResize(511, bounds.width, bounds.height);
                Rectangle rect = this.shell.getClientArea();
                Control[] children = this.shell.getChildren();
                for (int i = 0; i < children.length; ++i) {
                    children[i].setBounds(rect);
                }
                break;
            }
            case 21: {
                this.notifyClose();
                event.doit = false;
                break;
            }
            case 12: {
                Image oldImage = this.shell.getImage();
                if (oldImage != null) {
                    this.shell.setImage(null);
                    oldImage.dispose();
                }
                this.notifyDestroy();
                break;
            }
        }
    }

    @Override
    protected long _createChildWindow(long parent) {
        return this._createWindow(parent, 0L, 0);
    }

    @Override
    protected boolean _close(long ptr) {
        this.shell.dispose();
        return true;
    }

    @Override
    protected boolean _setView(long ptr, View view) {
        if (view == null) {
            return true;
        }
        Canvas canvas = ((SWTView)view).canvas;
        boolean success = canvas.setParent((Composite)this.shell);
        if (success) {
            canvas.setBounds(canvas.getParent().getClientArea());
            if (this.shell.getData("transparent") != null) {
                SWTApplication.setTransparent(this.shell);
            }
        }
        return success;
    }

    @Override
    protected void _setBounds(long ptr, int x, int y, boolean xSet, boolean ySet, int w, int h, int cw, int ch, float xGravity, float yGravity) {
        this.shell.getDisplay().syncExec(() -> {
            Rectangle rect = this.shell.getBounds();
            if (xSet) {
                rect.x = x;
            }
            if (ySet) {
                rect.y = y;
            }
            boolean hSet = false;
            boolean wSet = false;
            if (w != -1) {
                wSet = true;
                rect.width = w;
            } else if (cw != -1) {
                wSet = true;
                rect.width = cw;
            }
            if (h != -1) {
                hSet = true;
                rect.height = h;
            } else if (ch != -1) {
                hSet = true;
                rect.height = ch;
            }
            if (wSet || hSet) {
                Rectangle bounds = this.shell.computeTrim(rect.x, rect.y, rect.width, rect.height);
                this.shell.setBounds(rect.x, rect.y, bounds.width, bounds.height);
            } else {
                this.shell.setLocation(rect.x, rect.y);
            }
        });
    }

    @Override
    protected boolean _setMenubar(long ptr, long menubarPtr) {
        return true;
    }

    @Override
    protected boolean _minimize(long ptr, boolean minimize) {
        this.shell.setMinimized(minimize);
        return this.shell.getMinimized();
    }

    @Override
    protected boolean _maximize(long ptr, boolean maximize, boolean wasMaximized) {
        this.shell.setMaximized(maximize);
        return this.shell.getMaximized();
    }

    @Override
    protected boolean _setVisible(long ptr, boolean visible) {
        this.shell.getDisplay().syncExec(() -> {
            if ((this.shell.getStyle() & 0x80000) != 0) {
                this.shell.setVisible(visible);
            } else if (visible) {
                this.shell.open();
                this.shell.setFocus();
            } else {
                this.shell.setVisible(false);
            }
        });
        return true;
    }

    @Override
    protected boolean _setResizable(long ptr, boolean resizable) {
        return true;
    }

    @Override
    protected boolean _requestFocus(long ptr, int event) {
        this.shell.setFocus();
        return true;
    }

    @Override
    protected void _setFocusable(long ptr, boolean isFocusable) {
    }

    @Override
    protected boolean _setTitle(long ptr, String title) {
        this.shell.setText(title);
        return true;
    }

    @Override
    protected void _setLevel(long ptr, int level) {
    }

    @Override
    protected void _setAlpha(long ptr, float alpha) {
        this.shell.setAlpha((int)(alpha * 255.0f));
    }

    @Override
    protected boolean _setBackground(long ptr, float r, float g, float b) {
        return true;
    }

    @Override
    protected void _setEnabled(long ptr, boolean enabled) {
        this.shell.setEnabled(enabled);
    }

    @Override
    protected boolean _setMinimumSize(long ptr, int width, int height) {
        Point pt = new Point(width, height);
        this.shell.setMinimumSize(pt);
        return pt.equals((Object)this.shell.getMinimumSize());
    }

    @Override
    protected boolean _setMaximumSize(long ptr, int width, int height) {
        return false;
    }

    @Override
    protected void _setIcon(long ptr, Pixels pixels) {
        Image oldImage = this.shell.getImage();
        Image newImage = SWTApplication.createImage(pixels);
        this.shell.setImage(newImage);
        if (oldImage != null) {
            oldImage.dispose();
        }
    }

    @Override
    protected void _toFront(long ptr) {
        this.shell.moveAbove(null);
    }

    @Override
    protected void _toBack(long ptr) {
        this.shell.moveBelow(null);
    }

    @Override
    protected void _enterModal(long ptr) {
    }

    @Override
    protected void _enterModalWithWindow(long dialog, long window) {
    }

    @Override
    protected void _exitModal(long ptr) {
    }

    @Override
    protected boolean _grabFocus(long ptr) {
        focusWindow = this;
        return true;
    }

    @Override
    protected void _ungrabFocus(long ptr) {
        focusWindow = null;
    }

    @Override
    protected void _setCursor(long ptr, Cursor cursor) {
        int id = 0;
        switch (cursor.getType()) {
            case 1: {
                this.shell.setCursor(null);
                return;
            }
            case 3: {
                id = 2;
                break;
            }
            case 2: {
                id = 19;
                break;
            }
            case 14: {
                id = 1;
                break;
            }
            case 15: {
                id = 16;
                break;
            }
            case 16: {
                id = 15;
                break;
            }
            case 17: {
                id = 17;
                break;
            }
            case 18: {
                id = 14;
                break;
            }
            case 9: {
                id = 10;
                break;
            }
            case 10: {
                id = 11;
                break;
            }
            case 7: {
                id = 13;
                break;
            }
            case 8: {
                id = 12;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                id = 21;
                break;
            }
            case 19: {
                id = 5;
                break;
            }
            case 13: {
                break;
            }
            case 11: {
                id = 9;
                break;
            }
            case 12: {
                id = 7;
                break;
            }
            case -1: {
                break;
            }
            case 0: {
                org.eclipse.swt.graphics.Cursor swtCursor = ((SWTCursor)cursor).cursor;
                if (swtCursor == null) break;
                this.shell.setCursor(swtCursor);
                return;
            }
        }
        Display display = Display.getDefault();
        org.eclipse.swt.graphics.Cursor swtCursor = display.getSystemCursor(id);
        this.shell.setCursor(swtCursor);
    }

    @Override
    protected native void _requestInput(long var1, String var3, int var4, double var5, double var7, double var9, double var11, double var13, double var15, double var17, double var19, double var21, double var23, double var25, double var27, double var29, double var31);

    @Override
    protected native void _releaseInput(long var1);

    @Override
    protected int _getEmbeddedX(long ptr) {
        return 0;
    }

    @Override
    protected int _getEmbeddedY(long ptr) {
        return 0;
    }
}

