/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.swt;

import com.sun.glass.ui.Timer;
import org.eclipse.swt.widgets.Display;

final class SWTTimer
extends Timer
implements Runnable {
    Runnable timerRunnable;
    int period = 16;
    static final boolean THREAD_TIMER = System.getProperty("glass.swt.threadtimer") != null;

    protected SWTTimer(Runnable runnable) {
        super(runnable);
    }

    @Override
    protected long _start(Runnable runnable) {
        return 1L;
    }

    @Override
    protected long _start(final Runnable runnable, final int period) {
        this.period = period;
        if (THREAD_TIMER) {
            this.timerRunnable = runnable;
            new Thread(this).start();
            return 1L;
        }
        final Display display = Display.getDefault();
        this.timerRunnable = new Runnable(){

            @Override
            public void run() {
                runnable.run();
                display.timerExec(period, (Runnable)this);
            }
        };
        display.asyncExec(() -> {
            display.timerExec(period, this.timerRunnable);
            display.addListener(12, e -> {
                if (this.timerRunnable == null) {
                    return;
                }
                display.timerExec(-1, this.timerRunnable);
                this.timerRunnable = null;
            });
        });
        return 1L;
    }

    @Override
    protected void _stop(long timer) {
        if (this.timerRunnable == null) {
            return;
        }
        if (THREAD_TIMER) {
            this.timerRunnable = null;
            return;
        }
        Display display = Display.getDefault();
        display.asyncExec(() -> {
            if (this.timerRunnable == null) {
                return;
            }
            display.timerExec(-1, this.timerRunnable);
            this.timerRunnable = null;
        });
    }

    @Override
    public void run() {
        while (this.timerRunnable != null) {
            long startTime = System.currentTimeMillis();
            this.timerRunnable.run();
            long sleepTime = (long)this.period - (System.currentTimeMillis() - startTime);
            if (sleepTime <= 0L) continue;
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

