/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tools.packager.bundlers;

import com.oracle.tools.packager.BundlerParamInfo;
import com.oracle.tools.packager.Log;
import com.oracle.tools.packager.RelativeFileSet;
import com.oracle.tools.packager.StandardBundlerParam;
import com.oracle.tools.packager.linux.LinuxAppBundler;
import com.oracle.tools.packager.mac.MacAppBundler;
import com.oracle.tools.packager.windows.WindowsBundlerParam;
import com.sun.javafx.tools.packager.bundlers.Bundler;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class BundleParams {
    protected final Map<String, ? super Object> params;
    public static final String PARAM_RUNTIME = "runtime";
    public static final String PARAM_APP_RESOURCES = "appResources";
    public static final String PARAM_TYPE = "type";
    public static final String PARAM_BUNDLE_FORMAT = "bundleFormat";
    public static final String PARAM_ICON = "icon";
    public static final String PARAM_NAME = "name";
    public static final String PARAM_VENDOR = "vendor";
    public static final String PARAM_EMAIL = "email";
    public static final String PARAM_COPYRIGHT = "copyright";
    public static final String PARAM_IDENTIFIER = "identifier";
    public static final String PARAM_SHORTCUT = "shortcutHint";
    public static final String PARAM_MENU = "menuHint";
    public static final String PARAM_VERSION = "appVersion";
    public static final String PARAM_CATEGORY = "applicationCategory";
    public static final String PARAM_TITLE = "title";
    public static final String PARAM_DESCRIPTION = "description";
    public static final String PARAM_LICENSE_TYPE = "licenseType";
    public static final String PARAM_LICENSE_FILE = "licenseFile";
    public static final String PARAM_SYSTEM_WIDE = "systemWide";
    public static final String PARAM_SERVICE_HINT = "serviceHint";
    public static final String PARAM_APPLICATION_CLASS = "applicationClass";
    public static final String PARAM_INSTALLDIR_CHOOSER = "installdirChooser";
    private String mainJar = null;
    private String mainJarClassPath = null;
    private boolean useFXPackaging = true;

    public BundleParams() {
        this.params = new HashMap<String, Object>();
    }

    public BundleParams(Map<String, ?> params) {
        this.params = new HashMap(params);
    }

    public void addAllBundleParams(Map<String, ? super Object> p) {
        this.params.putAll(p);
    }

    public <C> C fetchParam(BundlerParamInfo<C> paramInfo) {
        return paramInfo.fetchFrom(this.params);
    }

    public <C> C fetchParamWithDefault(Class<C> klass, C defaultValue, String ... keys) {
        for (String key : keys) {
            Object o = this.params.get(key);
            if (klass.isInstance(o)) {
                return (C)o;
            }
            if (!this.params.containsKey(keys) || o != null) continue;
            return null;
        }
        return defaultValue;
    }

    public <C> C fetchParam(Class<C> klass, String ... keys) {
        return this.fetchParamWithDefault(klass, null, keys);
    }

    public Map<String, ? super Object> getBundleParamsAsMap() {
        return new HashMap<String, Object>(this.params);
    }

    public void setJvmargs(List<String> jvmargs) {
        this.putUnlessNullOrEmpty(StandardBundlerParam.JVM_OPTIONS.getID(), jvmargs);
    }

    public void setJvmUserArgs(Map<String, String> userArgs) {
        this.putUnlessNullOrEmpty(StandardBundlerParam.USER_JVM_OPTIONS.getID(), userArgs);
    }

    public void setJvmProperties(Map<String, String> jvmProperties) {
        this.putUnlessNullOrEmpty(StandardBundlerParam.JVM_PROPERTIES.getID(), jvmProperties);
    }

    public void setArguments(List<String> arguments) {
        this.putUnlessNullOrEmpty(StandardBundlerParam.ARGUMENTS.getID(), arguments);
    }

    public String getApplicationID() {
        return this.fetchParam(StandardBundlerParam.IDENTIFIER);
    }

    public String getPreferencesID() {
        return this.fetchParam(StandardBundlerParam.PREFERENCES_ID);
    }

    public String getTitle() {
        return this.fetchParam(StandardBundlerParam.TITLE);
    }

    public void setTitle(String title) {
        this.putUnlessNull(PARAM_TITLE, title);
    }

    public String getApplicationClass() {
        return this.fetchParam(StandardBundlerParam.MAIN_CLASS);
    }

    public void setApplicationClass(String applicationClass) {
        this.putUnlessNull(PARAM_APPLICATION_CLASS, applicationClass);
    }

    public void setPrelaoderClass(String preloaderClass) {
        this.putUnlessNull(StandardBundlerParam.PRELOADER_CLASS.getID(), preloaderClass);
    }

    public String getAppVersion() {
        return this.fetchParam(StandardBundlerParam.VERSION);
    }

    public void setAppVersion(String version) {
        this.putUnlessNull(PARAM_VERSION, version);
    }

    public String getDescription() {
        return this.fetchParam(StandardBundlerParam.DESCRIPTION);
    }

    public void setDescription(String s) {
        this.putUnlessNull(PARAM_DESCRIPTION, s);
    }

    public String getLicenseType() {
        return this.fetchParam(StandardBundlerParam.LICENSE_TYPE);
    }

    public void setLicenseType(String version) {
        this.putUnlessNull(PARAM_LICENSE_TYPE, version);
    }

    public void addLicenseFile(String path) {
        List<String> licenseFiles = this.fetchParam(StandardBundlerParam.LICENSE_FILE);
        if (licenseFiles == null || licenseFiles.isEmpty()) {
            licenseFiles = new ArrayList<String>();
            this.params.put(PARAM_LICENSE_FILE, licenseFiles);
        }
        licenseFiles.add(path);
    }

    public Boolean getSystemWide() {
        return this.fetchParam(StandardBundlerParam.SYSTEM_WIDE);
    }

    public void setSystemWide(Boolean b) {
        this.putUnlessNull(PARAM_SYSTEM_WIDE, b);
    }

    public void setServiceHint(Boolean b) {
        this.putUnlessNull(PARAM_SERVICE_HINT, b);
    }

    public void setInstalldirChooser(Boolean b) {
        this.putUnlessNull(PARAM_INSTALLDIR_CHOOSER, b);
    }

    public void setSignBundle(Boolean b) {
        this.putUnlessNull(StandardBundlerParam.SIGN_BUNDLE.getID(), b);
    }

    public RelativeFileSet getRuntime() {
        return BundleParams.getRuntime(this.params);
    }

    public static RelativeFileSet getRuntime(Map<String, ? super Object> params) {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.startsWith("linux")) {
            return LinuxAppBundler.LINUX_RUNTIME.fetchFrom(params);
        }
        if (os.contains("os x")) {
            return MacAppBundler.MAC_RUNTIME.fetchFrom(params);
        }
        if (os.startsWith("win")) {
            return WindowsBundlerParam.WIN_RUNTIME.fetchFrom(params);
        }
        return null;
    }

    public boolean isShortcutHint() {
        return this.fetchParam(StandardBundlerParam.SHORTCUT_HINT);
    }

    public void setShortcutHint(Boolean v) {
        this.putUnlessNull(PARAM_SHORTCUT, v);
    }

    public boolean isMenuHint() {
        return this.fetchParam(StandardBundlerParam.MENU_HINT);
    }

    public void setMenuHint(Boolean v) {
        this.putUnlessNull(PARAM_MENU, v);
    }

    public String getName() {
        return this.fetchParam(StandardBundlerParam.APP_NAME);
    }

    public void setName(String name) {
        this.putUnlessNull(PARAM_NAME, name);
    }

    public Bundler.BundleType getType() {
        return this.fetchParam(Bundler.BundleType.class, PARAM_TYPE);
    }

    public void setType(Bundler.BundleType type) {
        this.putUnlessNull(PARAM_TYPE, (Object)type);
    }

    public String getBundleFormat() {
        return this.fetchParam(String.class, PARAM_BUNDLE_FORMAT);
    }

    public void setBundleFormat(String t) {
        this.putUnlessNull(PARAM_BUNDLE_FORMAT, t);
    }

    public boolean getVerbose() {
        return this.fetchParam(StandardBundlerParam.VERBOSE);
    }

    public void setVerbose(Boolean verbose) {
        this.putUnlessNull(StandardBundlerParam.VERBOSE.getID(), verbose);
    }

    public List<String> getLicenseFile() {
        return this.fetchParam(StandardBundlerParam.LICENSE_FILE);
    }

    public List<String> getJvmargs() {
        return (List)StandardBundlerParam.JVM_OPTIONS.fetchFrom(this.params);
    }

    public List<String> getArguments() {
        return (List)StandardBundlerParam.ARGUMENTS.fetchFrom(this.params);
    }

    private static boolean checkJDKRoot(File jdkRoot) {
        File rtJar = new File(jdkRoot, "jre/lib/rt.jar");
        if (!rtJar.exists()) {
            Log.verbose("rt.jar is not found at " + rtJar.getAbsolutePath());
            return false;
        }
        File jfxJar = new File(jdkRoot, "jre/lib/ext/jfxrt.jar");
        if (!jfxJar.exists() && !(jfxJar = new File(jdkRoot, "jre/lib/jfxrt.jar")).exists()) {
            Log.verbose("jfxrt.jar is not found at " + jfxJar.getAbsolutePath());
            return false;
        }
        File toolsJar = new File(jdkRoot, "lib/tools.jar");
        if (!toolsJar.exists()) {
            Log.verbose("tools.jar is not found at " + toolsJar.getAbsolutePath());
            return false;
        }
        return true;
    }

    public static File validateRuntimeLocation(File javaHome) {
        File jdkRoot;
        if (javaHome == null) {
            return null;
        }
        boolean isMac = System.getProperty("os.name").toLowerCase().contains("os x");
        File rtJar = new File(javaHome, "lib/rt.jar");
        if (rtJar.exists()) {
            jdkRoot = javaHome.getParentFile();
        } else {
            File f;
            if (isMac && (f = new File(javaHome, "Contents/Home")).exists() && f.isDirectory()) {
                javaHome = f;
            }
            jdkRoot = javaHome;
        }
        if (!BundleParams.checkJDKRoot(jdkRoot)) {
            throw new RuntimeException("Can not find JDK artifacts in specified location: " + javaHome.getAbsolutePath());
        }
        return new File(jdkRoot, "jre");
    }

    public void setRuntime(File baseDir) {
        if ((baseDir = BundleParams.validateRuntimeLocation(baseDir)) == null) {
            Log.verbose("No Java runtime to embed. Package will need system Java.");
            this.params.put(PARAM_RUNTIME, null);
            return;
        }
        this.doSetRuntime(baseDir);
    }

    private void doSetRuntime(File baseDir) {
        this.params.put(PARAM_RUNTIME, baseDir.toString());
    }

    public RelativeFileSet getAppResource() {
        return this.fetchParam(StandardBundlerParam.APP_RESOURCES);
    }

    public void setAppResource(RelativeFileSet fs) {
        this.putUnlessNull(PARAM_APP_RESOURCES, fs);
    }

    public void setAppResourcesList(List<RelativeFileSet> rfs) {
        this.putUnlessNull(StandardBundlerParam.APP_RESOURCES_LIST.getID(), rfs);
    }

    public File getIcon() {
        return this.fetchParam(StandardBundlerParam.ICON);
    }

    public void setIcon(File icon) {
        this.putUnlessNull(PARAM_ICON, icon);
    }

    public String getApplicationCategory() {
        return this.fetchParam(StandardBundlerParam.CATEGORY);
    }

    public void setApplicationCategory(String category) {
        this.putUnlessNull(PARAM_CATEGORY, category);
    }

    public String getMainClassName() {
        String applicationClass = this.getApplicationClass();
        if (applicationClass == null) {
            return null;
        }
        int idx = applicationClass.lastIndexOf(".");
        if (idx >= 0) {
            return applicationClass.substring(idx + 1);
        }
        return applicationClass;
    }

    public String getCopyright() {
        return this.fetchParam(StandardBundlerParam.COPYRIGHT);
    }

    public void setCopyright(String c) {
        this.putUnlessNull(PARAM_COPYRIGHT, c);
    }

    public String getIdentifier() {
        return this.fetchParam(StandardBundlerParam.IDENTIFIER);
    }

    public void setIdentifier(String s) {
        this.putUnlessNull(PARAM_IDENTIFIER, s);
    }

    public boolean useJavaFXPackaging() {
        if (this.mainJar == null) {
            this.getMainApplicationJar();
        }
        return this.useFXPackaging;
    }

    public String getAppClassPath() {
        if (this.mainJar == null) {
            this.getMainApplicationJar();
        }
        if (this.useFXPackaging || this.mainJarClassPath == null) {
            return "";
        }
        return this.mainJarClassPath;
    }

    public String getMainApplicationJar() {
        if (this.mainJar != null) {
            return this.mainJar;
        }
        RelativeFileSet appResources = this.getAppResource();
        String applicationClass = this.getApplicationClass();
        if (appResources == null || applicationClass == null) {
            return null;
        }
        File srcdir = appResources.getBaseDirectory();
        for (String fname : appResources.getIncludedFiles()) {
            try {
                JarFile jf = new JarFile(new File(srcdir, fname));
                Manifest m = jf.getManifest();
                Attributes attrs = m != null ? m.getMainAttributes() : null;
                if (attrs == null) continue;
                boolean javaMain = applicationClass.equals(attrs.getValue(Attributes.Name.MAIN_CLASS));
                boolean fxMain = applicationClass.equals(attrs.getValue("JavaFX-Application-Class"));
                if (!javaMain && !fxMain) continue;
                this.useFXPackaging = fxMain;
                this.mainJar = fname;
                this.mainJarClassPath = attrs.getValue(Attributes.Name.CLASS_PATH);
                return this.mainJar;
            }
            catch (IOException iOException) {
            }
        }
        return null;
    }

    public String getVendor() {
        return this.fetchParam(StandardBundlerParam.VENDOR);
    }

    public void setVendor(String vendor) {
        this.putUnlessNull(PARAM_VENDOR, vendor);
    }

    public String getEmail() {
        return this.fetchParam(String.class, PARAM_EMAIL);
    }

    public void setEmail(String email) {
        this.putUnlessNull(PARAM_EMAIL, email);
    }

    public void putUnlessNull(String param, Object value) {
        if (value != null) {
            this.params.put(param, value);
        }
    }

    public void putUnlessNullOrEmpty(String param, Collection value) {
        if (value != null && !value.isEmpty()) {
            this.params.put(param, value);
        }
    }

    public void putUnlessNullOrEmpty(String param, Map value) {
        if (value != null && !value.isEmpty()) {
            this.params.put(param, value);
        }
    }
}

