/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.generator.qdox.model;

import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.hamcrest.generator.qdox.JavaClassContext;
import org.hamcrest.generator.qdox.model.ClassLibrary;
import org.hamcrest.generator.qdox.model.IndentBuffer;
import org.hamcrest.generator.qdox.model.JavaClass;
import org.hamcrest.generator.qdox.model.JavaClassParent;
import org.hamcrest.generator.qdox.model.JavaPackage;

public class JavaSource
implements Serializable,
JavaClassParent {
    private static final Set PRIMITIVE_TYPES = new HashSet();
    private JavaPackage packge;
    private List imports = new LinkedList();
    private String[] importsArray;
    private List classes = new LinkedList();
    private JavaClass[] classesArray;
    private JavaClassContext context;
    private Map resolvedTypeCache = new HashMap();
    private URL url;

    public JavaSource() {
        this(new JavaClassContext((ClassLibrary)null));
    }

    public JavaSource(JavaClassContext context) {
        this.context = context;
    }

    public void setURL(URL url) {
        this.url = url;
    }

    public URL getURL() {
        return this.url;
    }

    public void setFile(File file) {
        try {
            this.setURL(file.toURL());
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public File getFile() {
        return new File(this.url.getFile());
    }

    public JavaPackage getPackage() {
        return this.packge;
    }

    public void setPackage(JavaPackage packge) {
        this.packge = packge;
    }

    public void addImport(String imp) {
        this.imports.add(imp);
        this.importsArray = null;
    }

    public String[] getImports() {
        if (this.importsArray == null) {
            this.importsArray = new String[this.imports.size()];
            this.imports.toArray(this.importsArray);
        }
        return this.importsArray;
    }

    public void addClass(JavaClass cls) {
        cls.setSource(this);
        this.classes.add(cls);
        this.classesArray = null;
    }

    public JavaClass[] getClasses() {
        if (this.classesArray == null) {
            this.classesArray = new JavaClass[this.classes.size()];
            this.classes.toArray(this.classesArray);
        }
        return this.classesArray;
    }

    public JavaClassContext getJavaClassContext() {
        return this.context;
    }

    public void setClassLibrary(ClassLibrary classLibrary) {
        this.context.setClassLibrary(classLibrary);
    }

    public String getCodeBlock() {
        IndentBuffer result = new IndentBuffer();
        if (this.packge != null) {
            result.write("package ");
            result.write(this.packge.getName());
            result.write(';');
            result.newline();
            result.newline();
        }
        String[] imports = this.getImports();
        for (int i = 0; imports != null && i < imports.length; ++i) {
            result.write("import ");
            result.write(imports[i]);
            result.write(';');
            result.newline();
        }
        if (imports != null && imports.length > 0) {
            result.newline();
        }
        JavaClass[] classes = this.getClasses();
        for (int i = 0; i < classes.length; ++i) {
            if (i > 0) {
                result.newline();
            }
            classes[i].write(result);
        }
        return result.toString();
    }

    public String toString() {
        return this.getCodeBlock();
    }

    public String resolveType(String typeName) {
        if (this.resolvedTypeCache.containsKey(typeName)) {
            return (String)this.resolvedTypeCache.get(typeName);
        }
        String resolved = this.resolveTypeInternal(typeName);
        if (resolved != null) {
            this.resolvedTypeCache.put(typeName, resolved);
        }
        return resolved;
    }

    private String resolveTypeInternal(String typeName) {
        String resolvedName = null;
        if (PRIMITIVE_TYPES.contains(typeName)) {
            resolvedName = typeName;
        } else {
            String outerName = typeName;
            String nestedName = typeName.replace('.', '$');
            int dotpos = typeName.indexOf(46);
            if (dotpos >= 0) {
                outerName = typeName.substring(0, dotpos);
            }
            if ((resolvedName = this.resolveImportedType(typeName, nestedName, true)) != null || (resolvedName = this.resolveImportedType(outerName, nestedName, false)) != null || (resolvedName = this.resolveFullyQualifiedType(typeName)) != null || this.context.getClassLibrary() != null && ((resolvedName = this.resolveFromLibrary(this.getClassNamePrefix() + nestedName)) != null || (resolvedName = this.resolveFromLibrary("java.lang." + nestedName)) != null) || (resolvedName = this.resolveImportedType("*", nestedName, false)) == null) {
                // empty if block
            }
        }
        return resolvedName;
    }

    private String resolveImportedType(String importSpec, String typeName, boolean fullMatch) {
        String[] imports = this.getImports();
        String resolvedName = null;
        String dotSuffix = "." + importSpec;
        for (int i = 0; i < imports.length && resolvedName == null; ++i) {
            String candidateName;
            if (!imports[i].equals(importSpec) && (fullMatch || !imports[i].endsWith(dotSuffix)) || (resolvedName = this.resolveFullyQualifiedType(candidateName = imports[i].substring(0, imports[i].length() - importSpec.length()) + typeName)) != null || "*".equals(importSpec)) continue;
            resolvedName = candidateName;
        }
        return resolvedName;
    }

    private String resolveFromLibrary(String typeName) {
        return this.context.getClassLibrary().contains(typeName) ? typeName : null;
    }

    private String resolveFullyQualifiedType(String typeName) {
        if (this.context.getClassLibrary() != null) {
            int indexOfLastDot = typeName.lastIndexOf(46);
            if (indexOfLastDot >= 0) {
                String root = typeName.substring(0, indexOfLastDot);
                String leaf = typeName.substring(indexOfLastDot + 1);
                String resolvedTypeName = this.resolveFullyQualifiedType(root + "$" + leaf);
                if (resolvedTypeName != null) {
                    return resolvedTypeName;
                }
            }
            if (this.context.getClassLibrary().contains(typeName)) {
                return typeName;
            }
        }
        return null;
    }

    public String getClassNamePrefix() {
        if (this.getPackage() == null) {
            return "";
        }
        return this.getPackage().getName() + ".";
    }

    public JavaSource getParentSource() {
        return this;
    }

    public JavaClass getNestedClassByName(String name) {
        JavaClass result = null;
        ListIterator i = this.classes.listIterator();
        while (i.hasNext()) {
            JavaClass candidateClass = (JavaClass)i.next();
            if (!candidateClass.getName().equals(name)) continue;
            result = candidateClass;
            break;
        }
        return result;
    }

    public ClassLibrary getClassLibrary() {
        return this.context.getClassLibrary();
    }

    public String getPackageName() {
        return this.packge == null ? "" : this.packge.getName();
    }

    static {
        PRIMITIVE_TYPES.add("boolean");
        PRIMITIVE_TYPES.add("byte");
        PRIMITIVE_TYPES.add("char");
        PRIMITIVE_TYPES.add("double");
        PRIMITIVE_TYPES.add("float");
        PRIMITIVE_TYPES.add("int");
        PRIMITIVE_TYPES.add("long");
        PRIMITIVE_TYPES.add("short");
        PRIMITIVE_TYPES.add("void");
    }
}

