L = RootSystem(["A",2,1]).ambient_space()
P = RootSystem(["A",2,1]).weight_space(extended=True)
Lambda = P.fundamental_weights()
t = 6*Lambda[1] - 2*Lambda[2] - 4*Lambda[0]
walk = L.reduced_word_of_translation(L(t))
plot_options = L.plot_parse_options(bounding_box=[[-2,5],[-2,5]])
p = L.plot(plot_options=plot_options)        # long time
p += L.plot_alcove_walk(walk, color="green", plot_options=plot_options)
p += plot_options.family_of_vectors({t: L(t)})
plot_options.finalize(p)
sphinx_plot(p)