/*
 * Decompiled with CFR 0.152.
 */
package git4idea.remote;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.JBUI;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.remote.GitConfigureRemotesDialog;
import git4idea.remote.GitConfigureRemotesDialogKt;
import git4idea.remote.GitDefineRemoteDialog;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.Action;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0005?@ABCB\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\u001c\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J0\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020 2\u0006\u0010#\u001a\u00020 H\u0002J\u0013\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%H\u0014\u00a2\u0006\u0002\u0010'J\n\u0010(\u001a\u0004\u0018\u00010)H\u0014J\b\u0010*\u001a\u00020\u001aH\u0002J\b\u0010+\u001a\u00020\u0018H\u0016J\n\u0010,\u001a\u0004\u0018\u00010-H\u0002J\b\u0010.\u001a\u00020\u0006H\u0002J\u0010\u0010/\u001a\u00020 2\u0006\u00100\u001a\u000201H\u0002J\b\u00102\u001a\u000203H\u0002J\b\u00104\u001a\u00020\u001aH\u0002J\b\u00105\u001a\u00020\u001aH\u0002J6\u00106\u001a\u00020\u001a2\u0006\u00107\u001a\u00020 2\u0006\u00108\u001a\u00020\u00062\u0006\u00109\u001a\u00020 2\u0006\u0010:\u001a\u00020 2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u001d0<H\u0002J\u0016\u0010=\u001a\b\u0012\u0004\u0012\u0002010\u00112\u0006\u00108\u001a\u00020\u0006H\u0002J\b\u0010>\u001a\u00020\u001aH\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lgit4idea/remote/GitConfigureRemotesDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "repositories", "", "Lgit4idea/repo/GitRepository;", "(Lcom/intellij/openapi/project/Project;Ljava/util/Collection;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "NAME_COLUMN", "", "REMOTE_PADDING", "URL_COLUMN", "git", "Lgit4idea/commands/Git;", "nodes", "", "Lgit4idea/remote/GitConfigureRemotesDialog$Node;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getRepositories", "()Ljava/util/Collection;", "table", "Lcom/intellij/ui/table/JBTable;", "addRemote", "", "buildNodes", "changeRemote", "Lgit4idea/commands/GitCommandResult;", "repo", "oldName", "", "oldUrl", "newName", "newUrl", "createActions", "", "Ljavax/swing/Action;", "()[Ljavax/swing/Action;", "createCenterPanel", "Ljavax/swing/JComponent;", "editRemote", "getPreferredFocusedComponent", "getSelectedRemote", "Lgit4idea/remote/GitConfigureRemotesDialog$RemoteNode;", "getSelectedRepo", "getUrl", "remote", "Lgit4idea/repo/GitRemote;", "isRemoteSelected", "", "rebuildTable", "removeRemote", "runInModalTask", "title", "repository", "errorTitle", "errorMessage", "operation", "Lkotlin/Function0;", "sortedRemotes", "updateTableWidth", "MyCellRenderer", "Node", "RemoteNode", "RemotesTableModel", "RepoNode", "intellij.vcs.git"})
public final class GitConfigureRemotesDialog
extends DialogWrapper {
    private final Git git;
    private final Logger LOG;
    private final int NAME_COLUMN = 0;
    private final int URL_COLUMN = 1;
    private final int REMOTE_PADDING = 30;
    private final JBTable table;
    private List<? extends Node> nodes;
    @NotNull
    private final Project project;
    @NotNull
    private final Collection<GitRepository> repositories;

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[1];
        Action action = this.getOKAction();
        Intrinsics.checkExpressionValueIsNotNull((Object)action, (String)"okAction");
        actionArray[0] = action;
        return actionArray;
    }

    @NotNull
    public JBTable getPreferredFocusedComponent() {
        return this.table;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        this.table.setSelectionModel((ListSelectionModel)new DefaultListSelectionModel());
        this.table.setSelectionMode(0);
        this.table.setIntercellSpacing((Dimension)JBUI.emptySize());
        this.table.setDefaultRenderer(Object.class, (TableCellRenderer)((Object)new MyCellRenderer()));
        return ToolbarDecorator.createDecorator((JTable)((JTable)this.table)).setAddAction(new AnActionButtonRunnable(this){
            final /* synthetic */ GitConfigureRemotesDialog this$0;

            public final void run(AnActionButton it) {
                GitConfigureRemotesDialog.access$addRemote(this.this$0);
            }
            {
                this.this$0 = gitConfigureRemotesDialog;
            }
        }).setRemoveAction(new AnActionButtonRunnable(this){
            final /* synthetic */ GitConfigureRemotesDialog this$0;

            public final void run(AnActionButton it) {
                GitConfigureRemotesDialog.access$removeRemote(this.this$0);
            }
            {
                this.this$0 = gitConfigureRemotesDialog;
            }
        }).setEditAction(new AnActionButtonRunnable(this){
            final /* synthetic */ GitConfigureRemotesDialog this$0;

            public final void run(AnActionButton it) {
                GitConfigureRemotesDialog.access$editRemote(this.this$0);
            }
            {
                this.this$0 = gitConfigureRemotesDialog;
            }
        }).setEditActionUpdater(new AnActionButtonUpdater(this){
            final /* synthetic */ GitConfigureRemotesDialog this$0;

            public final boolean isEnabled(@NotNull AnActionEvent it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return GitConfigureRemotesDialog.access$isRemoteSelected(this.this$0);
            }
            {
                this.this$0 = gitConfigureRemotesDialog;
            }
        }).setRemoveActionUpdater(new AnActionButtonUpdater(this){
            final /* synthetic */ GitConfigureRemotesDialog this$0;

            public final boolean isEnabled(@NotNull AnActionEvent it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return GitConfigureRemotesDialog.access$isRemoteSelected(this.this$0);
            }
            {
                this.this$0 = gitConfigureRemotesDialog;
            }
        }).disableUpDownActions().createPanel();
    }

    private final void addRemote() {
        boolean bl;
        GitRepository repository;
        block4: {
            repository = this.getSelectedRepo();
            Collection<GitRemote> collection = repository.getRemotes();
            Intrinsics.checkExpressionValueIsNotNull(collection, (String)"repository.remotes");
            Iterable $receiver$iv = collection;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    GitRemote it;
                    GitRemote gitRemote = it = (GitRemote)element$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)gitRemote, (String)"it");
                    if (!Intrinsics.areEqual((Object)gitRemote.getName(), (Object)"origin")) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        String proposedName = bl ? "" : "origin";
        GitDefineRemoteDialog dialog = new GitDefineRemoteDialog(repository, this.git, proposedName, "");
        if (dialog.showAndGet()) {
            this.runInModalTask("Adding Remote...", repository, "Add Remote", "Couldn't add remote " + dialog.getRemoteName() + " '" + dialog.getRemoteUrl() + '\'', (Function0<? extends GitCommandResult>)((Function0)new Function0<GitCommandResult>(this, repository, dialog){
                final /* synthetic */ GitConfigureRemotesDialog this$0;
                final /* synthetic */ GitRepository $repository;
                final /* synthetic */ GitDefineRemoteDialog $dialog;

                @NotNull
                public final GitCommandResult invoke() {
                    GitCommandResult gitCommandResult = GitConfigureRemotesDialog.access$getGit$p(this.this$0).addRemote(this.$repository, this.$dialog.getRemoteName(), this.$dialog.getRemoteUrl());
                    Intrinsics.checkExpressionValueIsNotNull((Object)gitCommandResult, (String)"git.addRemote(repository\u2026teName, dialog.remoteUrl)");
                    return gitCommandResult;
                }
                {
                    this.this$0 = gitConfigureRemotesDialog;
                    this.$repository = gitRepository;
                    this.$dialog = gitDefineRemoteDialog;
                    super(0);
                }
            }));
        }
    }

    private final void removeRemote() {
        RemoteNode remoteNode = this.getSelectedRemote();
        if (remoteNode == null) {
            Intrinsics.throwNpe();
        }
        RemoteNode remoteNode2 = remoteNode;
        GitRemote remote = remoteNode2.getRemote();
        if (Messages.showYesNoDialog((Component)this.getRootPane(), (String)("Remove remote " + remote.getName() + " '" + this.getUrl(remote) + "'?"), (String)"Remove Remote", (Icon)Messages.getQuestionIcon()) == 0) {
            this.runInModalTask("Removing Remote...", remoteNode2.getRepository(), "Remove Remote", "Couldn't remove remote " + remote, (Function0<? extends GitCommandResult>)((Function0)new Function0<GitCommandResult>(this, remoteNode2, remote){
                final /* synthetic */ GitConfigureRemotesDialog this$0;
                final /* synthetic */ RemoteNode $remoteNode;
                final /* synthetic */ GitRemote $remote;

                @NotNull
                public final GitCommandResult invoke() {
                    GitCommandResult gitCommandResult = GitConfigureRemotesDialog.access$getGit$p(this.this$0).removeRemote(this.$remoteNode.getRepository(), this.$remote);
                    Intrinsics.checkExpressionValueIsNotNull((Object)gitCommandResult, (String)"git.removeRemote(remoteNode.repository, remote)");
                    return gitCommandResult;
                }
                {
                    this.this$0 = gitConfigureRemotesDialog;
                    this.$remoteNode = remoteNode;
                    this.$remote = gitRemote;
                    super(0);
                }
            }));
        }
    }

    private final void editRemote() {
        RemoteNode remoteNode = this.getSelectedRemote();
        if (remoteNode == null) {
            Intrinsics.throwNpe();
        }
        RemoteNode remoteNode2 = remoteNode;
        GitRemote remote = remoteNode2.getRemote();
        GitRepository repository = remoteNode2.getRepository();
        String string = remote.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"remote.name");
        String oldName = string;
        String oldUrl = this.getUrl(remote);
        GitDefineRemoteDialog dialog = new GitDefineRemoteDialog(repository, this.git, oldName, oldUrl);
        if (dialog.showAndGet()) {
            String string2 = dialog.getRemoteName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"dialog.remoteName");
            String newRemoteName = string2;
            String string3 = dialog.getRemoteUrl();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"dialog.remoteUrl");
            String newRemoteUrl = string3;
            if (Intrinsics.areEqual((Object)newRemoteName, (Object)oldName) && Intrinsics.areEqual((Object)newRemoteUrl, (Object)oldUrl)) {
                return;
            }
            this.runInModalTask("Changing Remote...", repository, "Change Remote", "Couldn't change remote " + oldName + " to " + newRemoteName + " '" + newRemoteUrl + '\'', (Function0<? extends GitCommandResult>)((Function0)new Function0<GitCommandResult>(this, repository, oldName, oldUrl, newRemoteName, newRemoteUrl){
                final /* synthetic */ GitConfigureRemotesDialog this$0;
                final /* synthetic */ GitRepository $repository;
                final /* synthetic */ String $oldName;
                final /* synthetic */ String $oldUrl;
                final /* synthetic */ String $newRemoteName;
                final /* synthetic */ String $newRemoteUrl;

                @NotNull
                public final GitCommandResult invoke() {
                    return GitConfigureRemotesDialog.access$changeRemote(this.this$0, this.$repository, this.$oldName, this.$oldUrl, this.$newRemoteName, this.$newRemoteUrl);
                }
                {
                    this.this$0 = gitConfigureRemotesDialog;
                    this.$repository = gitRepository;
                    this.$oldName = string;
                    this.$oldUrl = string2;
                    this.$newRemoteName = string3;
                    this.$newRemoteUrl = string4;
                    super(0);
                }
            }));
        }
    }

    private final GitCommandResult changeRemote(GitRepository repo, String oldName, String oldUrl, String newName, String newUrl) {
        GitCommandResult result2 = null;
        if (Intrinsics.areEqual((Object)newName, (Object)oldName) ^ true && !(result2 = this.git.renameRemote(repo, oldName, newName)).success()) {
            return result2;
        }
        if (Intrinsics.areEqual((Object)newUrl, (Object)oldUrl) ^ true) {
            result2 = this.git.setRemoteUrl(repo, newName, newUrl);
        }
        GitCommandResult gitCommandResult = result2;
        if (gitCommandResult == null) {
            Intrinsics.throwNpe();
        }
        return gitCommandResult;
    }

    private final void updateTableWidth() {
        int maxNameWidth = 30;
        int maxUrlWidth = 250;
        for (Node node : this.nodes) {
            int urlWidth;
            FontMetrics fontMetrics = this.table.getFontMetrics(UIManager.getFont("Table.font").deriveFont(1));
            int nameWidth = fontMetrics.stringWidth(node.getPresentableString());
            Node node2 = node;
            if (!(node2 instanceof RemoteNode)) {
                node2 = null;
            }
            RemoteNode remoteNode = (RemoteNode)node2;
            GitRemote remote = remoteNode != null ? remoteNode.getRemote() : null;
            int n = urlWidth = remote == null ? 0 : fontMetrics.stringWidth(this.getUrl(remote));
            if (maxNameWidth < nameWidth) {
                maxNameWidth = nameWidth;
            }
            if (maxUrlWidth >= urlWidth) continue;
            maxUrlWidth = urlWidth;
        }
        TableColumn tableColumn = this.table.getColumnModel().getColumn(this.NAME_COLUMN);
        Intrinsics.checkExpressionValueIsNotNull((Object)tableColumn, (String)"table.columnModel.getColumn(NAME_COLUMN)");
        tableColumn.setPreferredWidth(maxNameWidth += this.REMOTE_PADDING + 10);
        TableColumn tableColumn2 = this.table.getColumnModel().getColumn(this.URL_COLUMN);
        Intrinsics.checkExpressionValueIsNotNull((Object)tableColumn2, (String)"table.columnModel.getColumn(URL_COLUMN)");
        tableColumn2.setPreferredWidth(maxUrlWidth);
        int n = this.table.getRowHeight() * (this.table.getRowCount() + 3);
        this.table.setPreferredScrollableViewportSize(new Dimension(maxNameWidth + maxUrlWidth + 10, n));
    }

    private final List<Node> buildNodes(Collection<? extends GitRepository> repositories) {
        List nodes = new ArrayList();
        for (GitRepository repository : DvcsUtil.sortRepositories(repositories)) {
            if (repositories.size() > 1) {
                GitRepository gitRepository = repository;
                Intrinsics.checkExpressionValueIsNotNull((Object)gitRepository, (String)"repository");
                nodes.add(new RepoNode(gitRepository));
            }
            GitRepository gitRepository = repository;
            Intrinsics.checkExpressionValueIsNotNull((Object)gitRepository, (String)"repository");
            for (GitRemote remote : this.sortedRemotes(gitRepository)) {
                nodes.add(new RemoteNode(remote, repository));
            }
        }
        return nodes;
    }

    private final List<GitRemote> sortedRemotes(GitRepository repository) {
        Collection<GitRemote> collection = repository.getRemotes();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"repository.remotes");
        return CollectionsKt.sortedWith((Iterable)collection, (Comparator)sortedRemotes.1.INSTANCE);
    }

    private final void rebuildTable() {
        this.nodes = this.buildNodes(this.repositories);
        TableModel tableModel = this.table.getModel();
        if (tableModel == null) {
            throw new TypeCastException("null cannot be cast to non-null type git4idea.remote.GitConfigureRemotesDialog.RemotesTableModel");
        }
        ((RemotesTableModel)tableModel).fireTableDataChanged();
    }

    private final void runInModalTask(String title, GitRepository repository, String errorTitle, String errorMessage, Function0<? extends GitCommandResult> operation) {
        ProgressManager.getInstance().run((Task)new Task.Modal(this, operation, repository, errorMessage, errorTitle, title, this.project, title, true){
            private GitCommandResult result;
            final /* synthetic */ GitConfigureRemotesDialog this$0;
            final /* synthetic */ Function0 $operation;
            final /* synthetic */ GitRepository $repository;
            final /* synthetic */ String $errorMessage;
            final /* synthetic */ String $errorTitle;
            final /* synthetic */ String $title;

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                this.result = (GitCommandResult)this.$operation.invoke();
                this.$repository.update();
            }

            public void onSuccess() {
                block8: {
                    String string;
                    block7: {
                        GitConfigureRemotesDialog.access$rebuildTable(this.this$0);
                        if (this.result == null) break block7;
                        GitCommandResult gitCommandResult = this.result;
                        if (gitCommandResult == null) {
                            Intrinsics.throwNpe();
                        }
                        if (gitCommandResult.success()) break block8;
                    }
                    if (this.result == null) {
                        string = "operation was not executed";
                    } else {
                        GitCommandResult gitCommandResult = this.result;
                        if (gitCommandResult == null) {
                            Intrinsics.throwNpe();
                        }
                        String string2 = gitCommandResult.getErrorOutputAsJoinedString();
                        string = string2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"result!!.errorOutputAsJoinedString");
                    }
                    String errorDetails = string;
                    String message = this.$errorMessage + " in " + this.$repository + ":\n" + errorDetails;
                    GitConfigureRemotesDialog.access$getLOG$p(this.this$0).warn(message);
                    Messages.showErrorDialog((Project)this.myProject, (String)message, (String)this.$errorTitle);
                }
            }
            {
                this.this$0 = $outer;
                this.$operation = $captured_local_variable$1;
                this.$repository = $captured_local_variable$2;
                this.$errorMessage = $captured_local_variable$3;
                this.$errorTitle = $captured_local_variable$4;
                this.$title = $captured_local_variable$5;
                super($super_call_param$6, $super_call_param$7, $super_call_param$8);
            }
        });
    }

    private final GitRepository getSelectedRepo() {
        int selectedRow = this.table.getSelectedRow();
        if (selectedRow < 0) {
            List list = DvcsUtil.sortRepositories(this.repositories);
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"sortRepositories(repositories)");
            Object object = CollectionsKt.first((List)list);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"sortRepositories(repositories).first()");
            return (GitRepository)object;
        }
        Node value = this.nodes.get(selectedRow);
        if (value instanceof RepoNode) {
            return ((RepoNode)value).getRepository();
        }
        if (value instanceof RemoteNode) {
            return ((RemoteNode)value).getRepository();
        }
        throw (Throwable)new IllegalStateException("Unexpected selected value: " + value);
    }

    private final RemoteNode getSelectedRemote() {
        int selectedRow = this.table.getSelectedRow();
        if (selectedRow < 0) {
            return null;
        }
        Node node = this.nodes.get(selectedRow);
        if (!(node instanceof RemoteNode)) {
            node = null;
        }
        return (RemoteNode)node;
    }

    private final boolean isRemoteSelected() {
        return this.getSelectedRemote() != null;
    }

    private final String getUrl(GitRemote remote) {
        List<String> list = remote.getUrls();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"remote.urls");
        String string = (String)CollectionsKt.firstOrNull(list);
        if (string == null) {
            string = "";
        }
        return string;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Collection<GitRepository> getRepositories() {
        return this.repositories;
    }

    public GitConfigureRemotesDialog(@NotNull Project project, @NotNull Collection<? extends GitRepository> repositories) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(repositories, (String)"repositories");
        super(project, true, GitConfigureRemotesDialogKt.access$getModalityType());
        this.project = project;
        this.repositories = repositories;
        GitConfigureRemotesDialog gitConfigureRemotesDialog = this;
        Object object = ServiceManager.getService(Git.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getService(T::class.java)");
        Object object2 = object;
        gitConfigureRemotesDialog.git = (Git)object2;
        gitConfigureRemotesDialog = this;
        Logger logger = Logger.getInstance(GitConfigureRemotesDialog.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        object2 = logger;
        gitConfigureRemotesDialog.LOG = object2;
        this.URL_COLUMN = 1;
        this.REMOTE_PADDING = 30;
        this.table = new JBTable((TableModel)new RemotesTableModel());
        this.nodes = this.buildNodes(this.repositories);
        this.init();
        this.setTitle("Git Remotes");
        this.updateTableWidth();
    }

    public static final /* synthetic */ void access$setNodes$p(GitConfigureRemotesDialog $this, @NotNull List list) {
        $this.nodes = list;
    }

    public static final /* synthetic */ void access$addRemote(GitConfigureRemotesDialog $this) {
        $this.addRemote();
    }

    public static final /* synthetic */ void access$removeRemote(GitConfigureRemotesDialog $this) {
        $this.removeRemote();
    }

    public static final /* synthetic */ void access$editRemote(GitConfigureRemotesDialog $this) {
        $this.editRemote();
    }

    public static final /* synthetic */ boolean access$isRemoteSelected(GitConfigureRemotesDialog $this) {
        return $this.isRemoteSelected();
    }

    @NotNull
    public static final /* synthetic */ Git access$getGit$p(GitConfigureRemotesDialog $this) {
        return $this.git;
    }

    @NotNull
    public static final /* synthetic */ GitCommandResult access$changeRemote(GitConfigureRemotesDialog $this, @NotNull GitRepository repo, @NotNull String oldName, @NotNull String oldUrl, @NotNull String newName, @NotNull String newUrl) {
        return $this.changeRemote(repo, oldName, oldUrl, newName, newUrl);
    }

    public static final /* synthetic */ void access$rebuildTable(GitConfigureRemotesDialog $this) {
        $this.rebuildTable();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\"\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H&\u00a8\u0006\u0005"}, d2={"Lgit4idea/remote/GitConfigureRemotesDialog$Node;", "", "()V", "getPresentableString", "", "intellij.vcs.git"})
    private static abstract class Node {
        @NotNull
        public abstract String getPresentableString();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\n"}, d2={"Lgit4idea/remote/GitConfigureRemotesDialog$RepoNode;", "Lgit4idea/remote/GitConfigureRemotesDialog$Node;", "repository", "Lgit4idea/repo/GitRepository;", "(Lgit4idea/repo/GitRepository;)V", "getRepository", "()Lgit4idea/repo/GitRepository;", "getPresentableString", "", "toString", "intellij.vcs.git"})
    private static final class RepoNode
    extends Node {
        @NotNull
        private final GitRepository repository;

        @NotNull
        public String toString() {
            String string = this.repository.getPresentableUrl();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"repository.presentableUrl");
            return string;
        }

        @Override
        @NotNull
        public String getPresentableString() {
            String string = DvcsUtil.getShortRepositoryName((Repository)this.repository);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"DvcsUtil.getShortRepositoryName(repository)");
            return string;
        }

        @NotNull
        public final GitRepository getRepository() {
            return this.repository;
        }

        public RepoNode(@NotNull GitRepository repository) {
            Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
            this.repository = repository;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Lgit4idea/remote/GitConfigureRemotesDialog$RemoteNode;", "Lgit4idea/remote/GitConfigureRemotesDialog$Node;", "remote", "Lgit4idea/repo/GitRemote;", "repository", "Lgit4idea/repo/GitRepository;", "(Lgit4idea/repo/GitRemote;Lgit4idea/repo/GitRepository;)V", "getRemote", "()Lgit4idea/repo/GitRemote;", "getRepository", "()Lgit4idea/repo/GitRepository;", "getPresentableString", "", "toString", "intellij.vcs.git"})
    private static final class RemoteNode
    extends Node {
        @NotNull
        private final GitRemote remote;
        @NotNull
        private final GitRepository repository;

        @NotNull
        public String toString() {
            String string = this.remote.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"remote.name");
            return string;
        }

        @Override
        @NotNull
        public String getPresentableString() {
            String string = this.remote.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"remote.name");
            return string;
        }

        @NotNull
        public final GitRemote getRemote() {
            return this.remote;
        }

        @NotNull
        public final GitRepository getRepository() {
            return this.repository;
        }

        public RemoteNode(@NotNull GitRemote remote, @NotNull GitRepository repository) {
            Intrinsics.checkParameterIsNotNull((Object)remote, (String)"remote");
            Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
            this.remote = remote;
            this.repository = repository;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0016J\b\u0010\b\u001a\u00020\u0004H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0016\u00a8\u0006\r"}, d2={"Lgit4idea/remote/GitConfigureRemotesDialog$RemotesTableModel;", "Ljavax/swing/table/AbstractTableModel;", "(Lgit4idea/remote/GitConfigureRemotesDialog;)V", "getColumnCount", "", "getColumnName", "", "column", "getRowCount", "getValueAt", "", "rowIndex", "columnIndex", "intellij.vcs.git"})
    private final class RemotesTableModel
    extends AbstractTableModel {
        @Override
        public int getRowCount() {
            return GitConfigureRemotesDialog.this.nodes.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        @NotNull
        public String getColumnName(int column) {
            if (column == GitConfigureRemotesDialog.this.NAME_COLUMN) {
                return "Name";
            }
            return "URL";
        }

        @Override
        @NotNull
        public Object getValueAt(int rowIndex, int columnIndex) {
            Node node = (Node)GitConfigureRemotesDialog.this.nodes.get(rowIndex);
            if (columnIndex == GitConfigureRemotesDialog.this.NAME_COLUMN) {
                return node;
            }
            if (node instanceof RepoNode) {
                return "";
            }
            if (node instanceof RemoteNode) {
                return GitConfigureRemotesDialog.this.getUrl(((RemoteNode)node).getRemote());
            }
            GitConfigureRemotesDialog.this.LOG.error("Unexpected position at row " + rowIndex + " and column " + columnIndex);
            return "";
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J<\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0014\u00a8\u0006\u000f"}, d2={"Lgit4idea/remote/GitConfigureRemotesDialog$MyCellRenderer;", "Lcom/intellij/ui/ColoredTableCellRenderer;", "(Lgit4idea/remote/GitConfigureRemotesDialog;)V", "customizeCellRenderer", "", "table", "Ljavax/swing/JTable;", "value", "", "selected", "", "hasFocus", "row", "", "column", "intellij.vcs.git"})
    private final class MyCellRenderer
    extends ColoredTableCellRenderer {
        protected void customizeCellRenderer(@Nullable JTable table, @Nullable Object value, boolean selected, boolean hasFocus, int row, int column) {
            if (value instanceof RepoNode) {
                this.append(((RepoNode)value).getPresentableString(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            } else if (value instanceof RemoteNode) {
                if (GitConfigureRemotesDialog.this.getRepositories().size() > 1) {
                    this.append("", SimpleTextAttributes.REGULAR_ATTRIBUTES, GitConfigureRemotesDialog.this.REMOTE_PADDING, 2);
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)this.append(((RemoteNode)value).getPresentableString()), (String)"append(value.getPresentableString())");
            } else if (value instanceof String) {
                this.append((String)value);
            }
            this.setBorder(null);
        }
    }
}

