/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.messages;

import com.intellij.credentialStore.CredentialPromptDialog;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.DialogWrapperPeer;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.messages.MessageDialog;
import com.intellij.openapi.ui.messages.MessagesService;
import com.intellij.openapi.ui.messages.TwoStepConfirmationDialog;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.InsertPathAction;
import com.intellij.ui.MessageException;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.mac.MacMessages;
import com.intellij.ui.messages.ChooseDialog;
import com.intellij.ui.messages.InputDialogWithCheckbox;
import com.intellij.ui.messages.MoreInfoMessageDialog;
import com.intellij.ui.messages.PasswordInputDialog;
import com.intellij.util.Function;
import com.intellij.util.PairFunction;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Window;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MessagesServiceImpl
implements MessagesService {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ui.messages.MessagesServiceImpl");

    public int showMessageDialog(@Nullable Project project, @Nullable Component parentComponent, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String[] options, int defaultOptionIndex, int focusedOptionIndex, @Nullable Icon icon, @Nullable DialogWrapper.DoNotAskOption doNotAskOption, boolean alwaysUseIdeaUI) {
        if (options == null) {
            MessagesServiceImpl.$$$reportNull$$$0(0);
        }
        if (Messages.isApplicationInUnitTestOrHeadless()) {
            return Messages.getTestImplementation().show(message);
        }
        try {
            WindowManager windowManager;
            if (Messages.canShowMacSheetPanel() && !alwaysUseIdeaUI && (windowManager = WindowManager.getInstance()) != null) {
                Window parentWindow = windowManager.suggestParentWindow(project);
                return MacMessages.getInstance().showMessageDialog(title, message, options, false, parentWindow, defaultOptionIndex, focusedOptionIndex, doNotAskOption);
            }
        }
        catch (MessageException windowManager) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        MessageDialog dialog2 = new MessageDialog(project, parentComponent, message, title, options, defaultOptionIndex, focusedOptionIndex, icon, doNotAskOption, false);
        dialog2.show();
        return dialog2.getExitCode();
    }

    public int showMoreInfoMessageDialog(Project project, String message, String title, String moreInfo, String[] options, int defaultOptionIndex, int focusedOptionIndex, Icon icon) {
        if (Messages.isApplicationInUnitTestOrHeadless()) {
            return Messages.getTestImplementation().show(message);
        }
        try {
            if (Messages.canShowMacSheetPanel() && moreInfo == null) {
                return MacMessages.getInstance().showMessageDialog(title, message, options, false, WindowManager.getInstance().suggestParentWindow(project), defaultOptionIndex, focusedOptionIndex, null);
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        MoreInfoMessageDialog dialog2 = new MoreInfoMessageDialog(project, message, title, moreInfo, options, defaultOptionIndex, focusedOptionIndex, icon);
        dialog2.show();
        return dialog2.getExitCode();
    }

    public int showTwoStepConfirmationDialog(String message, String title, String[] options, String checkboxText, boolean checked, int defaultOptionIndex, int focusedOptionIndex, Icon icon, PairFunction<? super Integer, ? super JCheckBox, Integer> exitFunc) {
        if (Messages.isApplicationInUnitTestOrHeadless()) {
            return Messages.getTestImplementation().show(message);
        }
        TwoStepConfirmationDialog dialog2 = new TwoStepConfirmationDialog(message, title, options, checkboxText, checked, defaultOptionIndex, focusedOptionIndex, icon, exitFunc);
        dialog2.show();
        return dialog2.getExitCode();
    }

    public String showPasswordDialog(Project project, String message, String title, Icon icon, InputValidator validator) {
        if (Messages.isApplicationInUnitTestOrHeadless()) {
            return Messages.getTestInputImplementation().show(message, validator);
        }
        PasswordInputDialog dialog2 = project != null ? new PasswordInputDialog(project, message, title, icon, validator) : new PasswordInputDialog(message, title, icon, validator);
        dialog2.show();
        return dialog2.getInputString();
    }

    public char[] showPasswordDialog(@NotNull Component parentComponent, String message, String title, Icon icon, @Nullable InputValidator validator) {
        if (parentComponent == null) {
            MessagesServiceImpl.$$$reportNull$$$0(1);
        }
        if (Messages.isApplicationInUnitTestOrHeadless()) {
            return Messages.getTestInputImplementation().show(message, validator).toCharArray();
        }
        PasswordInputDialog dialog2 = new PasswordInputDialog(parentComponent, message, title, icon, validator);
        dialog2.show();
        return dialog2.getExitCode() == 0 ? CredentialPromptDialog.getTrimmedChars(dialog2.getTextField()) : null;
    }

    public String showInputDialog(@Nullable Project project, Component parentComponent, String message, String title, @Nullable Icon icon, @Nullable String initialValue, @Nullable InputValidator validator, @Nullable TextRange selection, @Nullable String comment) {
        if (Messages.isApplicationInUnitTestOrHeadless()) {
            return Messages.getTestInputImplementation().show(message, validator);
        }
        Messages.InputDialog dialog2 = new Messages.InputDialog(project, message, title, icon, initialValue, validator, new String[]{Messages.OK_BUTTON, Messages.CANCEL_BUTTON}, 0, comment);
        JTextComponent field = dialog2.getTextField();
        if (selection != null) {
            field.select(selection.getStartOffset(), selection.getEndOffset());
            field.putClientProperty(DialogWrapperPeer.HAVE_INITIAL_SELECTION, true);
        }
        dialog2.show();
        return dialog2.getInputString();
    }

    public String showMultilineInputDialog(Project project, String message, String title, String initialValue, Icon icon, @Nullable InputValidator validator) {
        if (Messages.isApplicationInUnitTestOrHeadless()) {
            return Messages.getTestInputImplementation().show(message, validator);
        }
        Messages.MultilineInputDialog dialog2 = new Messages.MultilineInputDialog(project, message, title, icon, initialValue, validator, new String[]{Messages.OK_BUTTON, Messages.CANCEL_BUTTON}, 0);
        dialog2.show();
        return dialog2.getInputString();
    }

    public Pair<String, Boolean> showInputDialogWithCheckBox(String message, String title, String checkboxText, boolean checked, boolean checkboxEnabled, Icon icon, String initialValue, InputValidator validator) {
        if (Messages.isApplicationInUnitTestOrHeadless()) {
            return new Pair((Object)Messages.getTestInputImplementation().show(message), (Object)checked);
        }
        InputDialogWithCheckbox dialog2 = new InputDialogWithCheckbox(message, title, checkboxText, checked, checkboxEnabled, icon, initialValue, validator);
        dialog2.show();
        return Pair.create((Object)dialog2.getInputString(), (Object)dialog2.isChecked());
    }

    public String showEditableChooseDialog(String message, String title, Icon icon, String[] values, String initialValue, InputValidator validator) {
        if (Messages.isApplicationInUnitTestOrHeadless()) {
            return Messages.getTestInputImplementation().show(message, validator);
        }
        ChooseDialog dialog2 = new ChooseDialog(message, title, icon, values, initialValue);
        dialog2.setValidator(validator);
        dialog2.getComboBox().setEditable(true);
        dialog2.getComboBox().getEditor().setItem(initialValue);
        dialog2.getComboBox().setSelectedItem(initialValue);
        dialog2.show();
        return dialog2.getInputString();
    }

    public int showChooseDialog(@Nullable Project project, @Nullable Component parentComponent, String message, String title, String[] values, String initialValue, @Nullable Icon icon) {
        if (Messages.isApplicationInUnitTestOrHeadless()) {
            return Messages.getTestImplementation().show(message);
        }
        ChooseDialog dialog2 = new ChooseDialog(project, parentComponent, message, title, icon, values, initialValue);
        dialog2.show();
        return dialog2.getSelectedIndex();
    }

    public void showTextAreaDialog(JTextField textField2, String title, String dimensionServiceKey, Function<? super String, ? extends List<String>> parser, Function<? super List<String>, String> lineJoiner) {
        if (Messages.isApplicationInUnitTestOrHeadless()) {
            Messages.getTestImplementation().show(title);
            return;
        }
        JTextArea textArea = new JTextArea(10, 50);
        UIUtil.addUndoRedoActions((JTextComponent)textArea);
        textArea.setWrapStyleWord(true);
        textArea.setLineWrap(true);
        List lines2 = (List)parser.fun((Object)textField2.getText());
        textArea.setText(StringUtil.join((Collection)lines2, (String)"\n"));
        InsertPathAction.copyFromTo((JTextComponent)textField2, (JTextComponent)textArea);
        DialogBuilder builder2 = new DialogBuilder((Component)textField2);
        builder2.setDimensionServiceKey(dimensionServiceKey);
        builder2.setCenterPanel((JComponent)ScrollPaneFactory.createScrollPane((Component)textArea));
        builder2.setPreferredFocusComponent((JComponent)textArea);
        String rawText = title;
        if (StringUtil.endsWithChar((CharSequence)rawText, (char)':')) {
            rawText = rawText.substring(0, rawText.length() - 1);
        }
        builder2.setTitle(rawText);
        builder2.addOkAction();
        builder2.addCancelAction();
        builder2.setOkOperation(() -> {
            textField2.setText((String)lineJoiner.fun(Arrays.asList(StringUtil.splitByLines((String)textArea.getText()))));
            builder2.getDialogWrapper().close(0);
        });
        builder2.show();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentComponent";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/messages/MessagesServiceImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "showMessageDialog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "showPasswordDialog";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

