/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkout;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.checkout.CheckoutListener;
import com.intellij.openapi.vcs.checkout.ProjectCheckoutListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.PlatformProjectOpenProcessor;
import java.io.File;
import java.util.EnumSet;
import javax.swing.Icon;

public class ProjectDirCheckoutListener
implements CheckoutListener {
    public boolean processCheckedOutDirectory(Project project, File directory) {
        File ioDotIdea = new File(directory, ".idea");
        VirtualFile dotIdea = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(ioDotIdea);
        if (dotIdea == null) {
            return false;
        }
        String message = VcsBundle.message((String)"checkout.open.project.dir.prompt", (Object[])new Object[]{ProjectCheckoutListener.getProductNameWithArticle(), directory.getPath()});
        if (Messages.showYesNoDialog((Project)project, (String)message, (String)VcsBundle.message((String)"checkout.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) == 0) {
            PlatformProjectOpenProcessor.doOpenProject(dotIdea.getParent(), project, -1, null, EnumSet.noneOf(PlatformProjectOpenProcessor.Option.class));
            return true;
        }
        return false;
    }

    public void processOpenedProject(Project lastOpenedProject) {
    }
}

