/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.commandLine;

import com.intellij.formatting.commandLine.FileSetFormatter;
import com.intellij.formatting.commandLine.MessageOutput;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationStarterEx;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.SchemeImportException;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.CodeStyleSettingsLoader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import org.jetbrains.annotations.NotNull;

public class FormatterStarter
extends ApplicationStarterEx {
    public static final String FORMAT_COMMAND_NAME = "format";
    private static final Logger LOG = Logger.getInstance(FormatterStarter.class);

    public boolean isHeadless() {
        return true;
    }

    public String getCommandName() {
        return FORMAT_COMMAND_NAME;
    }

    public void premain(String[] args) {
    }

    public void main(String[] args) {
        MessageOutput messageOutput = new MessageOutput(new PrintWriter(System.out), new PrintWriter(System.err));
        messageOutput.info(FormatterStarter.getAppInfo() + " Formatter\n");
        FileSetFormatter fileSetFormatter = new FileSetFormatter(messageOutput);
        FormatterStarter.logArgs(args);
        if (args.length < 2) {
            FormatterStarter.showUsageInfo(messageOutput);
        }
        for (int i = 1; i < args.length; ++i) {
            if (args[i].startsWith("-")) {
                if (FormatterStarter.checkOption(args[i], "-h", "-help")) {
                    FormatterStarter.showUsageInfo(messageOutput);
                }
                if (FormatterStarter.checkOption(args[i], "-s", "-settings")) {
                    if (++i >= args.length) {
                        FormatterStarter.fatalError(messageOutput, "Missing settings file path.");
                    }
                    try {
                        CodeStyleSettings settings = FormatterStarter.readSettings(args[i]);
                        fileSetFormatter.setCodeStyleSettings(settings);
                    }
                    catch (SchemeImportException e) {
                        FormatterStarter.fatalError(messageOutput, e.getLocalizedMessage() + "\n");
                    }
                    continue;
                }
                if (FormatterStarter.checkOption(args[i], "-r", "-R")) {
                    fileSetFormatter.setRecursive();
                    continue;
                }
                if (FormatterStarter.checkOption(args[i], "-m", "-mask")) {
                    if (++i >= args.length) {
                        FormatterStarter.fatalError(messageOutput, "Missing file mask(s).");
                    }
                    for (String mask : args[i].split(",")) {
                        if (mask.isEmpty()) continue;
                        fileSetFormatter.addFileMask(mask);
                    }
                    continue;
                }
                FormatterStarter.fatalError(messageOutput, "Unknown option " + args[i]);
                continue;
            }
            try {
                fileSetFormatter.addEntry(args[i]);
                continue;
            }
            catch (IOException e) {
                FormatterStarter.fatalError(messageOutput, e.getLocalizedMessage());
            }
        }
        try {
            fileSetFormatter.processFiles();
            messageOutput.info("\n" + fileSetFormatter.getProcessedFiles() + " file(s) formatted.\n");
        }
        catch (IOException e) {
            FormatterStarter.fatalError(messageOutput, e.getLocalizedMessage());
        }
        ((ApplicationEx)ApplicationManager.getApplication()).exit(true, true);
    }

    private static void fatalError(@NotNull MessageOutput messageOutput, @NotNull String message) {
        if (messageOutput == null) {
            FormatterStarter.$$$reportNull$$$0(0);
        }
        if (message == null) {
            FormatterStarter.$$$reportNull$$$0(1);
        }
        messageOutput.error("ERROR: " + message + "\n");
        System.exit(1);
    }

    private static CodeStyleSettings readSettings(@NotNull String settingsPath) throws SchemeImportException {
        if (settingsPath == null) {
            FormatterStarter.$$$reportNull$$$0(2);
        }
        VirtualFile vFile = VfsUtil.findFileByIoFile((File)new File(settingsPath), (boolean)true);
        CodeStyleSettingsLoader loader = new CodeStyleSettingsLoader();
        if (vFile == null) {
            throw new SchemeImportException("Cannot find file " + settingsPath);
        }
        return loader.loadSettings(vFile);
    }

    private static boolean checkOption(@NotNull String arg, String ... variants) {
        if (arg == null) {
            FormatterStarter.$$$reportNull$$$0(3);
        }
        for (String variant : variants) {
            if (!variant.equals(arg)) continue;
            return true;
        }
        return false;
    }

    private static String getAppInfo() {
        ApplicationInfoImpl appInfo = (ApplicationInfoImpl)ApplicationInfoEx.getInstanceEx();
        return String.format("%s, build %s", appInfo.getFullApplicationName(), appInfo.getBuild().asString());
    }

    private static void showUsageInfo(@NotNull MessageOutput messageOutput) {
        if (messageOutput == null) {
            FormatterStarter.$$$reportNull$$$0(4);
        }
        messageOutput.info("Usage: format [-h] [-r|-R] [-s|-settings settingsPath] path1 path2...\n");
        messageOutput.info("  -h|-help       Show a help message and exit.\n");
        messageOutput.info("  -s|-settings   A path to Intellij IDEA code style settings .xml file.\n");
        messageOutput.info("  -r|-R          Scan directories recursively.\n");
        messageOutput.info("  -m|-mask       A comma-separated list of file masks.\n");
        messageOutput.info("  path<n>        A path to a file or a directory.\n");
        System.exit(0);
    }

    private static void logArgs(@NotNull String[] args) {
        if (args == null) {
            FormatterStarter.$$$reportNull$$$0(5);
        }
        StringBuilder sb = new StringBuilder();
        for (String arg : args) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(arg);
        }
        LOG.info("Arguments: " + sb);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageOutput";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsPath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arg";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
        }
        objectArray2[1] = "com/intellij/formatting/commandLine/FormatterStarter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fatalError";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "readSettings";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkOption";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "showUsageInfo";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "logArgs";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

