/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore.kdbx;

import com.intellij.credentialStore.kdbx.KdbxKt;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import org.jetbrains.annotations.NotNull;

final class HashedBlockOutputStream
extends OutputStream {
    static final int BLOCK_SIZE = 8192;
    private static final int HASH_SIZE = 32;
    private static final byte[] ZERO_HASH = new byte[32];
    private int nextSequenceNumber = 0;
    private final OutputStream outputStream;
    private final ByteArrayOutputStream blockOutputStream = new ByteArrayOutputStream();
    private boolean isClosed = false;
    private final MessageDigest md = KdbxKt.sha256MessageDigest();

    HashedBlockOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    @Override
    public void write(int i) throws IOException {
        byte[] buf = new byte[]{(byte)i};
        this.put(buf, 0, 1);
    }

    @Override
    public void write(@NotNull byte[] b, int offset, int count) throws IOException {
        if (b == null) {
            HashedBlockOutputStream.$$$reportNull$$$0(0);
        }
        this.put(b, offset, count);
    }

    @Override
    public void flush() throws IOException {
        this.save();
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed) {
            throw new EOFException();
        }
        this.flush();
        this.writeInt(this.nextSequenceNumber);
        this.outputStream.write(ZERO_HASH);
        this.writeInt(0);
        this.isClosed = true;
        this.outputStream.close();
    }

    private void put(byte[] b, int offset, int length) throws IOException {
        if (this.isClosed) {
            throw new EOFException();
        }
        while (length > 0) {
            int bytesToWrite = Math.min(8192 - this.blockOutputStream.size(), length);
            this.blockOutputStream.write(b, offset, bytesToWrite);
            if (this.blockOutputStream.size() >= 8192) {
                this.save();
            }
            offset += bytesToWrite;
            length -= bytesToWrite;
        }
    }

    private void save() throws IOException {
        if (this.blockOutputStream.size() == 0) {
            return;
        }
        this.writeInt(this.nextSequenceNumber++);
        byte[] buffer = this.blockOutputStream.toByteArray();
        this.md.update(buffer);
        this.outputStream.write(this.md.digest());
        this.writeInt(buffer.length);
        this.outputStream.write(buffer);
        this.outputStream.flush();
        this.blockOutputStream.reset();
    }

    private void writeInt(int value) throws IOException {
        int output = Integer.reverseBytes(value);
        this.outputStream.write(new byte[]{(byte)(output >> 24), (byte)(output >> 16), (byte)(output >> 8), (byte)output});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/intellij/credentialStore/kdbx/HashedBlockOutputStream", "write"));
    }
}

