/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeView;
import com.intellij.ide.actions.CreateDirectoryOrPackageHandler;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.util.DirectoryChooserUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.Properties;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class CreatePackageAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.python.actions.CreatePackageAction");

    public void actionPerformed(@NotNull AnActionEvent e) {
        IdeView view;
        if (e == null) {
            CreatePackageAction.$$$reportNull$$$0(0);
        }
        if ((view = (IdeView)e.getData(LangDataKeys.IDE_VIEW)) == null) {
            return;
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        PsiDirectory directory2 = DirectoryChooserUtil.getOrChooseDirectory((IdeView)view);
        if (directory2 == null) {
            return;
        }
        SmartPointerManager pointerManager = SmartPointerManager.getInstance((Project)project);
        final SmartPsiElementPointer directoryPointer = pointerManager.createSmartPsiElementPointer((PsiElement)directory2);
        CreateDirectoryOrPackageHandler validator = new CreateDirectoryOrPackageHandler(project, directory2, false, "."){

            protected void createDirectories(String subDirName) {
                super.createDirectories(subDirName);
                PsiFileSystemItem element = this.getCreatedElement();
                PsiDirectory restoredDirectory = (PsiDirectory)directoryPointer.getElement();
                if (element instanceof PsiDirectory && restoredDirectory != null) {
                    CreatePackageAction.createInitPyInHierarchy((PsiDirectory)element, restoredDirectory);
                }
            }
        };
        Messages.showInputDialog((Project)project, (String)IdeBundle.message((String)"prompt.enter.new.package.name", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.new.package", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), (String)"", (InputValidator)validator);
        PsiFileSystemItem result = validator.getCreatedElement();
        if (result != null) {
            view.selectElement((PsiElement)result);
        }
    }

    public static void createInitPyInHierarchy(PsiDirectory created, PsiDirectory ancestor) {
        do {
            CreatePackageAction.createInitPy(created);
        } while ((created = created.getParent()) != null && !created.equals(ancestor));
    }

    private static void createInitPy(PsiDirectory directory2) {
        FileTemplateManager fileTemplateManager = FileTemplateManager.getInstance((Project)directory2.getProject());
        FileTemplate template = fileTemplateManager.getInternalTemplate("Python Script");
        if (directory2.findFile("__init__.py") != null) {
            return;
        }
        if (template != null) {
            try {
                FileTemplateUtil.createFromTemplate((FileTemplate)template, (String)"__init__.py", (Properties)fileTemplateManager.getDefaultProperties(), (PsiDirectory)directory2);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        } else {
            PsiFile file = PsiFileFactory.getInstance((Project)directory2.getProject()).createFileFromText("__init__.py", "");
            directory2.add((PsiElement)file);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            CreatePackageAction.$$$reportNull$$$0(1);
        }
        boolean enabled = CreatePackageAction.isEnabled(e);
        e.getPresentation().setVisible(enabled);
        e.getPresentation().setEnabled(enabled);
    }

    private static boolean isEnabled(@NotNull AnActionEvent e) {
        if (e == null) {
            CreatePackageAction.$$$reportNull$$$0(2);
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        IdeView ideView = (IdeView)e.getData(LangDataKeys.IDE_VIEW);
        if (project == null || ideView == null) {
            return false;
        }
        PsiDirectory[] directories = ideView.getDirectories();
        return directories.length != 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/jetbrains/python/actions/CreatePackageAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

