/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.action;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Optional;
import javax.swing.FocusManager;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.JTextComponent;
import org.protege.editor.owl.ui.action.ProtegeOWLAction;
import org.protege.editor.owl.ui.transfer.TransferableOWLObject;
import org.protege.editor.owl.ui.view.Copyable;
import org.protege.editor.owl.ui.view.ViewClipboard;
import org.semanticweb.owlapi.model.OWLObject;

public class CopyAction
extends ProtegeOWLAction {
    private final PropertyChangeListener propertyChangeListener = event -> {
        if ("focusOwner".equals(event.getPropertyName())) {
            this.updateState();
        }
    };
    private final ChangeListener changeListener = event -> this.getCopyable().ifPresent(c -> this.setEnabled(c.canCopy()));
    private Optional<Copyable> currentCopyable = Optional.empty();

    public void initialise() throws Exception {
        FocusManager.getCurrentManager().addPropertyChangeListener(this.propertyChangeListener);
        this.updateState();
    }

    public void dispose() throws Exception {
        FocusManager.getCurrentManager().removePropertyChangeListener(this.propertyChangeListener);
    }

    private void updateState() {
        this.currentCopyable.ifPresent(c -> c.removeChangeListener(this.changeListener));
        Component focusOwner = FocusManager.getCurrentManager().getFocusOwner();
        if (this.getCopyable().isPresent()) {
            this.currentCopyable = this.getCopyable();
            this.currentCopyable.ifPresent(c -> {
                c.addChangeListener(this.changeListener);
                this.setEnabled(c.canCopy());
            });
        } else if (focusOwner instanceof JTextComponent) {
            this.setEnabled(true);
        } else if (focusOwner instanceof JTable) {
            this.setEnabled(true);
        } else if (focusOwner instanceof JList) {
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }

    private Optional<Copyable> getCopyable() {
        Component focusOwner = FocusManager.getCurrentManager().getFocusOwner();
        if (focusOwner instanceof Copyable) {
            return Optional.of((Copyable)((Object)focusOwner));
        }
        return Optional.ofNullable((Copyable)((Object)SwingUtilities.getAncestorOfClass(Copyable.class, focusOwner)));
    }

    public void actionPerformed(ActionEvent e) {
        Component focusOwner = FocusManager.getCurrentManager().getFocusOwner();
        if (this.getCopyable().isPresent()) {
            this.getCopyable().ifPresent(this::handleCopy);
        } else if (focusOwner instanceof JTextComponent) {
            this.handleCopy((JTextComponent)focusOwner);
        } else if (focusOwner instanceof JTable) {
            this.handleCopy((JTable)focusOwner);
        } else if (focusOwner instanceof JList) {
            this.handleCopy((JList)focusOwner);
        }
    }

    private void handleCopy(JTextComponent textComponent) {
        textComponent.copy();
    }

    private void handleCopy(JTable table) {
        StringBuilder sb = new StringBuilder();
        for (int row : table.getSelectedRows()) {
            for (int col = 0; col < table.getColumnCount(); ++col) {
                Object value = table.getValueAt(row, col);
                TableCellRenderer cellRenderer = table.getCellRenderer(row, col);
                Component renderer = cellRenderer.getTableCellRendererComponent(table, value, false, false, row, col);
                String stringValue = renderer instanceof JLabel ? ((JLabel)renderer).getText() : value.toString();
                sb.append(stringValue);
                sb.append("\t");
            }
            sb.append("\n");
        }
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(sb.toString().trim()), null);
    }

    private void handleCopy(JList list) {
        StringBuilder sb = new StringBuilder();
        for (int i : list.getSelectedIndices()) {
            Object value = list.getModel().getElementAt(i);
            String stringValue = value instanceof OWLObject ? this.getOWLModelManager().getRendering((OWLObject)value) : value.toString();
            sb.append(stringValue);
            sb.append("\n");
        }
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(sb.toString().trim()), null);
    }

    private void handleCopy(Copyable copyable) {
        List<OWLObject> objects = copyable.getObjectsToCopy();
        if (objects.isEmpty()) {
            return;
        }
        ViewClipboard clipboard = ViewClipboard.getInstance();
        clipboard.getClipboard().setContents(new TransferableOWLObject(this.getOWLModelManager(), objects), null);
        new TransferableOWLObject(this.getOWLModelManager(), objects);
        StringBuilder buffer = new StringBuilder();
        for (OWLObject owlObject : objects) {
            buffer.append(this.getOWLModelManager().getRendering(owlObject));
            buffer.append("\n");
        }
        StringSelection stringSelection = new StringSelection(buffer.toString().trim());
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, null);
    }
}

