/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.io;

import java.util.function.Consumer;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.support.io.FileType;
import org.pdfsam.support.params.SinglePdfSourceTaskParametersBuilder;
import org.pdfsam.support.params.TaskParametersBuildStep;
import org.pdfsam.ui.io.BrowsableFileField;
import org.pdfsam.ui.io.RememberingLatestFileChooserWrapper;
import org.pdfsam.ui.support.FXValidationSupport;
import org.sejda.conversion.PdfFileSourceAdapter;

public class BrowsablePdfInputField
extends BrowsableFileField
implements TaskParametersBuildStep<SinglePdfSourceTaskParametersBuilder<?>> {
    public BrowsablePdfInputField() {
        super(FileType.PDF, RememberingLatestFileChooserWrapper.OpenType.OPEN);
    }

    public void apply(SinglePdfSourceTaskParametersBuilder<?> builder, Consumer<String> onError) {
        this.getTextField().validate();
        if (this.getTextField().getValidationState() == FXValidationSupport.ValidationState.VALID) {
            builder.source(new PdfFileSourceAdapter(this.getTextField().getText()).getPdfFileSource());
        } else {
            onError.accept(DefaultI18nContext.getInstance().i18n("The selected PDF file is invalid"));
        }
    }
}

