/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.model.pdf.headerfooter;

import org.sejda.common.FriendlyNamed;
import org.sejda.common.RomanNumbersUtils;

public enum NumberingStyle implements FriendlyNamed
{
    ARABIC("arabic"){

        @Override
        public String toStyledString(int number) {
            return Integer.toString(number);
        }
    }
    ,
    EMPTY("empty"){

        @Override
        public String toStyledString(int number) {
            return "";
        }
    }
    ,
    ROMAN("roman"){

        @Override
        public String toStyledString(int number) {
            return RomanNumbersUtils.toRoman(number);
        }
    };

    private String displayName;

    private NumberingStyle(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public String getFriendlyName() {
        return this.displayName;
    }

    public abstract String toStyledString(int var1);
}

