# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.data_object_algorithm import DataObjectAlgorithm


class DistributedDataFilter(DataObjectAlgorithm):
    """
    DistributedDataFilter - Distribute data among processors
    
    Superclass: DataObjectAlgorithm
    
    This filter redistributes data among processors in a parallel
    application into spatially contiguous UnstructuredGrids. The
    execution model anticipated is that all processes read in part of a
    large DataSet. Each process sets the input of filter to be that
    data_set. When executed, this filter builds in parallel a k-d tree,
    decomposing the space occupied by the distributed data_set into
    spatial regions.  It assigns each spatial region to a processor.  The
    data is then redistributed and the output is a single
    UnstructuredGrid containing the cells in the process' assigned
    regions.
    
    This filter is sometimes called "D3" for "distributed data
    decomposition".
    
    Enhancement: You can set the k-d tree decomposition, rather than have
    D3 compute it.  This allows you to divide a dataset using the
    decomposition computed for another dataset.  Obtain a description of
    the k-d tree cuts this way:
    
    
       BSPCuts *cuts = d3_object1->_get_cuts()
    
    And set it this way:
    
    
       d3_object2->_set_cuts(cuts)
    
    
       It is desirable to have a field array of global node IDs
       for two reasons:
    
    1. When merging together sub grids that were distributed across
       processors, global node IDs can be used to remove duplicate points
    and significantly reduce the size of the resulting output grid.  If
       no such array is available, D3 will use a tolerance to merge
       points, which is much slower.
    
    2. If ghost cells have been requested, D3 requires a global node ID
       array in order to request and transfer ghost cells in parallel
       among the processors.  If there is no global node ID array, D3
       will in parallel create a global node ID array, and the time to do
    this can be significant.
    
    
       If you know the name of a global node ID array in the input
       dataset, set that name with this method.  If you leave
       it unset, D3 will search the input data set for certain
       common names of global node ID arrays.  If none is found,
       and ghost cells have been requested, D3 will create a
       temporary global node ID array before acquiring ghost cells.
      It is also desirable to have global element IDs.  However,
      if they don't exist D3 can create them relatively quickly.
      Set the name of the global element ID array if you have it.
      If it is not set, D3 will search for it using common names.
      If still not found, D3 will create a temporary array of
      global element IDs.
    
    @warning
    The Execute() method must be called by all processes in the parallel
    application, or it will hang.  If you are not certain that your
    pipeline will execute identically on all processors, you may want to
    use this filter in an explicit execution mode.
    
    @sa
    KdTree PKdTree BSPCuts
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkDistributedDataFilter, obj, update, **traits)
    
    clip_cells = tvtk_base.false_bool_trait(desc=\
        """
        
        """
    )

    def _clip_cells_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetClipCells,
                        self.clip_cells_)

    include_all_intersecting_cells = tvtk_base.false_bool_trait(desc=\
        """
        
        """
    )

    def _include_all_intersecting_cells_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetIncludeAllIntersectingCells,
                        self.include_all_intersecting_cells_)

    retain_kdtree = tvtk_base.true_bool_trait(desc=\
        """
        
        """
    )

    def _retain_kdtree_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetRetainKdtree,
                        self.retain_kdtree_)

    timing = tvtk_base.false_bool_trait(desc=\
        """
        
        """
    )

    def _timing_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTiming,
                        self.timing_)

    use_minimal_memory = tvtk_base.false_bool_trait(desc=\
        """
        
        """
    )

    def _use_minimal_memory_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetUseMinimalMemory,
                        self.use_minimal_memory_)

    boundary_mode = traits.Trait('assign_to_one_region',
    tvtk_base.TraitRevPrefixMap({'assign_to_one_region': 0, 'assign_to_all_intersecting_regions': 1, 'split_boundary_cells': 2}), desc=\
        """
        Handling of clip_cells and include_all_intersecting_cells.
        """
    )

    def _boundary_mode_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetBoundaryMode,
                        self.boundary_mode_)

    def _get_controller(self):
        return wrap_vtk(self._vtk_obj.GetController())
    def _set_controller(self, arg):
        old_val = self._get_controller()
        self._wrap_call(self._vtk_obj.SetController,
                        deref_vtk(arg))
        self.trait_property_changed('controller', old_val, arg)
    controller = traits.Property(_get_controller, _set_controller, desc=\
        """
        Set/Get the communicator object
        """
    )

    def _get_cuts(self):
        return wrap_vtk(self._vtk_obj.GetCuts())
    def _set_cuts(self, arg):
        old_val = self._get_cuts()
        self._wrap_call(self._vtk_obj.SetCuts,
                        deref_vtk(arg))
        self.trait_property_changed('cuts', old_val, arg)
    cuts = traits.Property(_get_cuts, _set_cuts, desc=\
        """
        You can set the k-d tree decomposition, rather than have D3
        compute it.  This allows you to divide a dataset using the
        decomposition computed for another dataset.  Obtain a description
        of the k-d tree cuts this way:
        
        * BSPCuts *cuts = d3_object1->_get_cuts()
        
        * And set it this way:
        
        * d3_object2->_set_cuts(cuts)
        """
    )

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        V.get_input() -> DataObject
        C++: DataObject *GetInput()
        V.get_input(int) -> DataObject
        C++: DataObject *GetInput(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def _get_kdtree(self):
        return wrap_vtk(self._vtk_obj.GetKdtree())
    kdtree = traits.Property(_get_kdtree, desc=\
        """
        Get a pointer to the parallel k-d tree object.  Required for
        changing default behavior for region assignment, changing default
        depth of tree, or other tree building default parameters.  See
        PKdTree and KdTree for more information about these
        options. NOTE: Changing the tree returned by this method does NOT
        change the d3 filter. Make sure to call Modified() on the d3
        object if you want it to re-execute.
        """
    )

    def set_user_region_assignments(self, *args):
        """
        V.set_user_region_assignments((int, ...), int)
        C++: void SetUserRegionAssignments(const int *map, int numRegions)
        BSPCuts doesn't have information about process assignments for
        the cuts. Typically D3 filter simply reassigns the processes for
        each cut. However, that may not always work, sometimes the
        processes have be pre-assigned and we want to preserve that
        partitioning. In that case, one sets the region assignments
        explicitly. Look at PKdTree::AssignRegions for details about
        the arguments. Calling set_user_region_assignments(nullptr, 0) will
        revert to default behavior i.e. letting the kd_tree come up with
        the assignments.
        """
        ret = self._wrap_call(self._vtk_obj.SetUserRegionAssignments, *args)
        return ret

    _updateable_traits_ = \
    (('clip_cells', 'GetClipCells'), ('include_all_intersecting_cells',
    'GetIncludeAllIntersectingCells'), ('retain_kdtree',
    'GetRetainKdtree'), ('timing', 'GetTiming'), ('use_minimal_memory',
    'GetUseMinimalMemory'), ('abort_execute', 'GetAbortExecute'),
    ('release_data_flag', 'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('boundary_mode', 'GetBoundaryMode'), ('progress', 'GetProgress'),
    ('progress_text', 'GetProgressText'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'clip_cells', 'debug', 'global_warning_display',
    'include_all_intersecting_cells', 'release_data_flag',
    'retain_kdtree', 'timing', 'use_minimal_memory', 'boundary_mode',
    'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(DistributedDataFilter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit DistributedDataFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['clip_cells', 'include_all_intersecting_cells',
            'retain_kdtree', 'timing', 'use_minimal_memory'], ['boundary_mode'],
            []),
            title='Edit DistributedDataFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit DistributedDataFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

