/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventhubs.impl;

import com.microsoft.azure.eventhubs.TransportType;
import com.microsoft.azure.eventhubs.impl.AmqpConnection;
import com.microsoft.azure.eventhubs.impl.AmqpConstants;
import com.microsoft.azure.eventhubs.impl.ClientConstants;
import com.microsoft.azure.eventhubs.impl.EventHubClientImpl;
import com.microsoft.azure.eventhubs.impl.StringUtil;
import com.microsoft.azure.eventhubs.impl.WebSocketConnectionHandler;
import com.microsoft.azure.eventhubs.impl.WebSocketProxyConnectionHandler;
import java.util.HashMap;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.BaseHandler;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Handler;
import org.apache.qpid.proton.engine.SslDomain;
import org.apache.qpid.proton.engine.Transport;
import org.apache.qpid.proton.engine.impl.TransportInternal;
import org.apache.qpid.proton.reactor.Handshaker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionHandler
extends BaseHandler {
    private static final Logger TRACE_LOGGER = LoggerFactory.getLogger(ConnectionHandler.class);
    private final AmqpConnection amqpConnection;

    protected ConnectionHandler(AmqpConnection amqpConnection) {
        this.add((Handler)new Handshaker());
        this.amqpConnection = amqpConnection;
    }

    static ConnectionHandler create(TransportType transportType, AmqpConnection amqpConnection) {
        switch (transportType) {
            case AMQP_WEB_SOCKETS: {
                if (WebSocketProxyConnectionHandler.shouldUseProxy(amqpConnection.getHostName()).booleanValue()) {
                    return new WebSocketProxyConnectionHandler(amqpConnection);
                }
                return new WebSocketConnectionHandler(amqpConnection);
            }
        }
        return new ConnectionHandler(amqpConnection);
    }

    protected AmqpConnection getAmqpConnection() {
        return this.amqpConnection;
    }

    private static SslDomain makeDomain(SslDomain.Mode mode) {
        SslDomain domain = Proton.sslDomain();
        domain.init(mode);
        domain.setPeerAuthentication(SslDomain.VerifyMode.ANONYMOUS_PEER);
        return domain;
    }

    public void onConnectionInit(Event event) {
        Connection connection = event.getConnection();
        String hostName = this.amqpConnection.getHostName() + ":" + String.valueOf(this.getProtocolPort());
        connection.setHostname(hostName);
        connection.setContainer(StringUtil.getRandomString());
        HashMap<Symbol, String> connectionProperties = new HashMap<Symbol, String>();
        connectionProperties.put(AmqpConstants.PRODUCT, "MSJavaClient");
        connectionProperties.put(AmqpConstants.VERSION, "1.3.0");
        connectionProperties.put(AmqpConstants.PLATFORM, ClientConstants.PLATFORM_INFO);
        connectionProperties.put(AmqpConstants.FRAMEWORK, ClientConstants.FRAMEWORK_INFO);
        String userAgent = EventHubClientImpl.USER_AGENT;
        if (userAgent != null) {
            connectionProperties.put(AmqpConstants.USER_AGENT, userAgent.length() < 128 ? userAgent : userAgent.substring(0, 128));
        }
        connection.setProperties(connectionProperties);
        connection.open();
    }

    protected void addTransportLayers(Event event, TransportInternal transport) {
        SslDomain domain = ConnectionHandler.makeDomain(SslDomain.Mode.CLIENT);
        transport.ssl(domain);
    }

    protected void notifyTransportErrors(Event event) {
    }

    public String getRemoteHostName() {
        return this.amqpConnection.getHostName();
    }

    protected int getRemotePort() {
        return this.getProtocolPort();
    }

    protected int getProtocolPort() {
        return 5671;
    }

    protected int getMaxFrameSize() {
        return 65536;
    }

    public void onConnectionBound(Event event) {
        Transport transport = event.getTransport();
        this.addTransportLayers(event, (TransportInternal)transport);
    }

    public void onConnectionUnbound(Event event) {
        Connection connection = event.getConnection();
        if (TRACE_LOGGER.isInfoEnabled()) {
            TRACE_LOGGER.info("onConnectionUnbound: hostname[" + connection.getHostname() + "], state[" + connection.getLocalState() + "], remoteState[" + connection.getRemoteState() + "]");
        }
        if (connection.getRemoteState() != EndpointState.UNINITIALIZED) {
            connection.free();
        }
    }

    public void onTransportError(Event event) {
        Connection connection = event.getConnection();
        Transport transport = event.getTransport();
        ErrorCondition condition = transport.getCondition();
        if (TRACE_LOGGER.isWarnEnabled()) {
            TRACE_LOGGER.warn("onTransportClosed: hostname[" + (connection != null ? connection.getHostname() : "n/a") + "], error[" + (condition != null ? condition.getDescription() : "n/a") + "]");
        }
        if (connection != null && connection.getRemoteState() != EndpointState.CLOSED) {
            this.amqpConnection.onConnectionError(condition);
        }
        transport.unbind();
        this.notifyTransportErrors(event);
    }

    public void onTransportClosed(Event event) {
        Connection connection = event.getConnection();
        Transport transport = event.getTransport();
        ErrorCondition condition = transport.getCondition();
        if (TRACE_LOGGER.isInfoEnabled()) {
            TRACE_LOGGER.info("onTransportClosed: hostname[" + (connection != null ? connection.getHostname() : "n/a") + "], error[" + (condition != null ? condition.getDescription() : "n/a") + "]");
        }
        if (connection != null && connection.getRemoteState() != EndpointState.CLOSED) {
            this.amqpConnection.onConnectionError(condition);
        }
    }

    public void onConnectionRemoteOpen(Event event) {
        if (TRACE_LOGGER.isInfoEnabled()) {
            TRACE_LOGGER.info("onConnectionRemoteOpen: hostname[" + event.getConnection().getHostname() + ", " + event.getConnection().getRemoteContainer() + "]");
        }
        this.amqpConnection.onOpenComplete(null);
    }

    public void onConnectionLocalClose(Event event) {
        Transport transport;
        Connection connection = event.getConnection();
        ErrorCondition error = connection.getCondition();
        if (TRACE_LOGGER.isInfoEnabled()) {
            TRACE_LOGGER.info("onConnectionLocalClose: hostname[" + connection.getHostname() + (error != null ? "], errorCondition[" + error.getCondition() + ", " + error.getDescription() + "]" : "]"));
        }
        if (connection.getRemoteState() == EndpointState.CLOSED && (transport = connection.getTransport()) != null) {
            transport.unbind();
        }
    }

    public void onConnectionRemoteClose(Event event) {
        Connection connection = event.getConnection();
        ErrorCondition error = connection.getRemoteCondition();
        if (TRACE_LOGGER.isInfoEnabled()) {
            TRACE_LOGGER.info("onConnectionRemoteClose: hostname[" + connection.getHostname() + (error != null ? "], errorCondition[" + error.getCondition() + ", " + error.getDescription() + "]" : "]"));
        }
        this.amqpConnection.onConnectionError(error);
    }
}

