/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.bspt;

import javajs.util.T3;
import org.jmol.bspt.Bspt;
import org.jmol.bspt.Element;
import org.jmol.bspt.Leaf;

class Node
extends Element {
    int dim;
    float minLeft;
    float maxLeft;
    Element eleLeft;
    float minRight;
    float maxRight;
    Element eleRight;

    Node(Bspt bspt, int n, Leaf leaf) {
        this.bspt = bspt;
        if (n == bspt.treeDepth) {
            bspt.treeDepth = n + 1;
        }
        if (leaf.count != 2) {
            throw new NullPointerException();
        }
        this.dim = n % bspt.dimMax;
        leaf.sort(this.dim);
        Leaf leaf2 = new Leaf(bspt, leaf, 1);
        this.minLeft = Node.getDimensionValue(leaf.tuples[0], this.dim);
        this.maxLeft = Node.getDimensionValue(leaf.tuples[leaf.count - 1], this.dim);
        this.minRight = Node.getDimensionValue(leaf2.tuples[0], this.dim);
        this.maxRight = Node.getDimensionValue(leaf2.tuples[leaf2.count - 1], this.dim);
        this.eleLeft = leaf;
        this.eleRight = leaf2;
        this.count = 2;
    }

    @Override
    Element addTuple(int n, T3 t3) {
        float f = Node.getDimensionValue(t3, this.dim);
        ++this.count;
        boolean bl = f < this.maxLeft ? true : (f > this.minRight ? false : (f == this.maxLeft ? (f == this.minRight ? this.eleLeft.count < this.eleRight.count : true) : (f == this.minRight ? false : this.eleLeft.count < this.eleRight.count)));
        if (bl) {
            if (f < this.minLeft) {
                this.minLeft = f;
            } else if (f > this.maxLeft) {
                this.maxLeft = f;
            }
            this.eleLeft = this.eleLeft.addTuple(n + 1, t3);
        } else {
            if (f < this.minRight) {
                this.minRight = f;
            } else if (f > this.maxRight) {
                this.maxRight = f;
            }
            this.eleRight = this.eleRight.addTuple(n + 1, t3);
        }
        return this;
    }

    static float getDimensionValue(T3 t3, int n) {
        if (t3 == null) {
            System.out.println("bspt.Node ???");
        }
        switch (n) {
            case 0: {
                return t3.x;
            }
            case 1: {
                return t3.y;
            }
        }
        return t3.z;
    }
}

