/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.utils;

import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.InsnNode;
import java.util.Iterator;
import java.util.List;

public final class InsnList
implements Iterable<InsnNode> {
    private final List<InsnNode> list;

    public InsnList(List<InsnNode> list) {
        this.list = list;
    }

    public static void remove(List<InsnNode> list, InsnNode insn) {
        Iterator<InsnNode> iterator = list.iterator();
        while (iterator.hasNext()) {
            InsnNode next = iterator.next();
            if (next != insn) continue;
            iterator.remove();
            return;
        }
    }

    public static void remove(BlockNode block, InsnNode insn) {
        InsnList.remove(block.getInstructions(), insn);
    }

    public static int getIndex(List<InsnNode> list, InsnNode insn) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            if (list.get(i) != insn) continue;
            return i;
        }
        return -1;
    }

    public int getIndex(InsnNode insn) {
        return InsnList.getIndex(this.list, insn);
    }

    public boolean contains(InsnNode insn) {
        return this.getIndex(insn) != -1;
    }

    public void remove(InsnNode insn) {
        InsnList.remove(this.list, insn);
    }

    @Override
    public Iterator<InsnNode> iterator() {
        return this.list.iterator();
    }

    public InsnNode get(int index) {
        return this.list.get(index);
    }

    public int size() {
        return this.list.size();
    }
}

