/*
 * Decompiled with CFR 0.152.
 */
package org.testng.reporters;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.testng.IResultMap;
import org.testng.ISuiteResult;
import org.testng.ITestContext;
import org.testng.ITestResult;
import org.testng.Reporter;
import org.testng.annotations.Test;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.collections.Sets;
import org.testng.internal.ConstructorOrMethod;
import org.testng.internal.Utils;
import org.testng.reporters.XMLReporter;
import org.testng.reporters.XMLReporterConfig;
import org.testng.reporters.XMLStringBuffer;
import org.testng.util.Strings;

public class XMLSuiteResultWriter {
    private XMLReporterConfig config;

    public XMLSuiteResultWriter(XMLReporterConfig xMLReporterConfig) {
        this.config = xMLReporterConfig;
    }

    public void writeSuiteResult(XMLStringBuffer xMLStringBuffer, ISuiteResult iSuiteResult) {
        if (3 != this.config.getFileFragmentationLevel()) {
            this.writeAllToBuffer(xMLStringBuffer, iSuiteResult);
        } else {
            String string = this.config.getOutputDirectory() + File.separatorChar + iSuiteResult.getTestContext().getSuite().getName();
            File file = this.referenceSuiteResult(xMLStringBuffer, string, iSuiteResult);
            XMLStringBuffer xMLStringBuffer2 = new XMLStringBuffer();
            this.writeAllToBuffer(xMLStringBuffer2, iSuiteResult);
            Utils.writeUtf8File(file.getAbsoluteFile().getParent(), file.getName(), xMLStringBuffer2.toXML());
        }
    }

    private void writeAllToBuffer(XMLStringBuffer xMLStringBuffer, ISuiteResult iSuiteResult) {
        xMLStringBuffer.push("test", this.getSuiteResultAttributes(iSuiteResult));
        Set<ITestResult> set = Sets.newHashSet();
        ITestContext iTestContext = iSuiteResult.getTestContext();
        this.addAllTestResults(set, iTestContext.getPassedTests());
        this.addAllTestResults(set, iTestContext.getFailedTests());
        this.addAllTestResults(set, iTestContext.getSkippedTests());
        this.addAllTestResults(set, iTestContext.getPassedConfigurations());
        this.addAllTestResults(set, iTestContext.getSkippedConfigurations());
        this.addAllTestResults(set, iTestContext.getFailedConfigurations());
        this.addAllTestResults(set, iTestContext.getFailedButWithinSuccessPercentageTests());
        this.addTestResults(xMLStringBuffer, set);
        xMLStringBuffer.pop();
    }

    private void addAllTestResults(Set<ITestResult> set, IResultMap iResultMap) {
        if (iResultMap != null) {
            ArrayList<ITestResult> arrayList = new ArrayList<ITestResult>();
            arrayList.addAll(iResultMap.getAllResults());
            Collections.sort(new ArrayList(arrayList), new Comparator<ITestResult>(){

                @Override
                public int compare(ITestResult iTestResult, ITestResult iTestResult2) {
                    return (int)(iTestResult.getStartMillis() - iTestResult2.getStartMillis());
                }
            });
            set.addAll(arrayList);
        }
    }

    private File referenceSuiteResult(XMLStringBuffer xMLStringBuffer, String string, ISuiteResult iSuiteResult) {
        Properties properties = new Properties();
        String string2 = iSuiteResult.getTestContext().getName() + ".xml";
        properties.setProperty("url", string2);
        xMLStringBuffer.addEmptyElement("test", properties);
        return new File(string + File.separatorChar + string2);
    }

    private Properties getSuiteResultAttributes(ISuiteResult iSuiteResult) {
        Properties properties = new Properties();
        ITestContext iTestContext = iSuiteResult.getTestContext();
        properties.setProperty("name", iTestContext.getName());
        XMLReporter.addDurationAttributes(this.config, properties, iTestContext.getStartDate(), iTestContext.getEndDate());
        return properties;
    }

    private void addTestResults(XMLStringBuffer xMLStringBuffer, Set<ITestResult> set) {
        Map<String, List<ITestResult>> map = this.buildTestClassGroups(set);
        for (Map.Entry<String, List<ITestResult>> entry : map.entrySet()) {
            Properties properties = new Properties();
            String string = entry.getKey();
            if (this.config.isSplitClassAndPackageNames()) {
                int n = string.lastIndexOf(46);
                properties.setProperty("name", n > -1 ? string.substring(n + 1, string.length()) : string);
                properties.setProperty("package", n > -1 ? string.substring(0, n) : "[default]");
            } else {
                properties.setProperty("name", string);
            }
            xMLStringBuffer.push("class", properties);
            List<ITestResult> list = entry.getValue();
            Collections.sort(list);
            for (ITestResult iTestResult : list) {
                this.addTestResult(xMLStringBuffer, iTestResult);
            }
            xMLStringBuffer.pop();
        }
    }

    private Map<String, List<ITestResult>> buildTestClassGroups(Set<ITestResult> set) {
        Map<String, List<ITestResult>> map = Maps.newHashMap();
        for (ITestResult iTestResult : set) {
            String string = iTestResult.getTestClass().getName();
            List<ITestResult> list = map.get(string);
            if (list == null) {
                list = Lists.newArrayList();
                map.put(string, list);
            }
            list.add(iTestResult);
        }
        return map;
    }

    private void addTestResult(XMLStringBuffer xMLStringBuffer, ITestResult iTestResult) {
        Properties properties = this.getTestResultAttributes(iTestResult);
        properties.setProperty("status", this.getStatusString(iTestResult.getStatus()));
        xMLStringBuffer.push("test-method", properties);
        this.addTestMethodParams(xMLStringBuffer, iTestResult);
        this.addTestResultException(xMLStringBuffer, iTestResult);
        this.addTestResultOutput(xMLStringBuffer, iTestResult);
        if (this.config.isGenerateTestResultAttributes()) {
            this.addTestResultAttributes(xMLStringBuffer, iTestResult);
        }
        xMLStringBuffer.pop();
    }

    private String getStatusString(int n) {
        switch (n) {
            case 1: {
                return "PASS";
            }
            case 2: {
                return "FAIL";
            }
            case 3: {
                return "SKIP";
            }
            case 4: {
                return "SUCCESS_PERCENTAGE_FAILURE";
            }
        }
        throw new AssertionError((Object)("Unexpected value: " + n));
    }

    private Properties getTestResultAttributes(ITestResult iTestResult) {
        String string;
        Test test;
        Object object;
        String string2;
        Properties properties = new Properties();
        if (!iTestResult.getMethod().isTest()) {
            properties.setProperty("is-config", "true");
        }
        properties.setProperty("name", iTestResult.getMethod().getMethodName());
        String string3 = iTestResult.getTestName();
        if (null != string3) {
            properties.setProperty("test-instance-name", string3);
        }
        if (!Utils.isStringEmpty(string2 = iTestResult.getMethod().getDescription())) {
            properties.setProperty("description", string2);
        }
        properties.setProperty("signature", this.removeClassName(iTestResult.getMethod().toString()));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.config.getTimestampFormat());
        String string4 = simpleDateFormat.format(iTestResult.getStartMillis());
        String string5 = simpleDateFormat.format(iTestResult.getEndMillis());
        properties.setProperty("started-at", string4);
        properties.setProperty("finished-at", string5);
        long l = iTestResult.getEndMillis() - iTestResult.getStartMillis();
        String string6 = Long.toString(l);
        properties.setProperty("duration-ms", string6);
        if (this.config.isGenerateGroupsAttribute() && !Utils.isStringEmpty((String)(object = Utils.arrayToString(iTestResult.getMethod().getGroups())))) {
            properties.setProperty("groups", (String)object);
        }
        if (this.config.isGenerateDependsOnMethods() && !Utils.isStringEmpty((String)(object = Utils.arrayToString(iTestResult.getMethod().getMethodsDependedUpon())))) {
            properties.setProperty("depends-on-methods", (String)object);
        }
        if (this.config.isGenerateDependsOnGroups() && !Utils.isStringEmpty((String)(object = Utils.arrayToString(iTestResult.getMethod().getGroupsDependedUpon())))) {
            properties.setProperty("depends-on-groups", (String)object);
        }
        if (((ConstructorOrMethod)(object = iTestResult.getMethod().getConstructorOrMethod())).getMethod() != null && (test = ((ConstructorOrMethod)object).getMethod().getAnnotation(Test.class)) != null && !Strings.isNullOrEmpty(string = test.dataProvider())) {
            properties.setProperty("data-provider", string);
        }
        return properties;
    }

    private String removeClassName(String string) {
        int n = string.indexOf("(");
        int n2 = string.substring(0, n).lastIndexOf(".");
        return string.substring(n2 + 1, string.length());
    }

    public void addTestMethodParams(XMLStringBuffer xMLStringBuffer, ITestResult iTestResult) {
        Object[] objectArray = iTestResult.getParameters();
        if (objectArray != null && objectArray.length > 0) {
            xMLStringBuffer.push("params");
            for (int i = 0; i < objectArray.length; ++i) {
                this.addParameter(xMLStringBuffer, objectArray[i], i);
            }
            xMLStringBuffer.pop();
        }
    }

    private void addParameter(XMLStringBuffer xMLStringBuffer, Object object, int n) {
        Properties properties = new Properties();
        properties.setProperty("index", String.valueOf(n));
        xMLStringBuffer.push("param", properties);
        if (object == null) {
            Properties properties2 = new Properties();
            properties2.setProperty("is-null", "true");
            xMLStringBuffer.addEmptyElement("value", properties2);
        } else {
            xMLStringBuffer.push("value");
            xMLStringBuffer.addCDATA(object.toString());
            xMLStringBuffer.pop();
        }
        xMLStringBuffer.pop();
    }

    private void addTestResultException(XMLStringBuffer xMLStringBuffer, ITestResult iTestResult) {
        Throwable throwable = iTestResult.getThrowable();
        if (throwable != null) {
            Properties properties = new Properties();
            properties.setProperty("class", throwable.getClass().getName());
            xMLStringBuffer.push("exception", properties);
            if (!Utils.isStringEmpty(throwable.getMessage())) {
                xMLStringBuffer.push("message");
                xMLStringBuffer.addCDATA(throwable.getMessage());
                xMLStringBuffer.pop();
            }
            XMLReporterConfig.StackTraceLevels stackTraceLevels = this.calculateStackTraceLevels(iTestResult);
            switch (stackTraceLevels) {
                case SHORT: {
                    xMLStringBuffer.push("short-stacktrace");
                    xMLStringBuffer.addCDATA(Utils.shortStackTrace(throwable, false));
                    xMLStringBuffer.pop();
                    break;
                }
                case FULL: {
                    xMLStringBuffer.push("full-stacktrace");
                    xMLStringBuffer.addCDATA(Utils.longStackTrace(throwable, false));
                    xMLStringBuffer.pop();
                    break;
                }
            }
            xMLStringBuffer.pop();
        }
    }

    private XMLReporterConfig.StackTraceLevels calculateStackTraceLevels(ITestResult iTestResult) {
        XMLReporterConfig.StackTraceLevels stackTraceLevels = this.config.getStackTraceOutput();
        if (iTestResult.isSuccess()) {
            stackTraceLevels = this.config.getStackTraceOutputLevelForPassedTests();
        }
        return stackTraceLevels;
    }

    private void addTestResultOutput(XMLStringBuffer xMLStringBuffer, ITestResult iTestResult) {
        xMLStringBuffer.push("reporter-output");
        List<String> list = Reporter.getOutput(iTestResult);
        for (String string : list) {
            if (string == null) continue;
            xMLStringBuffer.push("line");
            xMLStringBuffer.addCDATA(string);
            xMLStringBuffer.pop();
        }
        xMLStringBuffer.pop();
    }

    private void addTestResultAttributes(XMLStringBuffer xMLStringBuffer, ITestResult iTestResult) {
        if (iTestResult.getAttributeNames() != null && iTestResult.getAttributeNames().size() > 0) {
            xMLStringBuffer.push("attributes");
            for (String string : iTestResult.getAttributeNames()) {
                if (string == null) continue;
                Object object = iTestResult.getAttribute(string);
                Properties properties = new Properties();
                properties.setProperty("name", string);
                if (object == null) {
                    properties.setProperty("is-null", "true");
                    xMLStringBuffer.addEmptyElement("attribute", properties);
                    continue;
                }
                xMLStringBuffer.push("attribute", properties);
                xMLStringBuffer.addCDATA(object.toString());
                xMLStringBuffer.pop();
            }
            xMLStringBuffer.pop();
        }
    }
}

