/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resolve;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.internal.resolve.RejectedByAttributesVersion;
import org.gradle.internal.resolve.RejectedVersion;

public class ModuleVersionNotFoundException
extends ModuleVersionResolveException {
    public ModuleVersionNotFoundException(ComponentSelector selector, String message) {
        super(selector, message);
    }

    public ModuleVersionNotFoundException(ModuleComponentSelector selector, Collection<String> attemptedLocations, Collection<String> unmatchedVersions, Collection<RejectedVersion> rejectedVersions) {
        super((ComponentSelector)selector, ModuleVersionNotFoundException.format(selector, attemptedLocations, unmatchedVersions, rejectedVersions));
    }

    public ModuleVersionNotFoundException(ModuleVersionIdentifier id, Collection<String> attemptedLocations) {
        super(id, ModuleVersionNotFoundException.format(id, attemptedLocations));
    }

    public ModuleVersionNotFoundException(ModuleComponentSelector selector, Collection<String> attemptedLocations) {
        super((ComponentSelector)selector, ModuleVersionNotFoundException.format(selector, attemptedLocations));
    }

    private static String format(ModuleComponentSelector selector, Collection<String> locations, Collection<String> unmatchedVersions, Collection<RejectedVersion> rejectedVersions) {
        TreeFormatter builder = new TreeFormatter();
        if (unmatchedVersions.isEmpty() && rejectedVersions.isEmpty()) {
            builder.node(String.format("Could not find any matches for %s as no versions of %s:%s are available.", selector, selector.getGroup(), selector.getModule()));
        } else {
            builder.node(String.format("Could not find any version that matches %s.", selector));
            if (!unmatchedVersions.isEmpty()) {
                builder.node("Versions that do not match");
                ModuleVersionNotFoundException.appendSizeLimited(builder, unmatchedVersions);
            }
            if (!rejectedVersions.isEmpty()) {
                ArrayList byRule = Lists.newArrayListWithExpectedSize((int)rejectedVersions.size());
                ArrayList byAttributes = Lists.newArrayListWithExpectedSize((int)rejectedVersions.size());
                ModuleVersionNotFoundException.mapRejections(rejectedVersions, byRule, byAttributes);
                if (!byRule.isEmpty()) {
                    builder.node("Versions rejected by component selection rules");
                    ModuleVersionNotFoundException.appendSizeLimited(builder, byRule);
                }
                if (!byAttributes.isEmpty()) {
                    builder.node("Versions rejected by attribute matching");
                    ModuleVersionNotFoundException.appendSizeLimited(builder, byAttributes);
                }
            }
        }
        ModuleVersionNotFoundException.addLocations(builder, locations);
        return builder.toString();
    }

    private static void mapRejections(Collection<RejectedVersion> in, Collection<RejectedVersion> outByRule, Collection<RejectedVersion> outByAttributes) {
        for (RejectedVersion version : in) {
            if (version instanceof RejectedByAttributesVersion) {
                outByAttributes.add(version);
                continue;
            }
            outByRule.add(version);
        }
    }

    private static String format(ModuleVersionIdentifier id, Collection<String> locations) {
        TreeFormatter builder = new TreeFormatter();
        builder.node(String.format("Could not find %s.", id));
        ModuleVersionNotFoundException.addLocations(builder, locations);
        return builder.toString();
    }

    private static String format(ModuleComponentSelector selector, Collection<String> locations) {
        TreeFormatter builder = new TreeFormatter();
        builder.node(String.format("Could not find any version that matches %s.", selector));
        ModuleVersionNotFoundException.addLocations(builder, locations);
        return builder.toString();
    }

    private static void appendSizeLimited(TreeFormatter builder, Collection<?> values) {
        builder.startChildren();
        Iterator<?> iterator = values.iterator();
        int count = Math.min(5, values.size());
        for (int i = 0; i < count; ++i) {
            Object next = iterator.next();
            if (next instanceof RejectedVersion) {
                ((RejectedVersion)next).describeTo(builder);
                continue;
            }
            builder.node(next.toString());
        }
        if (count < values.size()) {
            builder.node(String.format("+ %d more", values.size() - count));
        }
        builder.endChildren();
    }

    private static void addLocations(TreeFormatter builder, Collection<String> locations) {
        if (locations.isEmpty()) {
            return;
        }
        builder.node("Searched in the following locations");
        builder.startChildren();
        for (String location : locations) {
            builder.node(location);
        }
        builder.endChildren();
    }
}

