/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.databinding.UpdateStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.internal.databinding.Pair;
import org.eclipse.core.internal.databinding.conversion.NumberToBigDecimalConverter;
import org.eclipse.core.internal.databinding.conversion.NumberToBigIntegerConverter;
import org.eclipse.core.internal.databinding.conversion.NumberToByteConverter;
import org.eclipse.core.internal.databinding.conversion.NumberToDoubleConverter;
import org.eclipse.core.internal.databinding.conversion.NumberToFloatConverter;
import org.eclipse.core.internal.databinding.conversion.NumberToIntegerConverter;
import org.eclipse.core.internal.databinding.conversion.NumberToLongConverter;
import org.eclipse.core.internal.databinding.conversion.NumberToNumberConverter;
import org.eclipse.core.internal.databinding.conversion.NumberToShortConverter;
import org.eclipse.core.internal.databinding.conversion.StringToCharacterConverter;
import org.eclipse.core.internal.databinding.conversion.StringToDateConverter;
import org.eclipse.core.internal.databinding.validation.NumberFormatConverter;
import org.eclipse.core.internal.databinding.validation.NumberToByteValidator;
import org.eclipse.core.internal.databinding.validation.NumberToDoubleValidator;
import org.eclipse.core.internal.databinding.validation.NumberToFloatValidator;
import org.eclipse.core.internal.databinding.validation.NumberToIntegerValidator;
import org.eclipse.core.internal.databinding.validation.NumberToLongValidator;
import org.eclipse.core.internal.databinding.validation.NumberToShortValidator;
import org.eclipse.core.internal.databinding.validation.NumberToUnboundedNumberValidator;
import org.eclipse.core.internal.databinding.validation.ObjectToPrimitiveValidator;
import org.eclipse.core.internal.databinding.validation.StringToByteValidator;
import org.eclipse.core.internal.databinding.validation.StringToCharacterValidator;
import org.eclipse.core.internal.databinding.validation.StringToDateValidator;
import org.eclipse.core.internal.databinding.validation.StringToDoubleValidator;
import org.eclipse.core.internal.databinding.validation.StringToFloatValidator;
import org.eclipse.core.internal.databinding.validation.StringToIntegerValidator;
import org.eclipse.core.internal.databinding.validation.StringToLongValidator;
import org.eclipse.core.internal.databinding.validation.StringToShortValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class UpdateValueStrategy<S, D>
extends UpdateStrategy<S, D> {
    public static int POLICY_NEVER = UpdateValueStrategy.notInlined(1);
    public static int POLICY_ON_REQUEST = UpdateValueStrategy.notInlined(2);
    public static int POLICY_CONVERT = UpdateValueStrategy.notInlined(4);
    public static int POLICY_UPDATE = UpdateValueStrategy.notInlined(8);
    protected IValidator<? super S> afterGetValidator;
    protected IValidator<? super D> afterConvertValidator;
    protected IValidator<? super D> beforeSetValidator;
    private int updatePolicy;
    private static ValidatorRegistry validatorRegistry = new ValidatorRegistry();
    private static HashMap<IConverter<?, ?>, IValidator<?>> validatorsByConverter = new HashMap();
    protected boolean provideDefaults;
    private boolean defaultedConverter = false;

    private static int notInlined(int i) {
        return i;
    }

    public UpdateValueStrategy() {
        this(true, POLICY_UPDATE);
    }

    public UpdateValueStrategy(int updatePolicy) {
        this(true, updatePolicy);
    }

    public UpdateValueStrategy(boolean provideDefaults, int updatePolicy) {
        this.provideDefaults = provideDefaults;
        this.updatePolicy = updatePolicy;
    }

    protected IValidator<S> createValidator(Object fromType, Object toType) {
        if (fromType == null || toType == null) {
            return value -> Status.OK_STATUS;
        }
        return this.findValidator(fromType, toType);
    }

    protected void fillDefaults(IObservableValue<? extends S> source, IObservableValue<? super D> destination) {
        Object sourceType = source.getValueType();
        Object destinationType = destination.getValueType();
        if (this.provideDefaults && sourceType != null && destinationType != null) {
            if (this.converter == null) {
                IConverter<?, ?> converter = this.createConverter(sourceType, destinationType);
                this.defaultedConverter = converter != null;
                this.setConverter(converter);
            }
            if (this.afterGetValidator == null) {
                this.afterGetValidator = this.createValidator(sourceType, destinationType);
            }
        }
        if (this.converter != null) {
            if (sourceType != null) {
                this.checkAssignable(this.converter.getFromType(), sourceType, "converter does not convert from type " + sourceType);
            }
            if (destinationType != null) {
                this.checkAssignable(destinationType, this.converter.getToType(), "converter does not convert to type " + destinationType);
            }
        }
    }

    private IValidator<S> findValidator(Object fromType, Object toType) {
        IValidator result = null;
        if (this.defaultedConverter) {
            if (String.class.equals(fromType)) {
                result = validatorsByConverter.get(this.converter);
                if (result == null) {
                    if (Integer.class.equals(toType) || Integer.TYPE.equals(toType)) {
                        result = new StringToIntegerValidator((NumberFormatConverter)this.converter);
                    } else if (Long.class.equals(toType) || Long.TYPE.equals(toType)) {
                        result = new StringToLongValidator((NumberFormatConverter)this.converter);
                    } else if (Float.class.equals(toType) || Float.TYPE.equals(toType)) {
                        result = new StringToFloatValidator((NumberFormatConverter)this.converter);
                    } else if (Double.class.equals(toType) || Double.TYPE.equals(toType)) {
                        result = new StringToDoubleValidator((NumberFormatConverter)this.converter);
                    } else if (Byte.class.equals(toType) || Byte.TYPE.equals(toType)) {
                        result = new StringToByteValidator((NumberFormatConverter)this.converter);
                    } else if (Short.class.equals(toType) || Short.TYPE.equals(toType)) {
                        result = new StringToShortValidator((NumberFormatConverter)this.converter);
                    } else if (Character.class.equals(toType) || Character.TYPE.equals(toType) && this.converter instanceof StringToCharacterConverter) {
                        result = new StringToCharacterValidator((StringToCharacterConverter)this.converter);
                    } else if (Date.class.equals(toType) && this.converter instanceof StringToDateConverter) {
                        result = new StringToDateValidator((StringToDateConverter)this.converter);
                    }
                    if (result != null) {
                        validatorsByConverter.put(this.converter, result);
                    }
                }
            } else if (this.converter instanceof NumberToNumberConverter && (result = validatorsByConverter.get(this.converter)) == null) {
                if (this.converter instanceof NumberToByteConverter) {
                    result = new NumberToByteValidator((NumberToByteConverter)this.converter);
                } else if (this.converter instanceof NumberToShortConverter) {
                    result = new NumberToShortValidator((NumberToShortConverter)this.converter);
                } else if (this.converter instanceof NumberToIntegerConverter) {
                    result = new NumberToIntegerValidator((NumberToIntegerConverter)this.converter);
                } else if (this.converter instanceof NumberToLongConverter) {
                    result = new NumberToLongValidator((NumberToLongConverter)this.converter);
                } else if (this.converter instanceof NumberToFloatConverter) {
                    result = new NumberToFloatValidator((NumberToFloatConverter)this.converter);
                } else if (this.converter instanceof NumberToDoubleConverter) {
                    result = new NumberToDoubleValidator((NumberToDoubleConverter)this.converter);
                } else if (this.converter instanceof NumberToBigIntegerConverter || this.converter instanceof NumberToBigDecimalConverter) {
                    result = new NumberToUnboundedNumberValidator((NumberToNumberConverter)this.converter);
                }
            }
            if (result == null) {
                result = UpdateValueStrategy.validatorRegistry.get(fromType, toType);
            }
        }
        return result;
    }

    public int getUpdatePolicy() {
        return this.updatePolicy;
    }

    public UpdateValueStrategy<S, D> setAfterConvertValidator(IValidator<? super D> validator) {
        this.afterConvertValidator = validator;
        return this;
    }

    public UpdateValueStrategy<S, D> setAfterGetValidator(IValidator<? super S> validator) {
        this.afterGetValidator = validator;
        return this;
    }

    public UpdateValueStrategy<S, D> setBeforeSetValidator(IValidator<? super D> validator) {
        this.beforeSetValidator = validator;
        return this;
    }

    public UpdateValueStrategy<S, D> setConverter(IConverter<? super S, ? extends D> converter) {
        this.converter = converter;
        return this;
    }

    public IStatus validateAfterConvert(D value) {
        return this.afterConvertValidator == null ? Status.OK_STATUS : this.afterConvertValidator.validate(value);
    }

    public IStatus validateAfterGet(S value) {
        return this.afterGetValidator == null ? Status.OK_STATUS : this.afterGetValidator.validate(value);
    }

    public IStatus validateBeforeSet(D value) {
        return this.beforeSetValidator == null ? Status.OK_STATUS : this.beforeSetValidator.validate(value);
    }

    protected IStatus doSet(IObservableValue<? super D> observableValue, D value) {
        try {
            observableValue.setValue(value);
        }
        catch (Exception ex) {
            return this.logErrorWhileSettingValue(ex);
        }
        return Status.OK_STATUS;
    }

    public static <S, D> UpdateValueStrategy<S, D> create(IConverter<S, D> converter) {
        return new UpdateValueStrategy<S, D>().setConverter(converter);
    }

    private static class ValidatorRegistry {
        private Map<Pair, IValidator<?>> validators = new HashMap();

        private ValidatorRegistry() {
            this.associate(Integer.class, Integer.TYPE, new ObjectToPrimitiveValidator(Integer.TYPE));
            this.associate(Byte.class, Byte.TYPE, new ObjectToPrimitiveValidator(Byte.TYPE));
            this.associate(Short.class, Short.TYPE, new ObjectToPrimitiveValidator(Short.TYPE));
            this.associate(Long.class, Long.TYPE, new ObjectToPrimitiveValidator(Long.TYPE));
            this.associate(Float.class, Float.TYPE, new ObjectToPrimitiveValidator(Float.TYPE));
            this.associate(Double.class, Double.TYPE, new ObjectToPrimitiveValidator(Double.TYPE));
            this.associate(Boolean.class, Boolean.TYPE, new ObjectToPrimitiveValidator(Boolean.TYPE));
            this.associate(Object.class, Integer.TYPE, new ObjectToPrimitiveValidator(Integer.TYPE));
            this.associate(Object.class, Byte.TYPE, new ObjectToPrimitiveValidator(Byte.TYPE));
            this.associate(Object.class, Short.TYPE, new ObjectToPrimitiveValidator(Short.TYPE));
            this.associate(Object.class, Long.TYPE, new ObjectToPrimitiveValidator(Long.TYPE));
            this.associate(Object.class, Float.TYPE, new ObjectToPrimitiveValidator(Float.TYPE));
            this.associate(Object.class, Double.TYPE, new ObjectToPrimitiveValidator(Double.TYPE));
            this.associate(Object.class, Boolean.TYPE, new ObjectToPrimitiveValidator(Boolean.TYPE));
        }

        private void associate(Object fromClass, Object toClass, IValidator<?> validator) {
            this.validators.put(new Pair(fromClass, toClass), validator);
        }

        private IValidator<?> get(Object fromClass, Object toClass) {
            IValidator<?> result = this.validators.get(new Pair(fromClass, toClass));
            if (result != null) {
                return result;
            }
            if (fromClass != null && toClass != null && fromClass == toClass) {
                return value -> Status.OK_STATUS;
            }
            return value -> Status.OK_STATUS;
        }
    }
}

