/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.stream.page;

import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.tools.transfer.internal.DTMessages;
import org.jkiss.dbeaver.tools.transfer.stream.StreamConsumerSettings;
import org.jkiss.dbeaver.tools.transfer.wizard.DataTransferWizard;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;
import org.jkiss.dbeaver.ui.dialogs.DialogUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class StreamConsumerPageOutput
extends ActiveWizardPage<DataTransferWizard> {
    private Combo encodingCombo;
    private Label encodingBOMLabel;
    private Button encodingBOMCheckbox;
    private Text directoryText;
    private Text fileNameText;
    private Button compressCheckbox;
    private Button showFolderCheckbox;
    private Button execProcessCheckbox;
    private Text execProcessText;
    private Button clipboardCheck;
    private Button singleFileCheck;
    private Button showFinalMessageCheckbox;

    public StreamConsumerPageOutput() {
        super(DTMessages.data_transfer_wizard_output_name);
        this.setTitle(DTMessages.data_transfer_wizard_output_title);
        this.setDescription(DTMessages.data_transfer_wizard_output_description);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        composite.setLayout((Layout)gl);
        composite.setLayoutData((Object)new GridData(1808));
        final StreamConsumerSettings settings = ((DataTransferWizard)this.getWizard()).getPageSettings((IWizardPage)this, StreamConsumerSettings.class);
        Group generalSettings = UIUtils.createControlGroup((Composite)composite, (String)DTMessages.data_transfer_wizard_output_group_general, (int)5, (int)768, (int)0);
        this.clipboardCheck = UIUtils.createLabelCheckbox((Composite)generalSettings, (String)DTMessages.data_transfer_wizard_output_label_copy_to_clipboard, (boolean)false);
        this.clipboardCheck.setLayoutData((Object)new GridData(1, 1, false, false, 4, 1));
        this.clipboardCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setOutputClipboard(StreamConsumerPageOutput.this.clipboardCheck.getSelection());
                StreamConsumerPageOutput.this.toggleClipboardOutput();
                StreamConsumerPageOutput.this.updatePageCompletion();
            }
        });
        this.singleFileCheck = UIUtils.createLabelCheckbox((Composite)generalSettings, (String)DTMessages.data_transfer_wizard_output_label_use_single_file, (String)DTMessages.data_transfer_wizard_output_label_use_single_file_tip, (boolean)false);
        this.singleFileCheck.setLayoutData((Object)new GridData(1, 1, false, false, 4, 1));
        this.singleFileCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setUseSingleFile(StreamConsumerPageOutput.this.singleFileCheck.getSelection());
                StreamConsumerPageOutput.this.updatePageCompletion();
            }
        });
        this.directoryText = DialogUtils.createOutputFolderChooser((Composite)generalSettings, null, e -> {
            settings.setOutputFolder(this.directoryText.getText());
            this.updatePageCompletion();
        });
        ((GridData)this.directoryText.getParent().getLayoutData()).horizontalSpan = 4;
        UIUtils.createControlLabel((Composite)generalSettings, (String)DTMessages.data_transfer_wizard_output_label_file_name_pattern);
        this.fileNameText = new Text((Composite)generalSettings, 2048);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 4;
        UIUtils.setContentProposalToolTip((Control)this.fileNameText, (String)"Output file name pattern", (String[])new String[]{"datasource", "catalog", "schema", "table", "timestamp", "date", "project"});
        this.fileNameText.setLayoutData((Object)gd);
        this.fileNameText.addModifyListener(e -> {
            settings.setOutputFilePattern(this.fileNameText.getText());
            this.updatePageCompletion();
        });
        UIUtils.installContentProposal((Control)this.fileNameText, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)new SimpleContentProposalProvider(new String[]{GeneralUtils.variablePattern((String)"datasource"), GeneralUtils.variablePattern((String)"catalog"), GeneralUtils.variablePattern((String)"schema"), GeneralUtils.variablePattern((String)"table"), GeneralUtils.variablePattern((String)"timestamp"), GeneralUtils.variablePattern((String)"date"), GeneralUtils.variablePattern((String)"project")}));
        UIUtils.createControlLabel((Composite)generalSettings, (String)DTMessages.data_transfer_wizard_output_label_encoding);
        this.encodingCombo = UIUtils.createEncodingCombo((Composite)generalSettings, (String)settings.getOutputEncoding());
        this.encodingCombo.addModifyListener(e -> {
            int index = this.encodingCombo.getSelectionIndex();
            if (index >= 0) {
                settings.setOutputEncoding(this.encodingCombo.getItem(index));
            }
            this.updatePageCompletion();
        });
        this.encodingBOMLabel = UIUtils.createControlLabel((Composite)generalSettings, (String)DTMessages.data_transfer_wizard_output_label_insert_bom);
        this.encodingBOMLabel.setToolTipText(DTMessages.data_transfer_wizard_output_label_insert_bom_tooltip);
        this.encodingBOMCheckbox = new Button((Composite)generalSettings, 32);
        this.encodingBOMCheckbox.setLayoutData((Object)new GridData(128, 2, true, false, 1, 1));
        this.encodingBOMCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setOutputEncodingBOM(StreamConsumerPageOutput.this.encodingBOMCheckbox.getSelection());
            }
        });
        new Label((Composite)generalSettings, 0);
        this.compressCheckbox = UIUtils.createLabelCheckbox((Composite)generalSettings, (String)DTMessages.data_transfer_wizard_output_checkbox_compress, (boolean)false);
        this.compressCheckbox.setLayoutData((Object)new GridData(32, 2, true, false, 4, 1));
        this.compressCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setCompressResults(StreamConsumerPageOutput.this.compressCheckbox.getSelection());
            }
        });
        Group resultsSettings = UIUtils.createControlGroup((Composite)composite, (String)"Results", (int)2, (int)768, (int)0);
        this.showFolderCheckbox = UIUtils.createCheckbox((Composite)resultsSettings, (String)DTMessages.data_transfer_wizard_output_checkbox_open_folder, (boolean)true);
        this.showFolderCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setOpenFolderOnFinish(StreamConsumerPageOutput.this.showFolderCheckbox.getSelection());
            }
        });
        this.showFolderCheckbox.setLayoutData((Object)new GridData(32, 2, false, false, 2, 1));
        this.execProcessCheckbox = UIUtils.createCheckbox((Composite)resultsSettings, (String)"Execute process on finish", (boolean)true);
        this.execProcessCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setExecuteProcessOnFinish(StreamConsumerPageOutput.this.execProcessCheckbox.getSelection());
                StreamConsumerPageOutput.this.toggleExecProcessControls();
                StreamConsumerPageOutput.this.updatePageCompletion();
            }
        });
        this.execProcessText = new Text((Composite)resultsSettings, 2048);
        this.execProcessText.setLayoutData((Object)new GridData(768));
        this.execProcessText.addModifyListener(e -> {
            settings.setFinishProcessCommand(this.execProcessText.getText());
            this.updatePageCompletion();
        });
        UIUtils.setContentProposalToolTip((Control)this.execProcessText, (String)"Process command line", (String[])new String[]{"file", "table", "timestamp", "date", "project"});
        UIUtils.installContentProposal((Control)this.execProcessText, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)new SimpleContentProposalProvider(new String[]{GeneralUtils.variablePattern((String)"table"), GeneralUtils.variablePattern((String)"timestamp"), GeneralUtils.variablePattern((String)"date"), GeneralUtils.variablePattern((String)"project"), GeneralUtils.variablePattern((String)"file")}));
        this.showFinalMessageCheckbox = UIUtils.createCheckbox((Composite)resultsSettings, (String)"Show finish message", null, (boolean)((DataTransferWizard)this.getWizard()).getSettings().isShowFinalMessage(), (int)4);
        this.showFinalMessageCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((DataTransferWizard)StreamConsumerPageOutput.this.getWizard()).getSettings().setShowFinalMessage(StreamConsumerPageOutput.this.showFinalMessageCheckbox.getSelection());
            }
        });
        this.setControl((Control)composite);
    }

    private void toggleClipboardOutput() {
        boolean isBinary = ((DataTransferWizard)this.getWizard()).getSettings().getProcessor().isBinaryFormat();
        boolean clipboard = !isBinary && this.clipboardCheck.getSelection();
        boolean isMulti = ((DataTransferWizard)this.getWizard()).getSettings().getDataPipes().size() > 1;
        this.clipboardCheck.setEnabled(!isBinary);
        this.singleFileCheck.setEnabled(isMulti && !clipboard && ((DataTransferWizard)this.getWizard()).getSettings().getMaxJobCount() <= 1);
        this.directoryText.setEnabled(!clipboard);
        this.fileNameText.setEnabled(!clipboard);
        this.compressCheckbox.setEnabled(!clipboard);
        this.encodingCombo.setEnabled(!isBinary && !clipboard);
        this.encodingBOMLabel.setEnabled(!isBinary && !clipboard);
        this.encodingBOMCheckbox.setEnabled(!isBinary && !clipboard);
        this.showFolderCheckbox.setEnabled(!clipboard);
        this.execProcessCheckbox.setEnabled(!clipboard);
        this.execProcessText.setEnabled(!clipboard);
    }

    private void toggleExecProcessControls() {
        boolean clipboard = this.clipboardCheck.getSelection();
        boolean isExecCommand = this.execProcessCheckbox.getSelection();
        this.execProcessText.setEnabled(!clipboard && isExecCommand);
    }

    public void activatePage() {
        boolean isBinary = ((DataTransferWizard)this.getWizard()).getSettings().getProcessor().isBinaryFormat();
        StreamConsumerSettings settings = ((DataTransferWizard)this.getWizard()).getPageSettings((IWizardPage)this, StreamConsumerSettings.class);
        this.clipboardCheck.setSelection(settings.isOutputClipboard());
        this.singleFileCheck.setSelection(settings.isUseSingleFile());
        this.directoryText.setText(CommonUtils.toString((Object)settings.getOutputFolder()));
        this.fileNameText.setText(CommonUtils.toString((Object)settings.getOutputFilePattern()));
        this.compressCheckbox.setSelection(settings.isCompressResults());
        this.encodingCombo.setText(CommonUtils.toString((Object)settings.getOutputEncoding()));
        this.encodingBOMCheckbox.setSelection(settings.isOutputEncodingBOM());
        this.showFolderCheckbox.setSelection(settings.isOpenFolderOnFinish());
        this.execProcessCheckbox.setSelection(settings.isExecuteProcessOnFinish());
        this.execProcessText.setText(CommonUtils.toString((Object)settings.getFinishProcessCommand()));
        if (isBinary) {
            this.clipboardCheck.setSelection(false);
            this.encodingBOMCheckbox.setSelection(false);
            settings.setOutputClipboard(false);
        }
        this.showFinalMessageCheckbox.setSelection(((DataTransferWizard)this.getWizard()).getSettings().isShowFinalMessage());
        this.updatePageCompletion();
        this.toggleClipboardOutput();
        this.toggleExecProcessControls();
    }

    protected boolean determinePageCompletion() {
        StreamConsumerSettings settings = ((DataTransferWizard)this.getWizard()).getPageSettings((IWizardPage)this, StreamConsumerSettings.class);
        if (settings.isOutputClipboard()) {
            return true;
        }
        boolean valid = true;
        if (CommonUtils.isEmpty((String)settings.getOutputFolder())) {
            valid = false;
        }
        if (CommonUtils.isEmpty((String)settings.getOutputFilePattern())) {
            valid = false;
        }
        if (settings.isExecuteProcessOnFinish() && CommonUtils.isEmpty((String)settings.getFinishProcessCommand())) {
            return false;
        }
        return valid;
    }
}

