/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.handlers;

import java.util.Locale;
import org.eclipse.core.resources.IFile;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;
import org.jkiss.dbeaver.tools.transfer.IDataTransferNode;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.handlers.DataTransferHandler;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferNodeDescriptor;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferProcessorDescriptor;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferRegistry;
import org.jkiss.dbeaver.tools.transfer.stream.StreamTransferProducer;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class DataImportHandler
extends DataTransferHandler {
    @Override
    protected IDataTransferNode adaptTransferNode(Object object) {
        DBSDataManipulator adapted = (DBSDataManipulator)RuntimeUtils.getObjectAdapter((Object)object, DBSDataManipulator.class);
        if (adapted != null) {
            return new DatabaseTransferConsumer(adapted);
        }
        IFile file = (IFile)RuntimeUtils.getObjectAdapter((Object)object, IFile.class);
        if (file != null) {
            return this.getNodeByFile(file);
        }
        return null;
    }

    private IDataTransferNode getNodeByFile(IFile file) {
        DataTransferProcessorDescriptor processor = this.getProcessorByFile(file);
        if (processor != null) {
            return new StreamTransferProducer(file.getFullPath().toFile(), processor);
        }
        return null;
    }

    private DataTransferProcessorDescriptor getProcessorByFile(IFile file) {
        String extension = file.getFileExtension();
        if (CommonUtils.isEmpty((String)extension)) {
            return null;
        }
        extension = extension.toLowerCase(Locale.ENGLISH);
        DataTransferNodeDescriptor producerDesc = DataTransferRegistry.getInstance().getNodeById("stream_producer");
        if (producerDesc != null) {
            for (DataTransferProcessorDescriptor processor : producerDesc.getProcessors()) {
                Object[] defExtensions;
                DBPPropertyDescriptor extList = processor.getProperty("extension");
                if (extList == null || !ArrayUtils.contains((Object[])(defExtensions = CommonUtils.split((String)CommonUtils.toString((Object)extList.getDefaultValue()), (String)",")), (Object)extension)) continue;
                return processor;
            }
        }
        return null;
    }
}

