/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.driver;

import java.io.File;
import java.util.Collections;
import java.util.Set;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.connection.DBPDriverLibrary;
import org.jkiss.dbeaver.registry.driver.DriverDependencies;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.HelpEnabledDialog;
import org.jkiss.dbeaver.ui.dialogs.driver.DriverDependenciesTree;
import org.jkiss.utils.CommonUtils;

public class DriverLibraryDetailsDialog
extends HelpEnabledDialog {
    private static final String DIALOG_ID = "DBeaver.DriverLibraryDetailsDialog";
    private DBPDriver driver;
    private DBPDriverLibrary library;

    public DriverLibraryDetailsDialog(Shell shell, DBPDriver driver, DBPDriverLibrary library) {
        super(shell, "database-drivers");
        this.driver = driver;
        this.library = library;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getDialogSettings((String)DIALOG_ID);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(NLS.bind((String)CoreMessages.dialog_edit_driver_text_driver_library, (Object)this.driver.getName(), (Object)this.library.getDisplayName()));
        this.getShell().setImage(DBeaverIcons.getImage((DBPImage)this.library.getIcon()));
        Composite group = (Composite)super.createDialogArea(parent);
        GridData gd = new GridData(1808);
        gd.widthHint = 500;
        group.setLayoutData((Object)gd);
        Group propsGroup = UIUtils.createControlGroup((Composite)group, (String)CoreMessages.dialog_edit_driver_info, (int)2, (int)-1, (int)-1);
        propsGroup.setLayoutData((Object)new GridData(768));
        UIUtils.createLabelText((Composite)propsGroup, (String)CoreMessages.dialog_edit_driver_driver, (String)this.driver.getName(), (int)2056);
        UIUtils.createLabelText((Composite)propsGroup, (String)CoreMessages.dialog_edit_driver_library, (String)this.library.getDisplayName(), (int)2056);
        UIUtils.createLabelText((Composite)propsGroup, (String)CoreMessages.dialog_edit_driver_path, (String)this.library.getPath(), (int)2056);
        UIUtils.createLabelText((Composite)propsGroup, (String)CoreMessages.dialog_edit_driver_version, (String)this.library.getVersion(), (int)2056);
        Text fileText = UIUtils.createLabelText((Composite)propsGroup, (String)CoreMessages.dialog_edit_driver_file, (String)"", (int)2056);
        TabFolder tabs = new TabFolder(group, 0x800100);
        tabs.setLayoutData((Object)new GridData(1808));
        this.createDependenciesTab(tabs);
        this.createLicenseTab(tabs);
        this.createDetailsTab(tabs);
        File localFile = this.library.getLocalFile();
        if (localFile != null) {
            fileText.setText(localFile.getAbsolutePath());
        }
        return group;
    }

    private void createDependenciesTab(TabFolder tabs) {
        Composite paramsGroup = new Composite((Composite)tabs, 0);
        paramsGroup.setLayout((Layout)new GridLayout(1, false));
        Set<DBPDriverLibrary> libList = Collections.singleton(this.library);
        DriverDependencies dependencies = new DriverDependencies(libList);
        final DriverDependenciesTree depsTree = new DriverDependenciesTree(paramsGroup, UIUtils.getDefaultRunnableContext(), dependencies, this.driver, libList, false);
        depsTree.resolveLibraries();
        UIUtils.asyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                depsTree.resizeTree();
            }
        });
        TabItem depsTab = new TabItem(tabs, 0);
        depsTab.setText(CoreMessages.dialog_edit_driver_tab_depencencies);
        depsTab.setToolTipText(CoreMessages.dialog_edit_driver_tab_depencencies_tooltip);
        depsTab.setControl((Control)paramsGroup);
    }

    private void createDetailsTab(TabFolder tabs) {
        Composite detailsGroup = new Composite((Composite)tabs, 0);
        detailsGroup.setLayout((Layout)new GridLayout(1, false));
        UIUtils.createControlLabel((Composite)detailsGroup, (String)CoreMessages.dialog_edit_driver_label_description);
        Text descriptionText = new Text(detailsGroup, 2056);
        descriptionText.setText(CommonUtils.notEmpty((String)this.library.getDescription()));
        GridData gd = new GridData(768);
        gd.heightHint = 40;
        descriptionText.setLayoutData((Object)gd);
        TabItem detailsTab = new TabItem(tabs, 0);
        detailsTab.setText(CoreMessages.dialog_edit_driver_tab_detail);
        detailsTab.setToolTipText(CoreMessages.dialog_edit_driver_tab_detail_tooltip);
        detailsTab.setControl((Control)detailsGroup);
    }

    private void createLicenseTab(TabFolder group) {
        Composite paramsGroup = new Composite((Composite)group, 0);
        paramsGroup.setLayout((Layout)new GridLayout(1, false));
        Text licenseText = new Text(paramsGroup, 2626);
        licenseText.setText(CoreMessages.dialog_edit_driver_text_license);
        licenseText.setEditable(false);
        licenseText.setMessage(CoreMessages.dialog_edit_driver_text_driver_license);
        GridData gd = new GridData(1808);
        gd.heightHint = 200;
        licenseText.setLayoutData((Object)gd);
        TabItem paramsTab = new TabItem(group, 0);
        paramsTab.setText(CoreMessages.dialog_edit_driver_tab_name_license);
        paramsTab.setToolTipText(CoreMessages.dialog_edit_driver_tab_tooltip_license);
        paramsTab.setControl((Control)paramsGroup);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, true);
    }

    protected void buttonPressed(int buttonId) {
        super.okPressed();
    }
}

