/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.debug.ui.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ui.UIUtils;

public class DebugUIEventListener
implements IDebugEventSetListener {
    private static final Log log = Log.getLog(DebugUIEventListener.class);

    public void handleDebugEvents(DebugEvent[] events) {
        DebugEvent[] debugEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            DebugEvent event = debugEventArray[n2];
            switch (event.getKind()) {
                case 2: {
                    this.showDebugViews(true);
                    break;
                }
                case 8: {
                    this.showDebugViews(false);
                }
            }
            ++n2;
        }
    }

    private void showDebugViews(boolean show) {
        IWorkbenchWindow window = UIUtils.getActiveWorkbenchWindow();
        IWorkbenchPage activePage = window.getActivePage();
        if (!"org.jkiss.dbeaver.core.perspective".equals(activePage.getPerspective().getId())) {
            return;
        }
        UIUtils.asyncExec(() -> {
            try {
                if (show) {
                    activePage.showView("org.eclipse.debug.ui.VariableView");
                    activePage.showView("org.eclipse.debug.ui.BreakpointView");
                } else {
                    this.hideView(activePage, "org.eclipse.debug.ui.VariableView");
                    this.hideView(activePage, "org.eclipse.debug.ui.BreakpointView");
                }
            }
            catch (CoreException e) {
                log.log(e.getStatus());
            }
        });
    }

    private void hideView(IWorkbenchPage activePage, String viewId) {
        IViewPart view = activePage.findView(viewId);
        if (view != null) {
            activePage.hideView(view);
        }
    }
}

