/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui;

import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.commands.ToggleState;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandImageService;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.services.IEvaluationService;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;

public class ActionUtils {
    private static final Log log = Log.getLog(ActionUtils.class);

    public static CommandContributionItem makeCommandContribution(@NotNull IServiceLocator serviceLocator, @NotNull String commandId) {
        return ActionUtils.makeCommandContribution(serviceLocator, commandId, 8);
    }

    public static CommandContributionItem makeCommandContribution(@NotNull IServiceLocator serviceLocator, @NotNull String commandId, int style) {
        return new CommandContributionItem(new CommandContributionItemParameter(serviceLocator, null, commandId, style));
    }

    public static CommandContributionItem makeCommandContribution(@NotNull IServiceLocator serviceLocator, @NotNull String commandId, int style, @Nullable DBPImage icon) {
        CommandContributionItemParameter parameters = new CommandContributionItemParameter(serviceLocator, null, commandId, style);
        parameters.icon = DBeaverIcons.getImageDescriptor(icon);
        return new CommandContributionItem(parameters);
    }

    public static CommandContributionItem makeCommandContribution(IServiceLocator serviceLocator, String commandId, String name, DBPImage image) {
        return ActionUtils.makeCommandContribution(serviceLocator, commandId, name, image, null, false);
    }

    public static ContributionItem makeActionContribution(@NotNull IAction action, boolean showText) {
        ActionContributionItem item = new ActionContributionItem(action);
        if (showText) {
            item.setMode(ActionContributionItem.MODE_FORCE_TEXT);
        }
        return item;
    }

    public static ContributionItem makeActionContribution(@NotNull IAction action, DBPImage image) {
        ActionContributionItem item = new ActionContributionItem(action);
        if (image != null) {
            action.setImageDescriptor(DBeaverIcons.getImageDescriptor(image));
        }
        return item;
    }

    public static CommandContributionItem makeCommandContribution(@NotNull IServiceLocator serviceLocator, @NotNull String commandId, @Nullable String name, @Nullable DBPImage image, @Nullable String toolTip, boolean showText) {
        return ActionUtils.makeCommandContribution(serviceLocator, commandId, 8, name, image, toolTip, showText);
    }

    public static CommandContributionItem makeCommandContribution(@NotNull IServiceLocator serviceLocator, @NotNull String commandId, int style, @Nullable String name, @Nullable DBPImage image, @Nullable String toolTip, boolean showText) {
        CommandContributionItemParameter contributionParameters = new CommandContributionItemParameter(serviceLocator, null, commandId, null, image == null ? null : DBeaverIcons.getImageDescriptor(image), null, null, name, null, toolTip, style, null, false);
        if (showText) {
            contributionParameters.mode = CommandContributionItem.MODE_FORCE_TEXT;
        }
        return new CommandContributionItem(contributionParameters);
    }

    public static boolean isCommandEnabled(String commandId, IWorkbenchPartSite site) {
        if (commandId != null && site != null) {
            try {
                ICommandService commandService = (ICommandService)site.getService(ICommandService.class);
                if (commandService != null) {
                    Command command = commandService.getCommand(commandId);
                    return command != null && command.isEnabled();
                }
            }
            catch (Exception e) {
                log.error((Object)("Can't execute command '" + commandId + "'"), (Throwable)e);
            }
        }
        return false;
    }

    public static boolean isCommandChecked(String commandId, IWorkbenchPartSite site) {
        if (commandId != null && site != null) {
            try {
                ICommandService commandService = (ICommandService)site.getService(ICommandService.class);
                if (commandService != null) {
                    Command command = commandService.getCommand(commandId);
                    return command != null && command.getState(ToggleState.class.getName()) != null;
                }
            }
            catch (Exception e) {
                log.error((Object)("Can't execute command '" + commandId + "'"), (Throwable)e);
            }
        }
        return false;
    }

    @Nullable
    public static String findCommandName(String commandId) {
        Command command;
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        if (commandService != null && (command = commandService.getCommand(commandId)) != null && command.isDefined()) {
            try {
                return command.getName();
            }
            catch (NotDefinedException e) {
                log.debug((Object)e);
            }
        }
        return "???";
    }

    @Nullable
    public static ImageDescriptor findCommandImage(String commandId) {
        ICommandImageService commandService = (ICommandImageService)PlatformUI.getWorkbench().getService(ICommandImageService.class);
        if (commandService != null) {
            return commandService.getImageDescriptor(commandId);
        }
        return null;
    }

    @Nullable
    public static String findCommandDescription(String commandId, IServiceLocator serviceLocator, boolean shortcutOnly) {
        IBindingService bindingService;
        Command command;
        String commandName = null;
        String shortcut = null;
        ICommandService commandService = (ICommandService)serviceLocator.getService(ICommandService.class);
        if (commandService != null && (command = commandService.getCommand(commandId)) != null && command.isDefined()) {
            try {
                commandName = command.getName();
            }
            catch (NotDefinedException e) {
                log.debug((Object)e);
            }
        }
        if ((bindingService = (IBindingService)serviceLocator.getService(IBindingService.class)) != null) {
            TriggerSequence sequence = null;
            Binding[] bindingArray = bindingService.getBindings();
            int n = bindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                Binding b = bindingArray[n2];
                ParameterizedCommand parameterizedCommand = b.getParameterizedCommand();
                if (parameterizedCommand != null && commandId.equals(parameterizedCommand.getId())) {
                    sequence = b.getTriggerSequence();
                }
                ++n2;
            }
            if (sequence == null) {
                sequence = bindingService.getBestActiveBindingFor(commandId);
            }
            if (sequence != null) {
                shortcut = sequence.format();
            }
        }
        if (shortcutOnly) {
            return shortcut == null ? "?" : shortcut;
        }
        if (shortcut == null) {
            return commandName;
        }
        if (commandName == null) {
            return shortcut;
        }
        return String.valueOf(commandName) + " (" + shortcut + ")";
    }

    public static void runCommand(String commandId, IServiceLocator serviceLocator) {
        ActionUtils.runCommand(commandId, null, serviceLocator);
    }

    public static void runCommand(String commandId, ISelection selection, IServiceLocator serviceLocator) {
        if (commandId != null) {
            try {
                ICommandService commandService = (ICommandService)serviceLocator.getService(ICommandService.class);
                IHandlerService handlerService = (IHandlerService)serviceLocator.getService(IHandlerService.class);
                if (commandService != null) {
                    Command command = commandService.getCommand(commandId);
                    boolean needContextPatch = false;
                    if (selection != null) {
                        ISelection curSelection;
                        needContextPatch = true;
                        if (serviceLocator instanceof IWorkbenchSite && (curSelection = ((IWorkbenchSite)serviceLocator).getSelectionProvider().getSelection()) instanceof IStructuredSelection && selection instanceof IStructuredSelection && ((IStructuredSelection)curSelection).size() == ((IStructuredSelection)selection).size() && ((IStructuredSelection)curSelection).getFirstElement() == ((IStructuredSelection)selection).getFirstElement()) {
                            needContextPatch = false;
                        }
                    }
                    if (selection != null && needContextPatch) {
                        EvaluationContext context = new EvaluationContext(handlerService.createContextSnapshot(false), (Object)selection);
                        if (serviceLocator instanceof IWorkbenchPartSite) {
                            context.addVariable("activePart", (Object)((IWorkbenchPartSite)serviceLocator).getPart());
                        }
                        context.addVariable("selection", (Object)selection);
                        ParameterizedCommand pc = new ParameterizedCommand(command, null);
                        handlerService.executeCommandInContext(pc, null, (IEvaluationContext)context);
                    } else if (command != null) {
                        if (command.isEnabled()) {
                            handlerService.executeCommand(commandId, null);
                        } else {
                            log.warn((Object)("Command '" + commandId + "' is disabled"));
                        }
                    } else {
                        log.warn((Object)("Command '" + commandId + "' not found"));
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)("Can't execute command '" + commandId + "'"), (Throwable)e);
            }
        }
    }

    public static IAction makeAction(final @NotNull IActionDelegate actionDelegate, @Nullable IWorkbenchSite site, @Nullable ISelection selection, @Nullable String text, @Nullable ImageDescriptor image, @Nullable String toolTip) {
        Action actionImpl = new Action(){

            public void run() {
                actionDelegate.run((IAction)this);
            }
        };
        if (text != null) {
            actionImpl.setText(text);
        }
        if (image != null) {
            actionImpl.setImageDescriptor(image);
        }
        if (toolTip != null) {
            actionImpl.setToolTipText(toolTip);
        }
        actionDelegate.selectionChanged((IAction)actionImpl, selection);
        if (site != null) {
            if (actionDelegate instanceof IObjectActionDelegate && site instanceof IWorkbenchPartSite) {
                ((IObjectActionDelegate)actionDelegate).setActivePart((IAction)actionImpl, ((IWorkbenchPartSite)site).getPart());
            } else if (actionDelegate instanceof IWorkbenchWindowActionDelegate) {
                ((IWorkbenchWindowActionDelegate)actionDelegate).init(site.getWorkbenchWindow());
            }
        }
        return actionImpl;
    }

    public static void evaluatePropertyState(String propertyName) {
        IEvaluationService service = (IEvaluationService)PlatformUI.getWorkbench().getService(IEvaluationService.class);
        if (service != null) {
            try {
                service.requestEvaluation(propertyName);
            }
            catch (Exception exception) {
                log.warn((Object)("Error evaluating property [" + propertyName + "]"));
            }
        }
    }

    public static void fireCommandRefresh(String commandID) {
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        if (commandService != null) {
            UIUtils.asyncExec(() -> commandService.refreshElements(commandID, null));
        }
    }
}

