/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc.data.handlers;

import java.sql.SQLException;
import java.sql.Struct;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDComposite;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDValueHandlerComposite;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCStructImpl;
import org.jkiss.dbeaver.model.impl.jdbc.data.JDBCComposite;
import org.jkiss.dbeaver.model.impl.jdbc.data.JDBCCompositeDynamic;
import org.jkiss.dbeaver.model.impl.jdbc.data.JDBCCompositeStatic;
import org.jkiss.dbeaver.model.impl.jdbc.data.JDBCCompositeUnknown;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCComplexValueHandler;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class JDBCStructValueHandler
extends JDBCComplexValueHandler
implements DBDValueHandlerComposite {
    private static final Log log = Log.getLog(JDBCStructValueHandler.class);
    public static final JDBCStructValueHandler INSTANCE = new JDBCStructValueHandler();

    @Override
    @NotNull
    public synchronized String getValueDisplayString(@NotNull DBSTypedObject column, Object value, @NotNull DBDDisplayFormat format) {
        if (value instanceof JDBCComposite) {
            return ((JDBCComposite)value).getStringRepresentation();
        }
        return String.valueOf(value);
    }

    @NotNull
    public Class<JDBCComposite> getValueObjectType(@NotNull DBSTypedObject attribute) {
        return JDBCComposite.class;
    }

    @Override
    protected void bindParameter(JDBCSession session, JDBCPreparedStatement statement, DBSTypedObject paramType, int paramIndex, Object value) throws DBCException, SQLException {
        if (value == null) {
            statement.setNull(paramIndex, 2002);
        } else if (value instanceof DBDComposite) {
            DBDComposite struct = (DBDComposite)value;
            if (struct.isNull()) {
                statement.setNull(paramIndex, 2002);
            } else if (struct instanceof JDBCComposite) {
                statement.setObject(paramIndex, (Object)((JDBCComposite)struct).getStructValue(), 2002);
            } else {
                statement.setObject(paramIndex, struct.getRawValue());
            }
        } else {
            throw new DBCException("Struct parameter type '" + value.getClass().getName() + "' not supported");
        }
    }

    @Override
    public Object getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, Object object, boolean copy) throws DBCException {
        String typeName;
        try {
            typeName = object instanceof Struct ? ((Struct)object).getSQLTypeName() : type.getTypeName();
        }
        catch (SQLException e) {
            throw new DBCException(e, session.getDataSource());
        }
        DBSDataType dataType = null;
        try {
            dataType = DBUtils.resolveDataType(session.getProgressMonitor(), session.getDataSource(), typeName);
        }
        catch (DBException e) {
            log.debug("Error resolving data type '" + typeName + "'", e);
        }
        if (dataType == null) {
            if (object instanceof Struct) {
                return new JDBCCompositeDynamic(session, (Struct)object, null);
            }
            return new JDBCCompositeUnknown(session, object);
        }
        if (object == null) {
            return new JDBCCompositeStatic(session, dataType, new JDBCStructImpl(dataType.getTypeName(), null, ""));
        }
        if (object instanceof JDBCCompositeStatic) {
            return copy ? ((JDBCCompositeStatic)object).cloneValue(session.getProgressMonitor()) : object;
        }
        if (object instanceof Struct) {
            return new JDBCCompositeStatic(session, dataType, (Struct)object);
        }
        return new JDBCCompositeUnknown(session, object);
    }
}

